/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.trayinfo.client;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.trayinfo.common.TrayInfoLogin;
import ru.bitel.bgbilling.modules.trayinfo.common.TrayInfoType;
import ru.bitel.bgbilling.modules.trayinfo.common.service.TrayInfoService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;

public class LoginPanel
extends BGUPanel {
    private BGUTable table;
    private BGTableModel<TrayInfoLogin> model;
    private BGUComboBox<TrayInfoType> comboTypes = new BGUComboBox();
    private BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
    private BGTextField pin1 = new BGTextField();
    private BGTextField pin2 = new BGTextField();
    private BGControlPanelPeriodNoB period = new BGControlPanelPeriodNoB();
    private JPanel bottomPanel = new JPanel();
    private JPanel comboPanel;
    private JPanel periodPanel;
    protected TrayInfoLogin current;

    protected void jbInit() {
        this.model = new BGTableModel<TrayInfoLogin>("trayInfoLogin"){

            protected void initColumns() {
                this.addColumn("PIN1", 80, 80, -1, "login", true);
                this.addColumn("PIN2", 80, 80, -1, "password", false);
                this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 120, 120, -1, "period", true);
                this.addColumn("\u0414\u043e\u0433\u043e\u0432\u043e\u0440", 80, 100, -1, "contractTitle", true);
                this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", 100, 200, -1, "contractComment", true);
            }

            public Object getValue(TrayInfoLogin val, int column) throws BGException {
                if (column == 2) {
                    return TimeUtils.formatPeriod((Date)val.getDate1(), (Date)val.getDate2());
                }
                return super.getValue((Object)val, column);
            }
        };
        this.table = new BGUTable(this.model);
        JPanel editPanel = new JPanel();
        editPanel.setLayout(new GridBagLayout());
        editPanel.add((Component)new JLabel("PIN1"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        editPanel.add((Component)this.pin1, new GridBagConstraints(0, 1, 1, 1, 0.3, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        editPanel.add((Component)new JLabel("PIN2"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        editPanel.add((Component)this.pin2, new GridBagConstraints(1, 1, 1, 1, 0.3, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.comboPanel = new JPanel(new GridBagLayout());
        this.comboPanel.add((Component)new JLabel("\u0422\u0438\u043f"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.comboPanel.add((Component)this.comboTypes, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.periodPanel = new JPanel(new GridBagLayout());
        this.periodPanel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.periodPanel.add((Component)this.period, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.periodPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        editPanel.add((Component)this.periodPanel, new GridBagConstraints(2, 0, 1, 2, 0.4, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        editPanel.add((Component)this.comboPanel, new GridBagConstraints(3, 0, 1, 2, 0.4, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        editPanel.setBorder((Border)new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043b\u043e\u0433\u0438\u043d\u0430 "));
        this.bottomPanel.setLayout(new GridBagLayout());
        this.bottomPanel.add((Component)editPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.bottomPanel.add((Component)this.okCancel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 5), 0, 0));
        this.add(this.bottomPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
        ClientUtils.addOpenAction((Component)this.table, (AWTEventListener)new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                LoginPanel.this.performAction("edit");
            }
        });
        this.okCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    LoginPanel.this.stopEdit(e.getActionCommand().equals("ok"));
                }
                catch (BGException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.pin1.setEnabled(false);
        this.bottomPanel.setVisible(false);
    }

    private void startEdit() throws BGException {
        if (this.current.getLogin() > 0) {
            this.current = ((TrayInfoService)((ClientContext)this.getContext()).getPort(TrayInfoService.class)).getLogin(((ClientContext)this.getContext()).getContractId(), this.current.getLogin());
            this.pin1.setText(String.valueOf(this.current.getLogin()));
            this.pin2.setText(this.current.getPassword());
            this.period.setDateCalendar1(TimeUtils.convertDateToCalendar((Date)this.current.getDate1()));
            this.period.setDateCalendar2(TimeUtils.convertDateToCalendar((Date)this.current.getDate2()));
            List loginTypes = ((TrayInfoService)((ClientContext)this.getContext()).getPort(TrayInfoService.class)).getLoginTypes();
            this.comboTypes.setData(loginTypes);
            this.comboTypes.setSelectedItem((Object)this.current.getType());
            BGSwingUtilites.setEnabled((Component)this.comboPanel, (boolean)false);
            BGSwingUtilites.setEnabled((Component)this.periodPanel, (boolean)true);
        } else {
            this.pin1.setText("\u0411\u0443\u0434\u0435\u0442 \u0441\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u043d");
            this.pin2.setText("");
            this.period.setDateCalendar1((Calendar)new GregorianCalendar());
            this.period.setDateCalendar2(null);
            List loginTypes = ((TrayInfoService)((ClientContext)this.getContext()).getPort(TrayInfoService.class)).getLoginTypes();
            this.comboTypes.setData(loginTypes);
            BGSwingUtilites.setEnabled((Component)this.comboPanel, (boolean)true);
            BGSwingUtilites.setEnabled((Component)this.periodPanel, (boolean)false);
        }
        this.bottomPanel.setVisible(true);
    }

    private void stopEdit(boolean save) throws BGException {
        if (save) {
            if (Utils.isEmptyString((String)this.pin2.getText().trim())) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 PIN2!");
                return;
            }
            this.current.setType(((TrayInfoType)this.comboTypes.getSelectedItem()).getId());
            this.current.setPassword(this.pin2.getText());
            Date date1 = this.period.getDateFrom();
            Date date2 = this.period.getDateTo();
            if (date1 == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0447\u0430\u043b\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430!");
                return;
            }
            this.current.setDate1(date1);
            this.current.setDate2(date2);
            if (((ClientContext)this.getContext()).getContractId() <= 0) {
                ClientUtils.showErrorMessageDialog((String)"\u0421\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043c\u043e\u0436\u043d\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435");
                return;
            }
            this.current.setContractId(((ClientContext)this.getContext()).getContractId());
            ((TrayInfoService)((ClientContext)this.getContext()).getPort(TrayInfoService.class)).updateLogin(this.current);
            this.bottomPanel.setVisible(false);
        } else {
            this.bottomPanel.setVisible(false);
        }
        this.performAction("refresh");
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            List logins = ((TrayInfoService)((ClientContext)this.getContext()).getPort(TrayInfoService.class)).getLogins(((ClientContext)this.getContext()).getContractId());
            this.model.setData(logins);
        });
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            this.current = new TrayInfoLogin();
            if (this.current != null) {
                this.startEdit();
            }
        });
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            this.current = (TrayInfoLogin)this.model.getSelectedRow();
            if (this.current != null) {
                this.startEdit();
            }
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            TrayInfoLogin current = (TrayInfoLogin)this.model.getSelectedRow();
            if (current != null && ClientUtils.confirmDelete((Object)"\u043b\u043e\u0433\u0438\u043d")) {
                ((TrayInfoService)((ClientContext)this.getContext()).getPort(TrayInfoService.class)).deleteLogin(((ClientContext)this.getContext()).getContractId(), current.getLogin());
                this.performAction("refresh");
            }
        });
    }
}

