/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.bean;

import java.sql.Connection;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.directory.api.server.ServerDirectoryFactory;
import ru.bitel.bgbilling.modules.tv.common.bean.TvDevice;
import ru.bitel.bgbilling.modules.tv.common.bean.TvDeviceType;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrDaoSupport;
import ru.bitel.oss.kernel.entity.server.bean.TvDeviceEntityAttrDaoSupport;
import ru.bitel.oss.systems.inventory.resource.server.bean.DeviceDao;

public class TvDeviceDao
extends DeviceDao<TvDevice, TvDeviceType> {
    private final String deviceTypeTable;

    public TvDeviceDao(Connection con, int moduleId, int userId) throws BGException {
        super(con, moduleId, userId, "tv_device", (EntityAttrDaoSupport)new TvDeviceEntityAttrDaoSupport());
        this.deviceTypeTable = "tv_device_type_" + moduleId;
    }

    public TvDeviceDao(Connection con, int moduleId) throws BGException {
        this(con, moduleId, 0);
    }

    protected TvDevice newDevice() {
        return new TvDevice();
    }

    protected TvDeviceType newDeviceType(int id, String title) {
        return new TvDeviceType(id, title);
    }

    protected String getQueryById() {
        String query = "SELECT d.*, t.entitySpecId AS entitySpecId FROM " + this.tableName + " AS d LEFT JOIN `" + this.deviceTypeTable + "` AS t ON d.deviceTypeId=t.id WHERE d.id=?";
        return query;
    }

    protected Directory<TvDeviceType> getTypeDir() throws BGException {
        return ServerDirectoryFactory.newUnmodifiableDirectory(TvDeviceType.class, (Connection)this.con, (int)this.moduleId, (boolean)false);
    }
}

