/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.client.contract;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.tv.client.contract.ProductPanel;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.client.table.Column;
import ru.bitel.oss.systems.inventory.product.common.bean.Product;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductPeriod;
import ru.bitel.oss.systems.inventory.product.common.service.ProductService;

public class PeriodPanel
extends BGUPanel {
    private ProductPeriodTableModel model = new ProductPeriodTableModel();
    private ProductPanel productPanel;
    private Product currentProduct;
    private BGUTable table;
    AbstractBGUPanel.MenuAction periods = new AbstractBGUPanel.MenuAction("product.periods", "\u041f\u0435\u0440\u0438\u043e\u0434\u044b \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430", ClientUtils.getIcon((String)"fugue/clock-select")){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            PeriodPanel.this.currentProduct = (Product)PeriodPanel.this.productPanel.productModel.getSelectedRow();
            if (PeriodPanel.this.currentProduct == null) {
                return;
            }
            BGSwingUtilites.wrapBorder((JPanel)((Object)PeriodPanel.this), (String)" \u041f\u0435\u0440\u0438\u043e\u0434\u044b \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 ");
            PeriodPanel.this.performAction("refresh");
            PeriodPanel.this.performActionOpen();
            PeriodPanel.this.getActionMap().get("edit").setEnabled(true);
            PeriodPanel.this.getActionMap().get("delete").setEnabled(true);
        }
    };
    AbstractBGUPanel.MenuAction historyPeriods = new AbstractBGUPanel.MenuAction("productHistory.periods", "\u041f\u0435\u0440\u0438\u043e\u0434\u044b \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430", ClientUtils.getIcon((String)"fugue/clock-select")){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            PeriodPanel.this.currentProduct = (Product)PeriodPanel.this.productPanel.historyModel.getSelectedRow();
            if (PeriodPanel.this.currentProduct == null) {
                return;
            }
            BGSwingUtilites.wrapBorder((JPanel)((Object)PeriodPanel.this), (String)" \u041f\u0435\u0440\u0438\u043e\u0434\u044b \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 ");
            PeriodPanel.this.performAction("refresh");
            PeriodPanel.this.performActionOpen();
            PeriodPanel.this.getActionMap().get("edit").setEnabled(true);
            PeriodPanel.this.getActionMap().get("delete").setEnabled(true);
        }
    };

    public PeriodPanel(ProductPanel productPanel) {
        super((LayoutManager)new BorderLayout());
        this.productPanel = productPanel;
    }

    protected void jbInit() throws Exception {
        this.table = new BGUTable((TableModel)((Object)this.model));
        BGDialogToolBar dialogToolBar = new BGDialogToolBar();
        dialogToolBar.add(this.getActionMap().get("edit"));
        dialogToolBar.add(this.getActionMap().get("delete"));
        dialogToolBar.compact();
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)dialogToolBar, "South");
        panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 3, 0));
        this.add(panel, "North");
        this.add(new JScrollPane((Component)this.table), "Center");
        BGSwingUtilites.handleEdit((JTable)this.table, (AbstractBGUPanel)this);
    }

    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("close", "\u0417\u0430\u043a\u0440\u044b\u0442\u044c \u043f\u0430\u043d\u0435\u043b\u044c \"\u041f\u0435\u0440\u0438\u043e\u0434\u044b \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430\""){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                this.getParentAction().actionPerformed(e);
            }
        };
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            if (this.currentProduct == null) {
                return;
            }
            this.model.setData(((ProductService)((ClientContext)this.getContext()).getPort(ProductService.class, 0)).productPeriodList(this.currentProduct.getContractId(), this.currentProduct.getId()));
        });
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> this.showEditDialog(this.model, ProductPeriodEditor.class, "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0435\u0440\u0438\u043e\u0434\u0430 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430")).setIcon((Icon)ClientUtils.getIcon((String)"item_edit"));
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            ProductPeriod current = null;
            if (this.table.isShowing()) {
                current = (ProductPeriod)this.model.getSelectedRow();
            }
            if (current != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u0435\u0440\u0438\u043e\u0434 \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u0438 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                ((ProductService)((ClientContext)this.getContext()).getWebService(ProductService.class, 0)).productPeriodDelete(current.getContractId(), current.getId());
                this.performAction("refresh");
                this.performActionClose();
            }
        }).setIcon((Icon)ClientUtils.getIcon((String)"item_delete"));
    }

    class ProductPeriodTableModel
    extends BGTableModel<ProductPeriod> {
        public ProductPeriodTableModel() {
            super(ProductPeriodTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0412\u0440\u0435\u043c\u044f \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438", Column.DateTime.class, 200, 200, 200, "activationTime", true);
            this.addColumn("\u041d\u0430\u0447\u0430\u043b\u043e", Column.DateTime.class, 200, 200, 200, "timeFrom", true);
            this.addColumn("\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435", Column.DateTime.class, 200, 200, 200, "timeTo", true);
            this.addColumn("\u0412\u0440\u0435\u043c\u044f \u043f\u0440\u043e\u043b\u043e\u043d\u0433\u0430\u0446\u0438\u0438", Column.DateTime.class, 200, 200, 200, "prolongationTime", true);
            this.addColumn("\u0424\u043b\u0430\u0433\u0438", 200, 300, -1, "flags", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValueAt(ProductPeriod val, int column) throws BGException {
            String identifier;
            switch (identifier = this.getIdentifier(column)) {
                case "flags": {
                    Object flags = "";
                    flags = (String)flags + (String)((val.getFlags() & 1) != 0 ? (((String)flags).isEmpty() ? "" : ", ") + "\u041f\u0440\u0438\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d" : "");
                    flags = (String)flags + (String)((val.getFlags() & 2) != 0 ? (((String)flags).isEmpty() ? "" : ", ") + "\u0417\u0430\u043a\u0440\u044b\u0442" : "");
                    flags = (String)flags + (String)((val.getFlags() & 4) != 0 ? (((String)flags).isEmpty() ? "" : ", ") + "\u0417\u0430\u0432\u0435\u0440\u0448\u0430\u044e\u0449\u0438\u0439" : "");
                    flags = (String)flags + (String)((val.getFlags() & 8) != 0 ? (((String)flags).isEmpty() ? "" : ", ") + "\u041f\u0440\u043e\u043f\u043e\u0440\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u044b\u0439" : "");
                    return flags;
                }
            }
            return super.getValueAt((Object)val, column);
        }
    }

    public class ProductPeriodEditor
    extends BGEditorDialog<ProductPeriod> {
        private BGTextField dateFrom;
        private BGTextField dateTo;
        private JCheckBox suspended;
        private JCheckBox splitted;
        private JCheckBox proportional;
        private JCheckBox finished;

        public ProductPeriodEditor(String title, ProductPeriod data) {
            super(title, (Object)data);
            this.dateFrom = new BGTextField(15);
            this.dateTo = new BGTextField(15);
            this.suspended = new JCheckBox("\u043f\u0440\u0438\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d");
            this.splitted = new JCheckBox("\u0437\u0430\u043a\u0440\u044b\u0442");
            this.proportional = new JCheckBox("\u043f\u0440\u043e\u043f\u043e\u0440\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u044b\u0439");
            this.finished = new JCheckBox("\u0437\u0430\u0432\u0435\u0440\u0448\u0430\u044e\u0449\u0438\u0439");
        }

        public void doDialogPanel() {
            this.panel.add((Component)this.getPeriodPanel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.getFlagsPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 10, 0), 0, 0));
            this.dateFrom.setText(TimeUtils.format((Date)((ProductPeriod)this.data).getTimeFrom(), (String)"dd.MM.yyyy HH:mm:ss"));
            this.dateTo.setText(TimeUtils.format((Date)((ProductPeriod)this.data).getTimeTo(), (String)"dd.MM.yyyy HH:mm:ss"));
            this.suspended.setSelected((((ProductPeriod)this.data).getFlags() & 1) > 0);
            this.splitted.setSelected((((ProductPeriod)this.data).getFlags() & 2) > 0);
            this.proportional.setSelected((((ProductPeriod)this.data).getFlags() & 8) > 0);
            this.finished.setSelected((((ProductPeriod)this.data).getFlags() & 4) > 0);
        }

        public boolean doApply() throws Exception {
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0414\u0430\u043d\u043d\u043e\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0435 \u043c\u043e\u0436\u0435\u0442 \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0442\u0430\u0440\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u044e \u0438\u043b\u0438 \u0440\u0430\u0431\u043e\u0442\u0443 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430.\n\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u043f\u0435\u0440\u0438\u043e\u0434?", "\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u043f\u0435\u0440\u0438\u043e\u0434\u0430", 0) != 0) {
                return false;
            }
            ((ProductPeriod)this.data).setContractId(((ClientContext)PeriodPanel.this.getContext()).getContractId());
            Date timeFrom = TimeUtils.parseDate((String)this.dateFrom.getText(), (String)"dd.MM.yyyy HH:mm:ss");
            Date timeTo = TimeUtils.parseDate((String)this.dateTo.getText(), (String)"dd.MM.yyyy HH:mm:ss");
            if (timeFrom != null && timeTo != null && timeFrom.after(timeTo)) {
                ClientUtils.showErrorMessageDialog((String)"\u0414\u0430\u0442\u0430 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u0440\u0430\u043d\u044c\u0448\u0435 \u0434\u0430\u0442\u044b \u043d\u0430\u0447\u0430\u043b\u0430");
                return false;
            }
            ((ProductPeriod)this.data).setTimeFrom(timeFrom);
            ((ProductPeriod)this.data).setTimeTo(timeTo);
            ((ProductPeriod)this.data).setFlags(this.suspended.isSelected() ? ((ProductPeriod)this.data).getFlags() | 1 : ((ProductPeriod)this.data).getFlags() & 0xFFFFFFFE);
            ((ProductPeriod)this.data).setFlags(this.splitted.isSelected() ? ((ProductPeriod)this.data).getFlags() | 2 : ((ProductPeriod)this.data).getFlags() & 0xFFFFFFFD);
            ((ProductPeriod)this.data).setFlags(this.proportional.isSelected() ? ((ProductPeriod)this.data).getFlags() | 8 : ((ProductPeriod)this.data).getFlags() & 0xFFFFFFF7);
            ((ProductPeriod)this.data).setFlags(this.finished.isSelected() ? ((ProductPeriod)this.data).getFlags() | 4 : ((ProductPeriod)this.data).getFlags() & 0xFFFFFFFB);
            ((ProductService)((ClientContext)PeriodPanel.this.getContext()).getWebService(ProductService.class, 0)).productPeriodUpdate(((ProductPeriod)this.data).getContractId(), (ProductPeriod)this.data);
            PeriodPanel.this.performAction("refresh");
            return super.doApply();
        }

        private JPanel getPeriodPanel() {
            String placeHolderText = "\u0414\u0414.\u041c\u041c.\u0413\u0413\u0413\u0413 \u0427\u0427:\u041c\u041c:\u0421\u0421";
            this.dateFrom.setHorizontalAlignment(0);
            this.dateFrom.setPromptText("\u0414\u0414.\u041c\u041c.\u0413\u0413\u0413\u0413 \u0427\u0427:\u041c\u041c:\u0421\u0421");
            this.dateFrom.setToolTipText("\u0414\u0414.\u041c\u041c.\u0413\u0413\u0413\u0413 \u0427\u0427:\u041c\u041c:\u0421\u0421");
            this.dateFrom.setEnabled(true);
            this.dateTo.setHorizontalAlignment(0);
            this.dateTo.setPromptText("\u0414\u0414.\u041c\u041c.\u0413\u0413\u0413\u0413 \u0427\u0427:\u041c\u041c:\u0421\u0421");
            this.dateTo.setToolTipText("\u0414\u0414.\u041c\u041c.\u0413\u0413\u0413\u0413 \u0427\u0427:\u041c\u041c:\u0421\u0421");
            this.dateTo.setEnabled(true);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder((Border)new BGTitleBorder("\u041f\u0435\u0440\u0438\u043e\u0434"));
            panel.add((Component)this.dateFrom, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 3), 0, 0));
            panel.add((Component)new JLabel(" - "), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
            panel.add((Component)this.dateTo, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 10), 0, 0));
            return panel;
        }

        private JPanel getFlagsPanel() {
            this.suspended.setToolTipText("\u041f\u0440\u0438\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0434\u043e \u043f\u043b\u0430\u0442\u0435\u0436\u0430");
            this.splitted.setToolTipText("\u0414\u0430\u043d\u043d\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434 \u0437\u0430\u043a\u0440\u044b\u0442 - \u043e\u0442\u043a\u0440\u044b\u0442 \u043d\u043e\u0432\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434");
            this.proportional.setToolTipText("\u041d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435 \u043f\u043e \u0434\u0430\u043d\u043d\u043e\u043c\u0443 \u043f\u0435\u0440\u0438\u043e\u0434\u0443 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0440\u043e\u043f\u043e\u0440\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u044b\u043c");
            this.finished.setToolTipText("\u0414\u0430\u043d\u043d\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434 - \u0437\u0430\u0432\u0435\u0440\u0448\u0430\u044e\u0449\u0438\u0439 \u0434\u043b\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430");
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder((Border)new BGTitleBorder("\u0424\u043b\u0430\u0433\u0438"));
            panel.add((Component)this.suspended, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 5), 0, 0));
            panel.add((Component)this.splitted, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 5), 0, 0));
            panel.add((Component)this.proportional, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 5, 5), 0, 0));
            panel.add((Component)this.finished, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 5, 5), 0, 0));
            return panel;
        }
    }
}

