/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean.code;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceZoneMapItem;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class VoiceZoneMapItemDao
extends AbstractIdDao<VoiceZoneMapItem> {
    static final String VOICE_ZONE_MAP_ITEM_TABLENAME = "voice_zone_map_item";

    public VoiceZoneMapItemDao(Connection con, int moduleId) {
        super(con, moduleId, VOICE_ZONE_MAP_ITEM_TABLENAME);
    }

    protected VoiceZoneMapItem getFromRS(ResultSet rs) throws SQLException, BGException {
        return this.getFromRS(rs, false);
    }

    private VoiceZoneMapItem getFromRS(ResultSet rs, boolean loadTitles) throws SQLException {
        VoiceZoneMapItem result = new VoiceZoneMapItem();
        result.setId(rs.getInt("id"));
        result.setMapId(rs.getInt("mapId"));
        result.setZoneId(rs.getInt("zoneId"));
        result.setCodeId(rs.getInt("codeId"));
        if (loadTitles) {
            result.setCode(rs.getString("code"));
            result.setDestinationTitle(rs.getString("destTitle"));
        }
        return result;
    }

    protected void updateImpl(VoiceZoneMapItem item) throws BGException, SQLException {
        Objects.requireNonNull(item);
        if (item.getCodeId() == 0) {
            return;
        }
        boolean update = item.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET mapId=?, zoneId=?, codeId=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int idx = 1;
            ps.setInt(idx++, item.getMapId());
            ps.setInt(idx++, item.getZoneId());
            ps.setInt(idx++, item.getCodeId());
            if (update) {
                ps.setInt(idx++, item.getId());
            }
            ps.executeUpdate();
            if (!update) {
                item.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
    }

    public List<VoiceZoneMapItem> list(int zoneMapId) throws BGException {
        ArrayList<VoiceZoneMapItem> result = new ArrayList<VoiceZoneMapItem>();
        String geoCodeTableName = ServerUtils.getModuleTableName((String)"voice_geographic_code", (int)this.moduleId);
        String destTableName = ServerUtils.getModuleTableName((String)"voice_destination", (int)this.moduleId);
        String codeDestTableName = ServerUtils.getModuleTableName((String)"voice_code_destination", (int)this.moduleId);
        String query = "SELECT item.*, code.code as code, dest.title as destTitle FROM " + this.tableName + "  AS item LEFT JOIN " + geoCodeTableName + " AS code ON code.id=item.codeId LEFT JOIN " + codeDestTableName + " AS codeDest  ON code.id=codeDest.codeId  LEFT JOIN " + destTableName + " dest ON codeDest.destinationId=dest.id WHERE item.mapId=?  ORDER BY code.code";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, zoneMapId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getFromRS(rs, true));
                }
            }
        }
        catch (SQLException e) {
            this.processException(e);
        }
        return result;
    }

    public void deleteByMapId(int id) throws BGException {
        super.delete("mapId=?", new Object[]{id});
    }

    public VoiceZoneMapItem get(int zoneMapId, String code) throws BGException {
        VoiceZoneMapItem result = null;
        String geocodeTable = ServerUtils.getModuleTableName((String)"voice_geographic_code", (int)this.moduleId);
        String query = "SELECT vcm.* FROM " + geocodeTable + " AS vgc LEFT JOIN " + this.tableName + " AS vcm ON vgc.id=vcm.codeId WHERE vgc.code=? AND vcm.mapId=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, zoneMapId);
            ps.setString(index++, code);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = this.getFromRS(rs);
                }
            }
        }
        catch (SQLException e) {
            this.processException(e);
        }
        return result;
    }
}

