/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean.operator.sovintel;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Connection;
import java.util.Date;
import java.util.Set;
import ru.bitel.bgbilling.modules.voice.server.bean.operator.sovintel.Sovintel;
import ru.bitel.bgbilling.modules.voice.server.bean.operator.sovintel.SovintelAbonentData;
import ru.bitel.bgbilling.modules.voice.server.bean.operator.sovintel.SovintelReport;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class AbonentReport
extends SovintelReport {
    private boolean changes;

    public AbonentReport(Sovintel operator, Date month, int id, boolean changes) {
        super(operator, month, id);
        this.changes = changes;
    }

    @Override
    public void getData(Connection con, OutputStream out) {
        try {
            Set<Integer> contractIdSet;
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, "cp1251"));
            CSVWriter printer = new CSVWriter((Writer)writer, ';', '\"');
            Set<Integer> set = contractIdSet = this.changes ? this.oper.getChangedAbonents(con, this.month) : null;
            if (!this.changes || contractIdSet.size() > 0) {
                int pos = 1;
                String operPrefix = this.oper.getOperatorSetup().get("contract_prefix", null);
                String naturalPersonContract = this.oper.getOperatorSetup().get("naturalPersonContract", "");
                if (operPrefix != null) {
                    for (SovintelAbonentData data : SovintelAbonentData.extractData(con, this.oper, this.month, contractIdSet)) {
                        printer.writeNext(new String[]{String.valueOf(pos++), "1".equals(data.jurStatus) && Utils.notEmptyString((String)naturalPersonContract) ? naturalPersonContract : operPrefix + data.contractTitle, data.fullName, data.jurAddress, data.inn, data.kpp, data.diplomat ? "1" : "2", data.jurStatus, data.notResident ? "2" : "1", data.countryCode, TimeUtils.format((Date)data.date1, (String)"dd.MM.yyyy '0:00'"), TimeUtils.format((Date)data.date2, (String)"dd.MM.yyyy '0:00'"), data.contractType, data.locationCode, data.info ? "1" : "0"}, false);
                    }
                } else {
                    for (SovintelAbonentData data : SovintelAbonentData.extractData(con, this.oper, this.month, contractIdSet)) {
                        printer.writeNext(new String[]{String.valueOf(pos++), "1".equals(data.jurStatus) && Utils.notEmptyString((String)naturalPersonContract) ? naturalPersonContract : data.contractTitle, data.fullName, data.jurAddress, data.inn, data.kpp, data.diplomat ? "1" : "2", data.jurStatus, data.notResident ? "2" : "1", data.countryCode, TimeUtils.format((Date)data.date1, (String)"dd.MM.yyyy '0:00'"), TimeUtils.format((Date)data.date2, (String)"dd.MM.yyyy '0:00'"), data.contractType, data.locationCode, data.info ? "1" : "0"}, false);
                    }
                }
            }
            printer.flush();
            ((Writer)writer).flush();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getFileName() {
        return this.getOperCode() + "_CUS_" + TimeUtils.format((Date)this.month, (String)"yyyy_MM") + ".csv";
    }

    @Override
    public String getTitle() {
        return this.changes ? "\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u043f\u043e \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u0430\u043c" : "\u041e\u0442\u0447\u0435\u0442\u043d\u043e\u0441\u0442\u044c \u043f\u043e \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u0430\u043c";
    }

    @Override
    public int getType() {
        return 2;
    }
}

