/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.runtime;

import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceOperator;
import ru.bitel.bgbilling.modules.voice.common.event.VoiceOperatorModifiedEvent;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceOperatorDao;
import ru.bitel.common.worker.ThreadContext;

public class VoiceOperatorRuntimeMap
implements EventListener<VoiceOperatorModifiedEvent> {
    private static final Logger logger = LogManager.getLogger();
    private static final ConcurrentMap<Integer, VoiceOperatorRuntimeMap> moduleMap = new ConcurrentHashMap<Integer, VoiceOperatorRuntimeMap>();
    private final int moduleId;
    private Map<Integer, VoiceOperator> contractOperMap = new HashMap<Integer, VoiceOperator>();
    private Map<Integer, VoiceOperator> operMap = new HashMap<Integer, VoiceOperator>();

    public static VoiceOperatorRuntimeMap getInstance(Connection con, int moduleId) throws BGException {
        VoiceOperatorRuntimeMap result = (VoiceOperatorRuntimeMap)moduleMap.get(moduleId);
        if (result == null) {
            EventProcessor ep = EventProcessor.getInstance();
            VoiceOperatorRuntimeMap newResult = new VoiceOperatorRuntimeMap(moduleId);
            ep.addListener((EventListener)newResult, VoiceOperatorModifiedEvent.class, moduleId, null);
            newResult.load(con);
            result = moduleMap.putIfAbsent(moduleId, newResult);
            if (result == null) {
                result = newResult;
            } else {
                ep.removeListener((EventListener)newResult);
            }
        }
        return result;
    }

    private VoiceOperatorRuntimeMap(int moduleId) {
        this.moduleId = moduleId;
    }

    private void load(Connection con) throws BGException {
        logger.info("Loading VoiceOperatorRuntimeMap for moduleId:" + this.moduleId);
        this.operMap.clear();
        this.contractOperMap.clear();
        try (VoiceOperatorDao dao = new VoiceOperatorDao(con, this.moduleId);){
            List<VoiceOperator> operators = dao.list();
            for (VoiceOperator operator : operators) {
                this.operMap.put(operator.getId(), operator);
                this.contractOperMap.put(operator.getContractId(), operator);
            }
        }
    }

    public void notify(VoiceOperatorModifiedEvent e, EventListenerContext ctx) throws BGException {
        ServerContext context = (ServerContext)ThreadContext.get(ServerContext.class);
        this.load(context.getConnection());
    }

    public VoiceOperator getOperatorByContractId(int contractId) {
        return this.contractOperMap.get(contractId);
    }

    public VoiceOperator getOperatorById(int operId) {
        return this.operMap.get(operId);
    }
}

