/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.runtime;

import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceOption;
import ru.bitel.bgbilling.modules.voice.common.event.VoiceOptionModifiedEvent;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceOptionDao;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceOptionRuntime;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.worker.ThreadContext;

public class VoiceOptionRuntimeMap
implements EventListener<VoiceOptionModifiedEvent> {
    private static final Logger logger = LogManager.getLogger();
    private static final ConcurrentMap<Integer, VoiceOptionRuntimeMap> moduleMap = new ConcurrentHashMap<Integer, VoiceOptionRuntimeMap>();
    private final int moduleId;
    private volatile Map<Integer, VoiceOptionRuntime> idMap = new HashMap<Integer, VoiceOptionRuntime>();

    public static VoiceOptionRuntimeMap getInstance(Connection connection, int moduleId) throws BGException {
        VoiceOptionRuntimeMap result = (VoiceOptionRuntimeMap)moduleMap.get(moduleId);
        if (result == null) {
            EventProcessor ep = EventProcessor.getInstance();
            VoiceOptionRuntimeMap newResult = new VoiceOptionRuntimeMap(moduleId);
            ep.addListener((EventListener)newResult, VoiceOptionModifiedEvent.class, moduleId, null);
            newResult.load(connection);
            result = moduleMap.putIfAbsent(moduleId, newResult);
            if (result == null) {
                result = newResult;
            } else {
                ep.removeListener((EventListener)newResult);
            }
        }
        return result;
    }

    public static VoiceOptionRuntimeMap getInstance(int moduleId) throws BGException {
        ServerContext context = (ServerContext)ThreadContext.get(ServerContext.class);
        return VoiceOptionRuntimeMap.getInstance(context.getConnectionSet().getConnection(), moduleId);
    }

    private VoiceOptionRuntimeMap(int moduleId) {
        this.moduleId = moduleId;
    }

    public void notify(VoiceOptionModifiedEvent e, EventListenerContext ctx) throws BGException {
        this.load();
    }

    public VoiceOptionRuntime get(int id) {
        return this.idMap.get(id);
    }

    public Map<Integer, VoiceOptionRuntime> getMap() {
        return this.idMap;
    }

    private void load() throws BGException {
        ServerContext context = (ServerContext)ThreadContext.get(ServerContext.class);
        this.load(context.getConnection());
    }

    private void load(Connection con) throws BGException {
        logger.info("Loading inetOptionRuntimeMap for moduleId:" + this.moduleId);
        try (VoiceOptionDao dao = new VoiceOptionDao(con, this.moduleId);){
            List<VoiceOption> options = dao.list();
            this.load(options);
        }
    }

    private void load(List<VoiceOption> options) throws BGException {
        for (VoiceOption option : options) {
            String configString = option.getConfig();
            Preferences vars = new Preferences();
            vars.set("optionTitle", String.valueOf(option.getTitle()));
            Preferences config = new Preferences((ParameterMap)vars, configString, "\n");
            VoiceOptionRuntime optionRuntime = new VoiceOptionRuntime(option, (ParameterMap)config);
            this.idMap.put(option.getId(), optionRuntime);
        }
    }
}

