/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.service;

import jakarta.jws.WebService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.apps.voice.accounting.recalculate.VoiceRecalculator;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTaskDataManager;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceDestination;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceGeographicCode;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceGeographicRange;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceService;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceDestinationDao;
import ru.bitel.bgbilling.modules.voice.server.bean.code.GeoCodeManager;
import ru.bitel.bgbilling.modules.voice.server.bean.code.VoiceGeographicCodeDao;
import ru.bitel.bgbilling.modules.voice.server.bean.range.VoiceGeographicRangeDao;
import ru.bitel.bgbilling.modules.voice.server.event.GeoCodeUpdateEvent;
import ru.bitel.bgbilling.modules.voice.server.task.VoiceBalanceSetter;
import ru.bitel.bgbilling.modules.voice.server.utils.VoiceUtils;
import ru.bitel.common.TreeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Node;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.voice.common.service.VoiceService")
public class VoiceServiceImpl
extends AbstractService
implements VoiceService {
    public SearchResult<VoiceDestination> voiceDestinationList(int operator, String title, Page page) throws BGException {
        SearchResult searchResult = new SearchResult();
        searchResult.setPage(page);
        try (VoiceDestinationDao destinationDao = new VoiceDestinationDao(this.getConnection(), this.moduleId);){
            destinationDao.searchDestination((SearchResult<VoiceDestination>)searchResult, operator, title, true);
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        return searchResult;
    }

    public List<IdTitle> voiceDestinationTitles(List<Integer> destIds) throws BGException, BGMessageException {
        try (VoiceDestinationDao destinationDao = new VoiceDestinationDao(this.getConnection(), this.moduleId);){
            List<IdTitle> list = destinationDao.list(destIds);
            return list;
        }
    }

    public VoiceDestination voiceDestinationGet(int id) throws BGException {
        try (VoiceDestinationDao destinationDao = new VoiceDestinationDao(this.getConnection(), this.moduleId);){
            VoiceDestination voiceDestination = (VoiceDestination)destinationDao.get(id);
            return voiceDestination;
        }
    }

    public int voiceDestinationUpdate(VoiceDestination destination) throws BGException {
        try (VoiceDestinationDao destinationDao = new VoiceDestinationDao(this.getConnection(), this.moduleId);){
            destinationDao.update(destination);
            int n = destination.getId();
            return n;
        }
    }

    public int voiceDestinationDelete(List<Integer> idSet) throws BGException {
        try (VoiceDestinationDao destinationDao = new VoiceDestinationDao(this.getConnection(), this.moduleId);){
            int n = destinationDao.delete(idSet);
            return n;
        }
    }

    public void voiceDestinationReplace(int sourceDestinationId, int targetDestinationId) throws BGException, BGMessageException {
        try (VoiceGeographicCodeDao dao = new VoiceGeographicCodeDao(this.getConnection(), this.moduleId);){
            dao.replaceDestination(sourceDestinationId, targetDestinationId);
        }
    }

    public String getGeographicCodeTree(int operatorId) throws BGException, BGMessageException {
        try (GeoCodeManager codeDao = new GeoCodeManager(this.getConnection(), this.moduleId, this.userId);){
            List<VoiceGeographicCode> codeList = codeDao.list(-1, operatorId);
            String string = Base64.getEncoder().encodeToString(this.listToTreeRoot(codeList));
            return string;
        }
    }

    public List<IdTitle> voiceGeographicCodeTitles(int operatorId) throws Exception {
        return new GeoCodeManager(this.getConnection(), this.moduleId, this.userId).list(-1, operatorId).stream().map(a -> new IdTitle(a.getId(), a.getCode() + " - " + a.getDestinationTitle())).toList();
    }

    public int updateGeographicCode(VoiceGeographicCode code) throws BGException, BGMessageException {
        try (GeoCodeManager geoCodeManager = new GeoCodeManager(this.getConnection(), this.moduleId, this.userId);){
            int n = geoCodeManager.updateGeographicCode(code);
            return n;
        }
    }

    public int deleteGeographicCode(List<Integer> codes) throws BGException, BGMessageException {
        try (GeoCodeManager codeDao = new GeoCodeManager(this.getConnection(), this.moduleId, this.userId);){
            EventProcessor.getInstance().publishAfterCommit((Event)new GeoCodeUpdateEvent(this.moduleId, this.userId));
            int n = codeDao.delete(codes);
            return n;
        }
    }

    public String importGeographicCode(int operatorId, boolean addNew, boolean updateExist, String importContent) throws BGException, BGMessageException {
        try (GeoCodeManager manager = new GeoCodeManager(this.getConnection(), this.moduleId, this.userId);){
            String string = manager.importGeographicCode(operatorId, addNew, updateExist, importContent);
            return string;
        }
    }

    public void deleteAllGeographicCode(int operatorId) throws BGException, BGMessageException {
        try (GeoCodeManager codeDao = new GeoCodeManager(this.getConnection(), this.moduleId, this.userId);){
            codeDao.delete(codeDao.list(-1, operatorId).stream().map(item -> item.getId()).toList());
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private byte[] listToTreeRoot(List<VoiceGeographicCode> codeList) throws BGException, BGMessageException {
        VoiceUtils.fillParents(codeList);
        VoiceGeographicCode root = new VoiceGeographicCode(0, "\u0414\u0435\u0440\u0435\u0432\u043e \u043a\u043e\u0434\u043e\u0432");
        root = (VoiceGeographicCode)TreeUtils.tree(codeList, (Node)root);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                oos.writeObject(root);
                oos.flush();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new BGException((Throwable)e);
        }
    }

    public List<VoiceGeographicCode> voiceGeographicCodeByDestinationId(int destinationId) throws BGException, BGMessageException {
        try (VoiceGeographicCodeDao dao = new VoiceGeographicCodeDao(this.getConnection(), this.moduleId);){
            List<VoiceGeographicCode> list = dao.getVoiceGeographicCodeByDestinationId(destinationId);
            return list;
        }
    }

    public void calculate(Date dateFrom, Date dateTo, Set<Integer> contractIds, long groupMask, String email, String comment) throws BGException, BGMessageException {
        new RunTaskDataManager(this.getConnection()).addTask((RunTask)new VoiceRecalculator(dateFrom, dateTo, contractIds, groupMask, email, comment, this.moduleId));
    }

    public void setBalance(Date month, String email, Set<Integer> contractIds) throws BGException, BGMessageException {
        new RunTaskDataManager(this.getConnection()).addTask((RunTask)new VoiceBalanceSetter(this.moduleId, month, email, contractIds));
    }

    /*
     * Exception decompiling
     */
    public String voiceGeographicRangeList(int operatorId) throws BGException, BGMessageException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public VoiceGeographicRange voiceGeographicRangeGet(int id) throws BGException, BGMessageException {
        return null;
    }

    public int voiceGeographicRangeUpdate(VoiceGeographicRange range) throws BGException, BGMessageException {
        try (VoiceGeographicRangeDao dao = new VoiceGeographicRangeDao(this.getConnection(), this.moduleId);){
            dao.update(range);
            int n = range.getId();
            return n;
        }
    }

    public void voiceGeographicRangeDelete(List<Integer> ids) throws BGException, BGMessageException {
        try (VoiceGeographicRangeDao dao = new VoiceGeographicRangeDao(this.getConnection(), this.moduleId);){
            for (int id : ids) {
                dao.delete(id);
            }
        }
    }

    public String voiceGeographicRangeImport(int operatorId, String importData, boolean addDestination) throws BGException, BGMessageException {
        try (VoiceGeographicRangeDao rangeDao = new VoiceGeographicRangeDao(this.getConnection(), this.moduleId);){
            String string;
            try (VoiceDestinationDao destinationDao = new VoiceDestinationDao(this.getConnection(), this.moduleId);){
                Map<String, VoiceDestination> destinationMap = destinationDao.titleMap(operatorId);
                StringBuilder res = new StringBuilder();
                VoiceGeographicRange range = new VoiceGeographicRange();
                range.setOperatorId(operatorId);
                for (String data : importData.split("\n")) {
                    range.setId(0);
                    range.setMobileId("");
                    String[] a = data.split("\t");
                    VoiceDestination voiceDestination = destinationMap.get(a[2]);
                    if (voiceDestination == null) {
                        if (addDestination) {
                            voiceDestination = new VoiceDestination();
                            voiceDestination.setOperatorId(operatorId);
                            voiceDestination.setTitle(a[2]);
                            destinationDao.update(voiceDestination);
                            destinationMap.put(a[2], voiceDestination);
                        } else {
                            res.append(data).append(" <== \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0432 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0435\n");
                            continue;
                        }
                    }
                    if (a.length > 2) {
                        range.setRangeFrom(Utils.parseLong((String)a[0]));
                        range.setRangeTo(Utils.parseLong((String)a[1]));
                        range.setDestinationId(voiceDestination.getId());
                    }
                    if (a.length > 3) {
                        range.setMobileId(a[4]);
                    }
                    if (range.getRangeFrom() > range.getRangeTo()) {
                        res.append(data).append(" <== \u043d\u0430\u0447\u0430\u043b\u043e \u0431\u043e\u043b\u044c\u0448\u0435 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f\n");
                        continue;
                    }
                    if (range.getRangeFrom() < 10000000000L) {
                        res.append(data).append(" <== \u043d\u0430\u0447\u0430\u043b\u043e \u043c\u0435\u043d\u044c\u0448\u0435 11 \u0446\u0438\u0444\u0440\n");
                        continue;
                    }
                    if (range.getRangeTo() < 10000000000L) {
                        res.append(data).append(" <== \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435 \u043c\u0435\u043d\u044c\u0448\u0435 11 \u0446\u0438\u0444\u0440\n");
                        continue;
                    }
                    rangeDao.update(range);
                }
                string = res.toString();
            }
            return string;
        }
    }

    public List<VoiceGeographicRange> voiceGeographicRangeSearch(int operatorId, String txt) throws BGException, BGMessageException {
        try (VoiceGeographicRangeDao rangeDao = new VoiceGeographicRangeDao(this.getConnection(), this.moduleId);){
            List<VoiceGeographicRange> list = rangeDao.list(operatorId, txt);
            return list;
        }
    }

    public List<VoiceGeographicRange> voiceGeographicRanges(List<Integer> rangeIds) throws BGException, BGMessageException {
        try (VoiceGeographicRangeDao rangeDao = new VoiceGeographicRangeDao(this.getConnection(), this.moduleId);){
            List<VoiceGeographicRange> list = rangeDao.list(rangeIds);
            return list;
        }
    }
}

