/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.task;

import java.sql.Connection;
import java.util.Date;
import java.util.Set;
import ru.bitel.bgbilling.kernel.admin.mail.server.MailMsg;
import ru.bitel.bgbilling.kernel.admin.mail.server.bean.MailData;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.modules.voice.server.mail.MailTaskBalanceSetter;
import ru.bitel.bgbilling.modules.voice.server.task.VoiceBalanceTask;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;

public class VoiceBalanceSetter
extends RunTask {
    private final Set<Integer> contracts;
    protected final int moduleId;
    protected final Date month;
    protected final String email;

    public VoiceBalanceSetter(int moduleId, Date month, String email, Set<Integer> contracts) {
        this.moduleId = moduleId;
        this.month = month;
        this.email = email;
        this.contracts = contracts;
    }

    protected void executeTask() {
        long start = System.currentTimeMillis();
        try (Connection con = this.setup.getDBConnectionFromPool();){
            this.createTask().executeTask();
        }
        catch (Exception ex) {
            this.getLogger().error("error while executing \"" + this.getDescription() + "\"" + ex.getMessage(), (Throwable)ex);
        }
        long end = System.currentTimeMillis();
        if (this.email != null) {
            StringBuffer report = new StringBuffer("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0431\u0430\u043b\u0430\u043d\u0441\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430\n").append("\u0412\u0440\u0435\u043c\u044f: ").append(TimeUtils.formatDeltaTime((long)((end - start) / 1000L)));
            try {
                MailTaskBalanceSetter mailData = new MailTaskBalanceSetter();
                mailData.setModuleId(this.moduleId);
                mailData.setRecipients(this.email);
                mailData.setSubject("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0431\u0430\u043b\u0430\u043d\u0441\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430");
                mailData.addTextPart("text", report.toString());
                new MailMsg((Preferences)this.setup).sendMessage((MailData)mailData);
            }
            catch (Exception ex) {
                this.getLogger().error((Object)ex);
            }
        }
    }

    public String getDescription() {
        return "\u041c\u043e\u0434\u0443\u043b\u044c Voice. \u0417\u0430\u0434\u0430\u0447\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u0431\u0430\u043b\u0430\u043d\u0441\u043e\u0432. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId + ". \u0414\u043e\u0433\u043e\u0432\u043e\u0440\u044b:" + this.contracts;
    }

    private VoiceBalanceTask createTask() {
        VoiceBalanceTask voiceBalanceTask = new VoiceBalanceTask();
        voiceBalanceTask.setContracts(this.contracts);
        voiceBalanceTask.setModuleId(this.moduleId);
        voiceBalanceTask.setExecutingTime(TimeUtils.convertDateToCalendar((Date)this.month));
        voiceBalanceTask.initTask(Setup.getSetup(), 0, "");
        return voiceBalanceTask;
    }
}

