/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.vseplatezhi.server.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.vseplatezhi.common.bean.Transaction;
import ru.bitel.bgbilling.modules.vseplatezhi.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.vseplatezhi.server.bean.TransactionManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

@WebServlet(name="VseplatezhiExecutor", urlPatterns={"/vseplatezhi/*"})
public class ModuleExecutor
extends CommonExecutor {
    private static final Logger logger = LogManager.getLogger();

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Connection con;
        block26: {
            con = null;
            int moduleId = 0;
            try {
                moduleId = ModuleExecutor.getModuleId((HttpServletRequest)request);
            }
            catch (Exception e) {
                logger.error("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d moduleId");
                return;
            }
            try (TransactionManager transactionManager = new TransactionManager(con, moduleId);){
                con = Setup.getSetup().getDBConnectionFromPool();
                ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
                String orderId = request.getParameter("order_id");
                String amount = request.getParameter("amount");
                String signValue = request.getParameter("sign");
                if (orderId == null || amount == null || signValue == null) break block26;
                StringBuilder parameters = new StringBuilder();
                parameters.append("order_id").append("=").append(orderId).append("\n");
                parameters.append("amount").append("=").append(amount).append("\n");
                parameters.append("sign").append("=").append(signValue).append("\n");
                StringBuilder signData = new StringBuilder().append(orderId).append(amount).append(moduleSetup.get("vseplatezhi.shared.key", ""));
                Object responseString = null;
                String checkSignData = Utils.getDigest((String)signData.toString(), (String)"UTF-8").toLowerCase();
                if (signValue.equals(checkSignData)) {
                    String errorMessage;
                    Transaction transaction = (Transaction)transactionManager.get(Utils.parseInt((String)orderId));
                    if (transaction == null) {
                        errorMessage = "Not found transaction for ID = " + orderId;
                        logger.error(errorMessage);
                        response.sendError(400, errorMessage);
                    }
                    if (responseString == null && !transaction.getStatus().equals(TransactionStatus.CREATED.getCode())) {
                        errorMessage = "Transaction for ID = " + orderId + " has status != 'created'";
                        logger.error(errorMessage);
                        response.sendError(400, errorMessage);
                    }
                    if (responseString == null && transaction.getPaymentId() > 0) {
                        errorMessage = "Transaction for ID = " + orderId + " has paymentId > 0";
                        logger.error(errorMessage);
                        response.sendError(400, errorMessage);
                    }
                    if (responseString != null) break block26;
                    transaction.setSum(new BigDecimal(amount));
                    transaction.setTransactionId(orderId);
                    transaction.setTransactionDate(new Date());
                    transaction.setParameters(parameters.toString());
                    transaction.setStatus(TransactionStatus.OK.getCode());
                    Date paymentDate = transaction.getTransactionDate();
                    if (paymentDate == null) {
                        paymentDate = new Date();
                        transaction.setTransactionDate(paymentDate);
                    }
                    Payment payment = Payment.builder().setDate(paymentDate).setTypeId(moduleSetup.getInt("vseplatezhi.payment.type.id", 0)).setContractId(transaction.getContractId()).setSum(transaction.getSum()).setUserId(0).setModuleId(Integer.valueOf(moduleId)).setTransactionId(String.valueOf(transaction.getId())).setComment(moduleSetup.get("vseplatezhi.payment.comment", "\u041e\u043f\u043b\u0430\u0442\u0430 \u0447\u0435\u0440\u0435\u0437 \u0441\u0435\u0440\u0432\u0438\u0441 Vseplatezhi [\u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f #{TRANSACTION_ID}]").replace("{TRANSACTION_ID}", String.valueOf(transaction.getId()))).build();
                    try (PaymentDao paymentDao = new PaymentDao(con);){
                        paymentDao.update((Object)payment);
                    }
                    transaction.setPaymentId(payment.getId());
                    transactionManager.update(transaction);
                    try (BalanceUtils balanceUtils = new BalanceUtils(con);){
                        balanceUtils.updateBalance(transaction.getTransactionDate(), transaction.getContractId());
                    }
                    EventProcessor.getInstance().publish((Event)new PaymentEvent(0, payment));
                    EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 3, payment.getSum()));
                    response.sendError(200);
                    break block26;
                }
                String errorMessage = "Error check sign (in request check = '" + signValue + "' no equals calculate = '" + checkSignData + "' )";
                logger.error(errorMessage);
                response.sendError(400, errorMessage);
            }
            catch (BGException ex) {
                try {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
                catch (Throwable throwable) {
                    ServerUtils.closeConnection(con);
                    throw throwable;
                }
                ServerUtils.closeConnection((Connection)con);
            }
        }
        ServerUtils.closeConnection((Connection)con);
    }
}

