#!/bin/bash

# Запуск 
#	update.sh - обновление до последней сборки
#	update.sh <set> - обновление до указанной сборки, номер сборки должен быть больше текущей

cd ${0%${0##*/}}.

if [ -e setenv.sh ]
then
    . ./setenv.sh
fi

INIT_D=/etc/init.d/
SYSTEMD=/etc/systemd/system/multi-user.target.wants/
SERVER=${SERVER:-'bgbilling'}
TEE=/usr/bin/tee
DATE=/bin/date

if [[ -e ./../lib/common/kernel-common.jar ]]; then
    snapshot=`find ./../snapshots -type f -mtime 0 | tail -1`
	if [[ -z $snapshot ]]; then
	    echo "Actual snapshot not found!"
	    echo "Create snapshot..."
	    ./snapshot.sh create
	    snapshot=`find ./snapshots -type f -mtime 0 | tail -1`
	fi
	echo "Found actual snapshot: $snapshot"
fi

time=`${DATE} +%Y%m%d_%H%M%S`

if [[ -e ${SYSTEMD}${SERVER}.service ]]
then
    echo "# Stopping Server (systemd)"
    systemctl stop ${SERVER}.service
fi
if [[ -e ${INIT_D}${SERVER} ]]
then
    echo "# Stopping Server (initd)"
    ${INIT_D}${SERVER} stop
fi

echo "# Start Updating"
#./bg_installer.sh update $1 | ${TEE} ./log_update_${time}
./bg_installer.sh 2>&1 | ${TEE} ./../log/update/log_update_${time}

if [[ -e ${SYSTEMD}${SERVER}.service ]]
then
    echo "# Starting Server (systemd)"
    systemctl start ${SERVER}.service
fi
if [[ -e ${INIT_D}${SERVER} ]]
then
    echo "# Starting Server (initd)"
    ${INIT_D}${SERVER} start
fi
