/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.alfabank.server.event.worker;

import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.EventWorker;
import ru.bitel.bgbilling.modules.alfabank.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.alfabank.server.event.AlfabankCheckEvent;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.SetupParam;

public class AlfabankCheckEventWorker
extends EventWorker {
    private final int moduleId;
    private TransactionManager transactionManager;

    public AlfabankCheckEventWorker(Setup setup, int moduleId) throws BGException {
        super(EventProcessor.getInstance(), AlfabankCheckEvent.class, moduleId, -1, null);
        this.moduleId = moduleId;
        this.context = new EventListenerContext(setup, moduleId, SetupParam.getApplicationName());
        this.errorPause = 10000L;
        this.getLogger().info("Starting AlfabankCheckEventWorker for moduleId: {}", (Object)moduleId);
        new Thread((Runnable)((Object)this), "alfabank-check-event-wrkr-" + moduleId).start();
    }

    protected boolean runWorker() throws BGException {
        this.transactionManager = new TransactionManager(((EventListenerContext)this.context).getConnection(), this.moduleId);
        return this.doTasks();
    }

    public Object doTask(Object task) throws BGException {
        try {
            AlfabankCheckEvent event = (AlfabankCheckEvent)((Object)task);
            this.transactionManager.doCheckRequest(event.getContractId(), event.isAutopaymentTransaction());
            return null;
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }
}

