<%@ page contentType="text/html; charset=UTF-8"%><%@ include file="/WEB-INF/jspf/include/taglibs.jsp"%>

<ul class="nav nav-tabs px-4">
	<li class="nav-item"><a class="nav-link" href="#" onClick="showBlock( 'billRoot', 'list', billQuery );">Счета</a></li>
	<li class="nav-item"><a class="nav-link active" href="#">Акты, УПД</a></li>
</ul>
<div id="invoiceListRoot">
<div class="tile tileTabs">
<div class="buttons">
	<div><label for="billFilterCheckbox"><img title="Добавить фильтр" src="${pageContext.request.contextPath}/img/default/filter.png" height="32"/></label></div>
</div>
<c:choose>
	<c:when test="${not empty invoiceList}">
	<c:forEach var="item" varStatus="status" items="${invoiceList}">
		<fmt:parseDate var="period" pattern="dd/MM/yyyy" value="01/${item.mm+1}/${item.yy}" />
		<div class="flexRow invoice">
			<div class="mt-2" style="display: flex; flex-direction: column;">
				<div class="titleFont2 sf-2 px-2" style="margin-bottom: 10px;">Документ № ${item.formatNumber} <span>от <fmt:formatDate type="DATE" dateStyle="SHORT" value="${item.createDate}"/></span></div>
				<div style="padding: 0px 20px; overflow: auto;">
					<div class="paramFont paramColor invoiceParam" style="width: 15em; float: left;">Период: <span><fmt:formatDate  type="DATE" pattern="LLLL yyyy" value="${period}"/></span></div>
					<div class="paramFont paramColor invoiceParam" style="width: 20em; float: left;">Документ выписал: <span><c:choose><c:when test="${item.uid == -1}">клиент</c:when><c:otherwise>администратор</c:otherwise></c:choose></span></div>
					<div class="paramFont paramColor invoiceParam" style="width: 90%; clear: left; padding-top: 5px;">Тип документа: <span>${item.typeTitle}</span></div>
				</div>
			</div>
			<div class="mt-2" style="display: flex; flex-direction: column; width: 10rem;">
				<div class="titleFont3 text-nowrap text-end"><fmt:formatNumber pattern="###,###,###,##0.00" value="${item.summ}"/><span class="CUR"/></div>
				<div class="text-end"><button class="btn btn-primary" onClick="window.location='${pageContext.request.contextPath}/pdfexecuter?Invoice=&mid=${moduleId}&id=${item.id}'">скачать</button></div>
			</div>
		</div>
		<c:if test="${not status.last}"><div class="line"></div></c:if>
	</c:forEach>
	</c:when>
	<c:otherwise><div class="alert alert-primary mt-3" role="alert">Документы не найдены</div></c:otherwise>
</c:choose>
</div>
</div>
