/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.botmanager.server.bots.message;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.methods.send.SendDocument;
import org.telegram.telegrambots.meta.api.methods.send.SendMessage;
import org.telegram.telegrambots.meta.api.methods.updatingmessages.EditMessageText;
import org.telegram.telegrambots.meta.api.objects.InputFile;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.InlineKeyboardMarkup;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboardMarkup;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboardRemove;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons.InlineKeyboardButton;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons.KeyboardButton;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons.KeyboardRow;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialog;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialogElement;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialogElementType;
import ru.bitel.bgbilling.modules.botmanager.server.bots.RuntimeBot;
import ru.bitel.bgbilling.modules.botmanager.server.bots.TelegramRuntimeBot;
import ru.bitel.bgbilling.modules.botmanager.server.bots.message.MessageBuilder;
import ru.bitel.common.Utils;

public class TelegramMessageBuilder
extends MessageBuilder {
    public TelegramMessageBuilder(RuntimeBot bot) throws Exception {
        super(bot);
    }

    @Override
    public BotApiMethod<?> buildMessage(Long chatId, int messageId, BotDialog dialog) throws Exception {
        if (dialog == null) {
            this.getLogger().error("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u0441\u0442\u0440\u043e\u0438\u0442\u044c \u043e\u0442\u0432\u0435\u0442\u043d\u043e\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u0434\u043b\u044f \u0447\u0430\u0442\u0430: " + chatId + " \u041f\u0440\u0438\u0447\u0438\u043d\u0430: BotDialog == null");
            return this.buildErrorMessage(chatId);
        }
        List buttonsOnMessage = dialog.getDialogElements().stream().filter(element -> element.getElementType().equals((Object)BotDialogElementType.BUTTON)).collect(Collectors.toList());
        List<BotDialogElement> simpleButtons = buttonsOnMessage.stream().filter(element -> !element.getJSONConfig().optBoolean("isInline")).collect(Collectors.toList());
        List<BotDialogElement> inlineButtons = buttonsOnMessage.stream().filter(element -> element.getJSONConfig().optBoolean("isInline")).collect(Collectors.toList());
        Object message = messageId > 0 ? this.buildEditMessage(chatId, messageId, dialog, inlineButtons) : this.buildSendMessage(chatId, dialog, simpleButtons, inlineButtons);
        return message;
    }

    private SendMessage buildSendMessage(long chatId, BotDialog dialog, List<BotDialogElement> simpleButtons, List<BotDialogElement> inlineButtons) throws Exception {
        SendMessage message = new SendMessage();
        message.setChatId(String.valueOf(chatId));
        for (BotDialogElement dialogElement : dialog.getDialogElements()) {
            switch (dialogElement.getElementType()) {
                case TEXT: {
                    message.setText(this.getTextInMessage(message.getText(), dialogElement));
                    break;
                }
                case LINK: {
                    message.setText(this.getLinkInMessage(message.getEntities(), dialogElement));
                    break;
                }
                case ATTACHMENT: {
                    this.addAttachmentFileToMessage(message.getChatId(), dialogElement);
                }
            }
        }
        if (Utils.isEmptyCollection(simpleButtons) && Utils.isEmptyCollection(inlineButtons)) {
            message.setReplyMarkup((ReplyKeyboard)new ReplyKeyboardRemove(Boolean.valueOf(true)));
        } else {
            int buttonInLineCount = this.runtimeBot.getBotConfig().getInt("keyboard.buttoninline.count", 2);
            if (Utils.notEmptyCollection(simpleButtons)) {
                message.setReplyMarkup((ReplyKeyboard)this.getReplyKeyboardMarkup(simpleButtons, buttonInLineCount));
            } else if (Utils.notEmptyCollection(inlineButtons)) {
                message.setReplyMarkup((ReplyKeyboard)this.getInlineKeyboardMarkup(inlineButtons, buttonInLineCount));
            }
        }
        return message;
    }

    private EditMessageText buildEditMessage(long chatId, int messageid, BotDialog dialog, List<BotDialogElement> inlineButtons) throws Exception {
        EditMessageText message = new EditMessageText();
        message.setChatId(String.valueOf(chatId));
        message.setMessageId(Integer.valueOf(messageid));
        for (BotDialogElement dialogElement : dialog.getDialogElements()) {
            switch (dialogElement.getElementType()) {
                case TEXT: {
                    message.setText(this.getTextInMessage(message.getText(), dialogElement));
                    break;
                }
                case LINK: {
                    message.setText(this.getLinkInMessage(message.getEntities(), dialogElement));
                    break;
                }
                case ATTACHMENT: {
                    this.addAttachmentFileToMessage(message.getChatId(), dialogElement);
                }
            }
        }
        int buttonInLineCount = this.runtimeBot.getBotConfig().getInt("keyboard.buttoninline.count", 2);
        if (Utils.notEmptyCollection(inlineButtons)) {
            message.setReplyMarkup(this.getInlineKeyboardMarkup(inlineButtons, buttonInLineCount));
        }
        return message;
    }

    private String getTextInMessage(String messageText, BotDialogElement dialogElement) {
        Object text = messageText;
        text = Utils.notBlankString((String)text) ? (String)text + "\n" : "";
        text = (String)text + dialogElement.getJSONConfig().optString("text");
        return text;
    }

    private String getLinkInMessage(List<MessageEntity> entities, BotDialogElement dialogElement) {
        String link;
        if (entities == null) {
            entities = new ArrayList<MessageEntity>();
        }
        Object text = "";
        String linkTitle = dialogElement.getJSONConfig().optString("linkTitle");
        if (Utils.notBlankString((String)linkTitle)) {
            MessageEntity messageEntity = new MessageEntity();
            messageEntity.setType("bold");
            messageEntity.setText(linkTitle);
            messageEntity.setLength(Integer.valueOf(linkTitle.length()));
            messageEntity.setOffset(Integer.valueOf(linkTitle.length()));
            entities.add(messageEntity);
            text = (String)text + "\n\n" + linkTitle;
        }
        if (Utils.notBlankString((String)(link = dialogElement.getJSONConfig().optString("text")))) {
            MessageEntity messageEntity = new MessageEntity();
            messageEntity.setType("bold");
            String html = "<a href='" + link + "'>" + linkTitle + "</a>";
            messageEntity.setUrl(html);
            messageEntity.setLength(Integer.valueOf(link.length()));
            messageEntity.setOffset(Integer.valueOf(link.length()));
            entities.add(messageEntity);
            text = (String)text + "\n\n" + link;
        }
        return text;
    }

    private void addAttachmentFileToMessage(String chatId, BotDialogElement dialogElement) throws Exception {
        byte[] file = this.runtimeBot.getBotManagerService().getFile(dialogElement.getId());
        if (file != null && file.length > 0) {
            SendDocument document = new SendDocument();
            document.setChatId(chatId);
            document.setDocument(new InputFile((InputStream)new ByteArrayInputStream(file), dialogElement.getJSONConfig().optString("attachmentFileTitle")));
            ((TelegramRuntimeBot)this.runtimeBot).getLongPollingBot().addAttachment(document);
        }
    }

    private ReplyKeyboardMarkup getReplyKeyboardMarkup(List<BotDialogElement> simpleButtons, int buttonInLineCount) {
        ArrayList<KeyboardRow> rows = new ArrayList<KeyboardRow>();
        KeyboardRow keyboardRow = new KeyboardRow();
        int buttonInRowCount = 0;
        for (int x = 0; x < simpleButtons.size(); ++x) {
            String buttonTitle = simpleButtons.get(x).getJSONConfig().optString("text", "");
            KeyboardButton keyboardButton = new KeyboardButton(buttonTitle);
            keyboardRow.add((Object)keyboardButton);
            if (++buttonInRowCount == buttonInLineCount) {
                rows.add(keyboardRow);
                keyboardRow = new KeyboardRow();
                buttonInRowCount = 0;
                continue;
            }
            if (x != simpleButtons.size() - 1) continue;
            rows.add(keyboardRow);
        }
        ReplyKeyboardMarkup replyKeyboardMarkup = new ReplyKeyboardMarkup();
        replyKeyboardMarkup.setResizeKeyboard(Boolean.valueOf(true));
        replyKeyboardMarkup.setOneTimeKeyboard(Boolean.valueOf(false));
        replyKeyboardMarkup.setKeyboard(rows);
        return replyKeyboardMarkup;
    }

    private InlineKeyboardMarkup getInlineKeyboardMarkup(List<BotDialogElement> inlineButtons, int buttonInLineCount) {
        ArrayList buttons = new ArrayList();
        ArrayList<InlineKeyboardButton> row = new ArrayList<InlineKeyboardButton>();
        int countButtonInRow = 0;
        for (int x = 0; x < inlineButtons.size(); ++x) {
            String buttonText = inlineButtons.get(x).getJSONConfig().optString("text");
            InlineKeyboardButton button = new InlineKeyboardButton();
            button.setText(buttonText);
            button.setCallbackData(buttonText);
            row.add(button);
            if (++countButtonInRow == buttonInLineCount) {
                buttons.add(row);
                row = new ArrayList();
                countButtonInRow = 0;
                continue;
            }
            if (x != inlineButtons.size() - 1) continue;
            buttons.add(row);
        }
        InlineKeyboardMarkup inlineKeyboardMarkup = new InlineKeyboardMarkup();
        inlineKeyboardMarkup.setKeyboard(buttons);
        return inlineKeyboardMarkup;
    }

    protected SendMessage buildMessage(Long chatId, String messageText) {
        return new SendMessage(String.valueOf(chatId), messageText);
    }

    @Override
    public BotApiMethod<?> buildErrorMessage(Long chatId, String messageText, boolean useCustomErrorDialog) throws Exception {
        if (useCustomErrorDialog && this.errorDialog != null) {
            return this.buildMessage(chatId, -1, this.errorDialog);
        }
        return new SendMessage(String.valueOf(chatId), Utils.isBlankString((String)messageText) ? "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430" : messageText);
    }

    public SendMessage buildErrorMessage(Long chatId, String messageText) {
        return this.buildMessage(chatId, messageText);
    }

    public SendMessage buildErrorMessage(Long chatId) {
        return this.buildMessage(chatId, "");
    }
}

