/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.gospell;

import java.io.UnsupportedEncodingException;

public class ByteSerializer {
    private byte[] buffer = null;
    private int pos = 0;

    public ByteSerializer(int cap) {
        this.buffer = new byte[cap];
    }

    public void put(int value, int fieldlen) {
        this.put((long)value & 0xFFFFFFFFL, fieldlen);
    }

    public void put(long value, int fieldlen) {
        for (int i = 0; i < fieldlen; ++i) {
            this.buffer[this.pos + fieldlen - i - 1] = (byte)(value & 0xFFL);
            value >>>= 8;
        }
        this.pos += fieldlen;
    }

    public void put(String value) {
        try {
            this.put(value.getBytes("latin1"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void put(byte[] value) {
        System.arraycopy(value, 0, this.buffer, this.pos, value.length);
        this.pos += value.length;
    }

    public byte[] getBuffer() {
        if (this.pos < this.buffer.length) {
            byte[] buffernew = new byte[this.pos];
            System.arraycopy(this.buffer, 0, buffernew, 0, buffernew.length);
            this.buffer = buffernew;
        }
        return this.buffer;
    }
}

