/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.client;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.cerbercrypt.client.DeviceEditor;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.UserDevice;
import ru.bitel.bgbilling.modules.cerbercrypt.common.service.UserDeviceService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.function.Async;

public class ServiceConfigDevices
extends BGUPanel {
    private BGUList<UserDevice> deviceList = new BGUList();
    private DeviceEditor deviceEditor = new DeviceEditor();
    private JPanel rightPanel = new JPanel();
    private CardLayout cardLayout = new CardLayout();

    public ServiceConfigDevices() {
        this.deviceEditor.setDevicesPanel(this);
        JPanel leftPanel = new JPanel(new GridBagLayout());
        leftPanel.add((Component)new JScrollPane((Component)this.deviceList), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        JPanel emptyPanel = new JPanel(new GridBagLayout());
        emptyPanel.add((Component)new JLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.rightPanel.setLayout(this.cardLayout);
        this.rightPanel.add((Component)((Object)this.deviceEditor), "editor");
        this.rightPanel.add((Component)emptyPanel, "empty");
        this.cardLayout.show(this.rightPanel, "empty");
        ClientUtils.addOpenAction(this.deviceList, e -> this.performAction("edit"));
        JSplitPane mainSplit = new JSplitPane();
        mainSplit.setDividerSize(4);
        mainSplit.setDividerLocation(200);
        mainSplit.setLeftComponent(leftPanel);
        mainSplit.setRightComponent(this.rightPanel);
        ClientUtils.addShowCodeListener(this.deviceList);
        this.setLayout(new GridBagLayout());
        this.add(mainSplit, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void jbInit() {
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> Async.of(() -> this.deviceList.setData(((UserDeviceService)((ClientContext)this.getContext()).getPort(UserDeviceService.class)).getUserDevicesList())));
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> this.startEdit(0));
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            UserDevice li = (UserDevice)this.deviceList.getSelectedValue();
            if (li != null) {
                this.startEdit(li.getId());
            }
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            UserDevice li = (UserDevice)this.deviceList.getSelectedValue();
            if (li != null && ClientUtils.confirmDelete((Object)"\u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e")) {
                ((UserDeviceService)((ClientContext)this.getContext()).getPort(UserDeviceService.class)).deleteUserDevice(li.getId());
                this.hideEditor();
            }
        });
    }

    private void startEdit(int id) {
        this.deviceEditor.setId(id);
        this.cardLayout.show(this.rightPanel, "editor");
        this.deviceEditor.performAction("refresh");
    }

    public void hideEditor() {
        this.cardLayout.show(this.rightPanel, "empty");
        this.performAction("refresh");
    }
}

