/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.event.Level;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.ConnectionLog;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.SessionCleanWorker;
import ru.bitel.bgbilling.apps.inet.accounting.bean.TrafficAccountDelta;
import ru.bitel.bgbilling.apps.inet.accounting.bean.TrafficAmountDelta;
import ru.bitel.bgbilling.apps.inet.accounting.bean.TrafficAmountKey;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.BalanceDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.PoolEventPublisher;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.tariff.server.range.TrafficRange;
import ru.bitel.bgbilling.kernel.tariff.server.range.TrafficRangeEntry;
import ru.bitel.bgbilling.kernel.tariff.server.range.TrafficRangeEvent;
import ru.bitel.bgbilling.kernel.tariff.server.range.TrafficRangeKey;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficType;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.bgbilling.modules.inet.server.bean.InetSessionLogDao;
import ru.bitel.bgbilling.modules.inet.server.tariff.max.TrafficMax;
import ru.bitel.bgbilling.modules.inet.server.tariff.max.TrafficMaxDao;
import ru.bitel.bgbilling.modules.inet.server.tariff.max.TrafficMaxEntry;
import ru.bitel.bgbilling.modules.inet.server.tariff.max.TrafficMaxEvent;
import ru.bitel.bgbilling.modules.inet.server.tariff.max.TrafficMaxKey;
import ru.bitel.bgbilling.modules.inet.server.tariff.range.InetTrafficRangeDao;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class SessionFlushingManager
extends BGLogger
implements AutoCloseable {
    private final int moduleId;
    private final EventProcessor eventProcessor;
    private final PoolEventPublisher<ContractBalanceChangedEvent> balanceEP;
    private final PoolEventPublisher<TrafficRangeEvent> trafficRangeEP;
    private final PoolEventPublisher<TrafficMaxEvent> trafficMaxEP;
    private long cacheCalendar1Time = Long.MIN_VALUE;
    private Calendar cacheCalendar1 = new GregorianCalendar();
    private long cacheCalendar2Time = Long.MIN_VALUE;
    private Calendar cacheCalendar2 = new GregorianCalendar();
    private final boolean finish;
    private long currentNextMonthTime = Long.MIN_VALUE;
    private PreparedStatement selectConnectionPS = null;
    private PreparedStatement updateSessionPS = null;
    private PreparedStatement updateSessionAndStatusPS = null;
    private PreparedStatement updateDetailPS = null;
    private PreparedStatement insertDetailPS = null;
    private PreparedStatement updateAccountPS = null;
    private PreparedStatement insertAccountPS = null;
    private InetTrafficRangeDao trafficRangeDao = null;
    private TrafficMaxDao trafficMaxDao = null;
    private Accounting accounting;
    private PreparedStatement mergeSessionLogInsertPS;
    private PreparedStatement mergeSessionDeletePS;
    private PreparedStatement mergeSessionDetailInsertPS;
    private PreparedStatement mergeSessionDetailDeletePS;
    private PreparedStatement mergeSessionAccountInsertPS;
    private PreparedStatement mergeSessionAccountDeletePS;
    private PreparedStatement mergeSessionRouteInsertPS;
    private PreparedStatement mergeSessionRouteDeletePS;
    private PreparedStatement mergeConnectionDeletePS;

    public SessionFlushingManager(Accounting accounting, boolean finish) {
        this.accounting = accounting;
        this.moduleId = accounting.moduleId;
        this.eventProcessor = EventProcessor.getInstance();
        this.balanceEP = accounting.balanceEP;
        this.trafficRangeEP = accounting.trafficRangeEP;
        this.trafficMaxEP = accounting.trafficMaxEP;
        this.finish = finish;
    }

    @Deprecated
    public final boolean flush(Connection con, BalanceDao balanceDao, InetConnectionRuntime connectionRuntime, boolean finish, boolean connectionClose, boolean withCheck, long millis) throws BGException {
        return this.flush(con, balanceDao, connectionRuntime, finish, connectionClose, withCheck, false, millis, false);
    }

    public final boolean flush(Connection con, BalanceDao balanceDao, InetConnectionRuntime connectionRuntime, boolean finish, boolean connectionClose, boolean withCheck, boolean now, long millis, boolean skipData) throws BGException {
        RoundingMode balanceRoundingMode;
        int balanceRoundingScale;
        RoundingMode accountRoundingMode;
        int accountRoundingScale;
        if (finish) {
            accountRoundingScale = 5;
            accountRoundingMode = RoundingMode.HALF_EVEN;
            balanceRoundingScale = 5;
            balanceRoundingMode = RoundingMode.HALF_EVEN;
        } else {
            accountRoundingScale = 2;
            accountRoundingMode = RoundingMode.FLOOR;
            balanceRoundingScale = 2;
            balanceRoundingMode = RoundingMode.FLOOR;
        }
        try {
            Object accountTableName;
            Object detailTableName;
            Object sessionTableName;
            InetConnection connection = connectionRuntime.connection;
            if (connection == null) {
                this.getLogger().info("Connection is null - skipping");
                return false;
            }
            if (connection.getConnectionStatus() == 4) {
                this.getLogger().info("Connection already finished. Skip flushing.");
                return true;
            }
            if (this.updateSessionPS == null) {
                sessionTableName = "inet_session_" + this.moduleId;
                detailTableName = "inet_session_detail_" + this.moduleId;
                accountTableName = "inet_session_account_" + this.moduleId;
                this.selectConnectionPS = con.prepareStatement("SELECT id FROM inet_connection_" + this.moduleId + " WHERE deviceId=? AND id=?");
                this.updateSessionPS = con.prepareStatement("UPDATE " + (String)sessionTableName + " SET sessionCost=sessionCost+?, sessionTime=sessionTime+?, lastActive=? WHERE id=? AND connectionId=?");
                this.updateSessionAndStatusPS = con.prepareStatement("UPDATE " + (String)sessionTableName + " SET sessionCost=sessionCost+?, sessionTime=sessionTime+?, lastActive=?, sessionStop=?, status=? WHERE id=? AND connectionId=?");
                this.updateDetailPS = con.prepareStatement("UPDATE " + (String)detailTableName + " SET amount=amount+? WHERE sessionId=? AND day=? AND hour=? AND trafficTypeId=? AND deviceId=?");
                this.insertDetailPS = con.prepareStatement("INSERT INTO " + (String)detailTableName + " (sessionId, day, hour, trafficTypeId, deviceId, amount) VALUES (?,?,?,?,?,?)");
                this.updateAccountPS = con.prepareStatement("UPDATE " + (String)accountTableName + " SET amount=amount+?, account=account+? WHERE contractId=? AND sessionId=? AND serviceId=?");
                this.insertAccountPS = con.prepareStatement("INSERT INTO " + (String)accountTableName + " (contractId, sessionId, serviceId, amount, account) VALUES (?,?,?,?,?)");
            }
            if (connectionRuntime.nextMonthTime != this.currentNextMonthTime) {
                if (this.trafficRangeDao == null) {
                    this.trafficRangeDao = new InetTrafficRangeDao(con, this.moduleId);
                }
                this.trafficRangeDao.setCurrentMonth(connectionRuntime.sessionStart);
                if (this.trafficMaxDao == null) {
                    this.trafficMaxDao = new TrafficMaxDao(con, this.moduleId);
                }
                this.trafficMaxDao.setCurrentMonth(connectionRuntime.sessionStart);
                if (this.mergeSessionLogInsertPS != null) {
                    this.mergeSessionLogInsertPS.close();
                    this.mergeSessionDeletePS.close();
                    this.mergeSessionDetailInsertPS.close();
                    this.mergeSessionDetailDeletePS.close();
                    this.mergeSessionAccountInsertPS.close();
                    this.mergeSessionAccountDeletePS.close();
                    this.mergeSessionRouteInsertPS.close();
                    this.mergeSessionRouteDeletePS.close();
                    this.mergeConnectionDeletePS.close();
                }
                InetSessionLogDao.checkTables(con, this.moduleId, connectionRuntime.sessionStart);
                sessionTableName = ServerUtils.getModuleMonthTableName((String)"inet_session_log", (Date)connectionRuntime.sessionStart, (int)this.moduleId);
                detailTableName = ServerUtils.getModuleMonthTableName((String)"inet_session_log_detail", (Date)connectionRuntime.sessionStart, (int)this.moduleId);
                accountTableName = ServerUtils.getModuleMonthTableName((String)"inet_session_log_account", (Date)connectionRuntime.sessionStart, (int)this.moduleId);
                String routeTableName = ServerUtils.getModuleMonthTableName((String)"inet_session_log_route", (Date)connectionRuntime.sessionStart, (int)this.moduleId);
                this.mergeSessionLogInsertPS = con.prepareStatement("INSERT INTO " + (String)sessionTableName + " (id, connectionId, parentConnectionId, parentId, splittedId, deviceId, devicePort, agentDeviceId, acctSessionId, username, realm, type, accessCode, servId, calledStationId, callingStationId, ipResourceId, ipAddress, prefixResourceId, prefix, prefixLength, delegatedPrefixResourceId, delegatedPrefix, delegatedPrefixLength, connectionStart, sessionStart, sessionStop, lastActive, deviceState, deviceOptions, sessionTime, sessionCost, status) SELECT s.id, c.id, c.parentId, s.parentId, s.splittedId, c.deviceId, c.devicePort, c.agentDeviceId, c.acctSessionId, c.username, ?, c.type, c.accessCode, c.servId, c.calledStationId, c.callingStationId, c.ipResourceId, c.ipAddress, c.prefixResourceId, c.prefix, c.prefixLength, c.delegatedPrefixResourceId, c.delegatedPrefix, c.delegatedPrefixLength, c.connectionStart, s.sessionStart, s.sessionStop, s.lastActive, s.deviceState, c.deviceOptions, s.sessionTime, s.sessionCost, s.status FROM inet_session_" + this.moduleId + " AS s LEFT JOIN inet_connection_" + this.moduleId + " AS c ON c.id=s.connectionId AND c.deviceId=? WHERE s.id=? AND s.connectionId=?");
                this.mergeSessionDeletePS = con.prepareStatement("DELETE FROM inet_session_" + this.moduleId + " WHERE connectionId=? AND id=?");
                this.mergeSessionDetailInsertPS = con.prepareStatement("INSERT INTO " + (String)detailTableName + " SELECT * FROM inet_session_detail_" + this.moduleId + " WHERE sessionId=?");
                this.mergeSessionDetailDeletePS = con.prepareStatement("DELETE FROM inet_session_detail_" + this.moduleId + " WHERE sessionId=?");
                this.mergeSessionAccountInsertPS = con.prepareStatement("INSERT INTO " + (String)accountTableName + " SELECT * FROM inet_session_account_" + this.moduleId + " WHERE contractId=? AND sessionId=?");
                this.mergeSessionAccountDeletePS = con.prepareStatement("DELETE FROM inet_session_account_" + this.moduleId + " WHERE contractId=? AND sessionId=?");
                this.mergeSessionRouteInsertPS = con.prepareStatement("INSERT INTO " + routeTableName + " (sessionId, subnet, mask) SELECT ?, subnet, mask FROM inet_connection_route_" + this.moduleId + " WHERE connectionId=?");
                this.mergeSessionRouteDeletePS = con.prepareStatement("DELETE FROM inet_connection_route_" + this.moduleId + " WHERE connectionId=?");
                this.mergeConnectionDeletePS = con.prepareStatement("DELETE FROM inet_connection_" + this.moduleId + " WHERE deviceId=? AND id=?");
                this.currentNextMonthTime = connectionRuntime.nextMonthTime;
            }
            Calendar calendar = this.getCalendar(connectionRuntime, connectionRuntime.sessionStartTime);
            int yy = calendar.get(1);
            int mm = calendar.get(2) + 1;
            BigDecimal accountSum = BigDecimal.ZERO;
            long sessionTime = 0L;
            if (ConnectionLog.isDebugEnabled()) {
                ConnectionLog.log(connectionRuntime, Level.DEBUG, "Flushing delta...");
            }
            long currentHour = InetUtils.getHour(millis);
            for (Map.Entry<Long, Map<TrafficAmountKey, TrafficAmountDelta>> entry : connectionRuntime.trafficsDelta.entrySet()) {
                Map<TrafficAmountKey, TrafficAmountDelta> amountDeltaMap = entry.getValue();
                for (Map.Entry<TrafficAmountKey, TrafficAmountDelta> deltaEntry : amountDeltaMap.entrySet()) {
                    TrafficAmountDelta delta = deltaEntry.getValue();
                    TrafficAmountKey key = deltaEntry.getKey();
                    long amount = delta.flushAmountDelta;
                    if (amount == 0L || key.trafficTypeId != TrafficType.TIME_ID) continue;
                    sessionTime += amount;
                }
            }
            for (Map.Entry<Number, Object> entry : connectionRuntime.accountDelta.entrySet()) {
                TrafficAccountDelta account = (TrafficAccountDelta)entry.getValue();
                BigDecimal accountDelta = account.accountDelta;
                if (accountDelta == BigDecimal.ZERO || BigDecimal.ZERO.compareTo(accountDelta = accountDelta.setScale(balanceRoundingScale, balanceRoundingMode)) == 0) continue;
                accountSum = accountSum.add(accountDelta);
            }
            Sum sum = new Sum();
            BigDecimal bigDecimal = connectionRuntime.sessionCostDelta.setScale(accountRoundingScale, accountRoundingMode);
            if (finish) {
                this.updateSessionAndStatusPS.setBigDecimal(1, accountSum);
                this.updateSessionAndStatusPS.setLong(2, sessionTime);
                this.updateSessionAndStatusPS.setTimestamp(3, new Timestamp(connectionRuntime.lastActiveTime() * 1000L));
                this.updateSessionAndStatusPS.setTimestamp(4, TimeUtils.convertDateToTimestampSeconds((Date)connectionRuntime.sessionStop));
                this.updateSessionAndStatusPS.setInt(5, 4);
                this.updateSessionAndStatusPS.setLong(6, connectionRuntime.sessionId);
                this.updateSessionAndStatusPS.setLong(7, connection.getId());
                if (this.updateSessionAndStatusPS.executeUpdate() == 0) {
                    this.selectConnectionPS.setInt(1, connection.getDeviceId());
                    this.selectConnectionPS.setLong(2, connection.getId());
                    selectConnectionRS = this.selectConnectionPS.executeQuery();
                    if (!selectConnectionRS.next()) {
                        this.getLogger().info("Not found connection with id=" + connection.getId() + " in DB for flush-finish");
                        if (connection.getConnectionStatus() < 3) {
                            connection.setConnectionStatus(3);
                        }
                    } else {
                        this.getLogger().error("Cannot find session for finish with id=" + connectionRuntime.sessionId + ", connectionId=" + connection.getId() + ", sessionStart=" + TimeUtils.convertDateToTimestampSeconds((Date)connectionRuntime.sessionStart) + " in DB!");
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug(this.updateSessionAndStatusPS.toString());
                        }
                    }
                    selectConnectionRS.close();
                    return false;
                }
                if (!skipData && !this.flushDelta(con, balanceDao, connectionRuntime, balanceRoundingMode, balanceRoundingScale, sum, currentHour, withCheck, now, yy, mm)) {
                    return false;
                }
                connectionRuntime.sessionCostDelta = connectionRuntime.sessionCostDelta.subtract(bigDecimal);
                assert (sum.accountSum.compareTo(accountSum) == 0);
                assert (sum.sessionTime == sessionTime);
                this.merge(con, connectionRuntime, connection, connectionClose, skipData);
                if (BigDecimal.ZERO.compareTo(bigDecimal) != 0) {
                    BigDecimal balanceAccount = balanceDao.setBalanceAccount(connectionRuntime.contractId, connectionRuntime.superContractId, yy, mm);
                    this.balanceEP.publish((Event)new ContractBalanceChangedEvent(connectionRuntime.contractId, 2, yy, mm, balanceAccount));
                }
            } else {
                this.updateSessionPS.setBigDecimal(1, accountSum);
                this.updateSessionPS.setLong(2, sessionTime);
                this.updateSessionPS.setTimestamp(3, new Timestamp(connectionRuntime.lastActiveTime() * 1000L));
                this.updateSessionPS.setLong(4, connectionRuntime.sessionId);
                this.updateSessionPS.setLong(5, connection.getId());
                if (this.updateSessionPS.executeUpdate() == 0) {
                    this.selectConnectionPS.setInt(1, connection.getDeviceId());
                    this.selectConnectionPS.setLong(2, connection.getId());
                    selectConnectionRS = this.selectConnectionPS.executeQuery();
                    if (!selectConnectionRS.next()) {
                        this.getLogger().info("Not found connection with id=" + connection.getId() + " in DB for flush");
                        if (connection.getConnectionStatus() < 3) {
                            connection.setConnectionStatus(3);
                        }
                    } else {
                        this.getLogger().error("Cannot find session for update with id=" + connectionRuntime.sessionId + ", connectionId=" + connection.getId() + ", sessionStart=" + TimeUtils.convertDateToTimestampSeconds((Date)connectionRuntime.sessionStart) + " in DB!");
                    }
                    selectConnectionRS.close();
                    return false;
                }
                if (!this.flushDelta(con, balanceDao, connectionRuntime, balanceRoundingMode, balanceRoundingScale, sum, currentHour, withCheck, now, yy, mm)) {
                    return false;
                }
                connectionRuntime.sessionCostDelta = connectionRuntime.sessionCostDelta.subtract(bigDecimal);
                assert (sum.accountSum.compareTo(accountSum) == 0);
                assert (sum.sessionTime == sessionTime);
                if (BigDecimal.ZERO.compareTo(bigDecimal) != 0) {
                    balanceDao.addBalanceAccount(connectionRuntime.contractId, connectionRuntime.superContractId, yy, mm, bigDecimal);
                    if (now) {
                        this.eventProcessor.publish((Event)new ContractBalanceChangedEvent(connectionRuntime.contractId, 1, yy, mm, bigDecimal));
                    } else {
                        this.balanceEP.publish((Event)new ContractBalanceChangedEvent(connectionRuntime.contractId, 1, yy, mm, bigDecimal));
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return true;
    }

    private Calendar getCalendar(InetConnectionRuntime connectionRuntime, long millis) {
        Calendar calendar;
        if (millis < connectionRuntime.sessionStartTime) {
            millis = connectionRuntime.sessionStartTime;
            calendar = this.cacheCalendar1;
            if (millis != this.cacheCalendar1Time) {
                calendar.setTimeInMillis(millis);
                this.cacheCalendar1Time = millis;
            }
        } else {
            calendar = this.cacheCalendar2;
            if (millis != this.cacheCalendar2Time) {
                calendar.setTimeInMillis(millis);
                this.cacheCalendar2Time = millis;
            }
        }
        return calendar;
    }

    private boolean flushDelta(Connection con, BalanceDao balanceDao, InetConnectionRuntime connectionRuntime, RoundingMode balanceRoundingMode, int balanceRoundingScale, Sum sum, long currentHour, boolean withCheck, boolean now, int yy, int mm) throws SQLException, BGException {
        int contractId = connectionRuntime.contractId;
        long sessionId = connectionRuntime.sessionId;
        this.updateDetailPS.setLong(2, sessionId);
        Iterator<Map.Entry<Long, Map<TrafficAmountKey, TrafficAmountDelta>>> hourIter = connectionRuntime.trafficsDelta.entrySet().iterator();
        while (hourIter.hasNext()) {
            Map.Entry<Long, Map<TrafficAmountKey, TrafficAmountDelta>> e = hourIter.next();
            Long hour = e.getKey();
            Map<TrafficAmountKey, TrafficAmountDelta> delta = e.getValue();
            this.flushDetailDelta(connectionRuntime, hour, e.getValue(), sum);
            if (currentHour <= hour) continue;
            boolean canRemoveHour = true;
            for (TrafficAmountDelta amount : delta.values()) {
                if (amount.calculateAmountDelta == 0L && amount.flushAmountDelta == 0L) continue;
                canRemoveHour = false;
                break;
            }
            if (!canRemoveHour) continue;
            hourIter.remove();
        }
        long[] amountRef = new long[3];
        boolean result = this.flushTrafficRange(con, connectionRuntime, contractId, withCheck, amountRef, now);
        if (withCheck && !(result &= this.flushTrafficMax(con, connectionRuntime, contractId, withCheck, amountRef, now))) {
            ConnectionLog.log(connectionRuntime, Level.INFO, "Traffic range conflict. Skip finishing for next try.");
            return false;
        }
        this.updateAccountPS.setInt(3, contractId);
        this.updateAccountPS.setLong(4, sessionId);
        for (Map.Entry<Integer, TrafficAccountDelta> accountEntry : connectionRuntime.accountDelta.entrySet()) {
            boolean accountDeltaZero;
            int serviceId = accountEntry.getKey();
            TrafficAccountDelta account = accountEntry.getValue();
            long amountDelta = account.amountDelta;
            BigDecimal accountDelta = account.accountDelta.setScale(balanceRoundingScale, balanceRoundingMode);
            boolean bl = accountDeltaZero = BigDecimal.ZERO.compareTo(accountDelta) == 0;
            if (amountDelta == 0L && accountDeltaZero) continue;
            this.updateAccountPS.setLong(1, amountDelta);
            this.updateAccountPS.setBigDecimal(2, accountDelta);
            this.updateAccountPS.setInt(5, serviceId);
            if (this.updateAccountPS.executeUpdate() <= 0) {
                this.insertAccountPS.setInt(1, contractId);
                this.insertAccountPS.setLong(2, sessionId);
                this.insertAccountPS.setInt(3, serviceId);
                this.insertAccountPS.setLong(4, amountDelta);
                this.insertAccountPS.setBigDecimal(5, accountDelta);
                this.insertAccountPS.executeUpdate();
            }
            if (!accountDeltaZero) {
                balanceDao.addContractAccount(connectionRuntime.contractId, yy, mm, serviceId, accountDelta);
                sum.accountSum = sum.accountSum.add(accountDelta);
                account.accountDelta = account.accountDelta.subtract(accountDelta);
            }
            account.amountDelta -= amountDelta;
        }
        return true;
    }

    private void flushDetailDelta(InetConnectionRuntime connectionRuntime, long millis, Map<TrafficAmountKey, TrafficAmountDelta> amountDeltaMap, Sum sum) throws SQLException, BGException {
        Calendar calendar = this.getCalendar(connectionRuntime, millis);
        int day = calendar.get(5);
        int hour = calendar.get(11);
        this.updateDetailPS.setInt(3, day);
        this.updateDetailPS.setInt(4, hour);
        for (Map.Entry<TrafficAmountKey, TrafficAmountDelta> deltaEntry : amountDeltaMap.entrySet()) {
            TrafficAmountDelta delta = deltaEntry.getValue();
            TrafficAmountKey key = deltaEntry.getKey();
            long amount = delta.flushAmountDelta;
            if (amount == 0L) continue;
            this.updateDetailPS.setLong(1, amount);
            this.updateDetailPS.setInt(5, key.trafficTypeId);
            this.updateDetailPS.setInt(6, key.deviceId);
            if (this.updateDetailPS.executeUpdate() <= 0) {
                this.insertDetailPS.setLong(1, connectionRuntime.sessionId);
                this.insertDetailPS.setInt(2, day);
                this.insertDetailPS.setInt(3, hour);
                this.insertDetailPS.setInt(4, key.trafficTypeId);
                this.insertDetailPS.setInt(5, key.deviceId);
                this.insertDetailPS.setLong(6, amount);
                this.insertDetailPS.executeUpdate();
            }
            delta.flushAmountDelta -= amount;
            if (key.trafficTypeId != TrafficType.TIME_ID) continue;
            sum.sessionTime += amount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean flushTrafficRange(Connection con, InetConnectionRuntime connectionRuntime, int contractId, boolean withCheck, long[] amountRef, boolean now) throws SQLException, BGException {
        TrafficRangeEntry trafficRangeEntry = connectionRuntime.rangedTraffic;
        if (trafficRangeEntry == null || !trafficRangeEntry.delta) {
            return true;
        }
        boolean result = true;
        trafficRangeEntry.lock();
        try {
            for (Map.Entry rangeEntry : trafficRangeEntry.entrySet()) {
                int counter;
                TrafficRange range = (TrafficRange)rangeEntry.getValue();
                long delta = range.delta;
                if (delta == 0L) continue;
                TrafficRangeKey key = (TrafficRangeKey)rangeEntry.getKey();
                long keyValue = key.getKey();
                switch (TrafficRangeKey.getMode((long)keyValue)) {
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        counter = ++range.counter;
                        break;
                    }
                    default: {
                        this.getLogger().debug("flushTrafficRange: contractId={}; key={}; delta={}; range={}", new Object[]{contractId, key, delta, range});
                        counter = this.trafficRangeDao.add(contractId, key, connectionRuntime.currentDay, delta, amountRef, range.amount, range.counter, range.maxAmount);
                        this.getLogger().debug("flushTrafficRange: counter={}; amountRef[0]={}; range={}", new Object[]{counter, amountRef[0], range});
                        if (this.finish && withCheck && range.amount != amountRef[0]) {
                            result = false;
                        }
                        range.amount = amountRef[0];
                        range.counter = counter;
                    }
                }
                range.delta = 0L;
                if (now) {
                    this.eventProcessor.publish((Event)new TrafficRangeEvent(this.trafficRangeEP, contractId, key, counter, range.amount, delta, range.maxAmount));
                    continue;
                }
                this.trafficRangeEP.publish((Event)new TrafficRangeEvent(this.trafficRangeEP, contractId, key, counter, range.amount, delta, range.maxAmount));
            }
            trafficRangeEntry.delta = false;
            if (!con.getAutoCommit()) {
                con.commit();
            }
        }
        finally {
            trafficRangeEntry.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean flushTrafficMax(Connection con, InetConnectionRuntime connectionRuntime, int contractId, boolean withCheck, long[] amountRef, boolean now) throws SQLException, BGException {
        boolean result = true;
        TrafficMaxEntry trafficMaxEntry = connectionRuntime.maxTraffic;
        if (trafficMaxEntry != null && trafficMaxEntry.delta) {
            trafficMaxEntry.lock();
            try {
                for (Map.Entry<TrafficMaxKey, TrafficMax> rangeEntry : trafficMaxEntry.entrySet()) {
                    TrafficMax range = rangeEntry.getValue();
                    long deltaMax = range.deltaMax;
                    long delta1 = range.delta1;
                    long delta2 = range.delta2;
                    if (delta1 == 0L && delta2 == 0L && deltaMax == 0L) continue;
                    TrafficMaxKey key = rangeEntry.getKey();
                    int counter = this.trafficMaxDao.add(contractId, key, connectionRuntime.currentDay, deltaMax, delta1, delta2, amountRef, range.counter);
                    if (this.finish && withCheck && range.amountMax != amountRef[0]) {
                        result = false;
                    }
                    range.amountMax = amountRef[0];
                    range.amount1 = amountRef[1];
                    range.amount2 = amountRef[2];
                    range.counter = counter;
                    range.deltaMax = 0L;
                    range.delta1 = 0L;
                    range.delta2 = 0L;
                    if (now) {
                        this.eventProcessor.publish((Event)new TrafficMaxEvent(this.trafficMaxEP, contractId, key, counter, range.amountMax, range.amount1, range.amount2, deltaMax, delta1, delta2));
                        continue;
                    }
                    this.trafficMaxEP.publish((Event)new TrafficMaxEvent(this.trafficMaxEP, contractId, key, counter, range.amountMax, range.amount1, range.amount2, deltaMax, delta1, delta2));
                }
                trafficMaxEntry.delta = false;
                if (!con.getAutoCommit()) {
                    con.commit();
                }
            }
            finally {
                trafficMaxEntry.unlock();
            }
        }
        return result;
    }

    private void merge(Connection con, InetConnectionRuntime connectionRuntime, InetConnection connection, boolean connectionClose, boolean skipData) throws SQLException {
        try {
            long connectionId = connection.getId();
            long sessionId = connectionRuntime.sessionId;
            int contractId = connectionRuntime.contractId;
            String realm = connectionRuntime.getRealm();
            this.mergeSessionLogInsertPS.setString(1, "default".equals(realm) ? null : realm);
            this.mergeSessionLogInsertPS.setInt(2, connection.getDeviceId());
            this.mergeSessionLogInsertPS.setLong(3, sessionId);
            this.mergeSessionLogInsertPS.setLong(4, connectionId);
            this.mergeSessionLogInsertPS.executeUpdate();
            if (!skipData) {
                this.mergeSessionDetailInsertPS.setLong(1, sessionId);
                this.mergeSessionDetailInsertPS.executeUpdate();
                this.mergeSessionAccountInsertPS.setInt(1, contractId);
                this.mergeSessionAccountInsertPS.setLong(2, sessionId);
                this.mergeSessionAccountInsertPS.executeUpdate();
            }
            this.mergeSessionRouteInsertPS.setLong(1, sessionId);
            this.mergeSessionRouteInsertPS.setLong(2, connectionId);
            int route = this.mergeSessionRouteInsertPS.executeUpdate();
            if (connectionClose) {
                this.mergeConnectionDeletePS.setInt(1, connection.getDeviceId());
                this.mergeConnectionDeletePS.setLong(2, connectionId);
                int connectionDeleteResult = this.mergeConnectionDeletePS.executeUpdate();
                if (connectionDeleteResult != 1) {
                    this.getLogger().error("Connection delete result=" + connectionDeleteResult);
                }
                if (route > 0) {
                    this.mergeSessionRouteDeletePS.setLong(1, connectionId);
                    this.mergeSessionRouteDeletePS.executeUpdate();
                }
            }
            this.mergeSessionDeletePS.setLong(1, connectionId);
            this.mergeSessionDeletePS.setLong(2, sessionId);
            int sessionDeleteResult = this.mergeSessionDeletePS.executeUpdate();
            if (sessionDeleteResult != 1) {
                this.getLogger().error("Session delete result=" + sessionDeleteResult);
            }
            if (this.accounting.getSessionCleanWorker() != null) {
                try {
                    ServerContext context = (ServerContext)ServerContext.get();
                    context.addCommitable(() -> {
                        try {
                            this.accounting.getSessionCleanWorker().offer(new SessionCleanWorker.SessionCleanTask(contractId, sessionId));
                        }
                        catch (Exception ex) {
                            this.logError(ex);
                        }
                    });
                }
                catch (Exception ex) {
                    this.logError(ex);
                }
            } else {
                this.mergeSessionAccountDeletePS.setInt(1, contractId);
                this.mergeSessionAccountDeletePS.setLong(2, sessionId);
                this.mergeSessionAccountDeletePS.executeUpdate();
                this.mergeSessionDetailDeletePS.setLong(1, sessionId);
                this.mergeSessionDetailDeletePS.executeUpdate();
            }
        }
        catch (SQLException ex) {
            try {
                con.rollback();
            }
            catch (Exception ex1) {
                this.logError(ex1);
            }
            throw ex;
        }
    }

    @Override
    public void close() {
        ServerUtils.recycle((Object[])new Object[]{this.selectConnectionPS, this.updateSessionPS, this.updateSessionAndStatusPS, this.updateDetailPS, this.insertDetailPS, this.updateAccountPS, this.insertAccountPS, this.trafficRangeDao, this.trafficMaxDao});
        ServerUtils.recycle((Object[])new Object[]{this.mergeSessionLogInsertPS, this.mergeSessionDeletePS, this.mergeSessionDetailInsertPS, this.mergeSessionAccountInsertPS, this.mergeSessionRouteInsertPS, this.mergeSessionRouteDeletePS, this.mergeConnectionDeletePS, this.mergeSessionDetailDeletePS, this.mergeSessionAccountDeletePS});
        this.currentNextMonthTime = Long.MIN_VALUE;
        this.mergeSessionLogInsertPS = null;
        this.mergeSessionDeletePS = null;
        this.mergeSessionDetailInsertPS = null;
        this.mergeSessionDetailDeletePS = null;
        this.mergeSessionAccountInsertPS = null;
        this.mergeSessionAccountDeletePS = null;
        this.mergeSessionRouteInsertPS = null;
        this.mergeSessionRouteDeletePS = null;
        this.mergeConnectionDeletePS = null;
        this.selectConnectionPS = null;
        this.updateSessionPS = null;
        this.updateSessionAndStatusPS = null;
        this.updateDetailPS = null;
        this.insertDetailPS = null;
        this.updateAccountPS = null;
        this.insertAccountPS = null;
        this.trafficRangeDao = null;
        this.trafficMaxDao = null;
    }

    private static class Sum {
        BigDecimal accountSum = BigDecimal.ZERO;
        long sessionTime;

        private Sum() {
        }
    }
}

