/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.action;

import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.ipn.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.ipn.server.bean.Iface;
import ru.bitel.bgbilling.modules.ipn.server.bean.IfaceManager;
import ru.bitel.common.Utils;

public class ActionIfaceUpdate
extends ActionBase {
    public void doAction() throws Exception {
        int id = this.getIntParameter("id", -1);
        int sourceId = this.getIntParameter("source_id", 0);
        String title = this.getParameter("title");
        int zoneId = this.getIntParameter("zone_id", 0);
        int number = this.getIntParameter("number", -2);
        if (this.mid <= 0 || id < 0 || sourceId <= 0 || Utils.isEmptyString((String)title) || zoneId == 0 || number < -1) {
            throw new BGIllegalArgumentException();
        }
        Iface newIface = new Iface();
        newIface.setId(id);
        newIface.setNumber(number);
        newIface.setSourceId(sourceId);
        newIface.setTitle(title);
        newIface.setZoneId(zoneId);
        IfaceManager man = new IfaceManager(this.con, this.mid);
        try {
            man.updateIface(newIface);
        }
        catch (BGException e) {
            throw new BGException(e.getMessage());
        }
        List<Iface> ifaceList = man.getSourceIfaceList(sourceId);
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        for (Iface iface : ifaceList) {
            Element row = this.createElement(data, "row");
            row.setAttribute("id", String.valueOf(iface.getId()));
            row.setAttribute("number", String.valueOf(iface.getNumber()));
            row.setAttribute("title", iface.getTitle());
            row.setAttribute("zone_id", String.valueOf(iface.getZoneId()));
            row.setAttribute("source_id", String.valueOf(iface.getSourceId()));
        }
    }
}

