/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server;

import bitel.billing.server.util.terminal.AbstractTerminalSession;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.modules.ipn.server.GateWorker;
import ru.bitel.bgbilling.modules.ipn.server.UserStatus;
import ru.bitel.bgbilling.modules.ipn.server.bean.command.GateCommandUtil;

public abstract class AbstractMikrotikGateWorker
extends GateWorker {
    @Override
    protected void doSync() {
    }

    protected void processSession(AbstractTerminalSession session) throws Exception {
        String buffer = this.doCommand(session, "ip firewall address-list print without-paging");
        for (UserStatus status : this.statusList) {
            String[] rules;
            Integer cid = status.contractId;
            if (this.ruleExists(cid, buffer)) {
                if (status.status <= 0) continue;
                if (status.status == 3) {
                    for (String rule : rules = this.getDeleteRules(status)) {
                        this.doCommand(session, rule);
                    }
                    continue;
                }
                for (String rule : rules = this.getCloseRules(status)) {
                    this.doCommand(session, rule);
                }
                continue;
            }
            if (status.status != 0) continue;
            for (String rule : rules = this.getOpenRules(status)) {
                this.doCommand(session, rule);
            }
        }
        session.doCommandAsync("quit");
    }

    protected String doCommand(AbstractTerminalSession session, String rule) throws Exception {
        return session.doCommand(rule);
    }

    private boolean ruleExists(Integer cid, String buffer) throws Exception {
        return buffer.indexOf("!!" + cid + "!!") >= 0;
    }

    private String[] getOpenRules(UserStatus status) {
        return this.getRules(status, "\\[OPEN\\](.*)\\[/OPEN\\]");
    }

    private String[] getCloseRules(UserStatus status) {
        return this.getRules(status, "\\[CLOSE\\](.*)\\[/CLOSE\\]");
    }

    private String[] getDeleteRules(UserStatus status) {
        return this.getRules(status, "\\[DELETE\\](.*)\\[/DELETE\\]");
    }

    private String[] getRules(UserStatus status, String template) {
        Pattern pattern;
        Matcher m;
        String rule = status.rule.getRuleText();
        if (status.ruleType != null) {
            String ruleText = GateCommandUtil.getRule(this.gateType, status.ruleType);
            HashMap<String, String> replacements = new HashMap<String, String>();
            replacements.put("\\{CID\\}", String.valueOf(status.contractId));
            rule = GateCommandUtil.generateRule(ruleText, status.rule.getRuleText(), replacements, status.ruleType);
        }
        if ((m = (pattern = Pattern.compile(template, 32)).matcher(rule)).find()) {
            rule = m.group(1);
        }
        rule.replaceAll("\r", "");
        String[] parts = rule.trim().split("\n");
        return parts;
    }
}

