/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.vlan;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.ipn.common.bean.CiscoRule;
import ru.bitel.bgbilling.modules.ipn.server.GateWorker;
import ru.bitel.bgbilling.modules.ipn.server.UserStatus;
import ru.bitel.bgbilling.modules.ipn.server.bean.Gate;
import ru.bitel.bgbilling.modules.ipn.server.bean.GateType;
import ru.bitel.bgbilling.modules.ipn.server.bean.RuleType;
import ru.bitel.bgbilling.modules.ipn.server.bean.VlanManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.command.GateCommandUtil;
import ru.bitel.bgbilling.modules.ipn.server.bean.command.LoopPattern;
import ru.bitel.bgbilling.server.util.ssh.SSHSession;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class CiscoSSHSwitchGateWorker
extends GateWorker {
    @Override
    protected void doSync() {
        String host = this.gate.getHost();
        int port = this.gate.getPort();
        Preferences gateSetup = new Preferences(this.gate.getConfig(), "\r\n");
        String login = gateSetup.get("login", "root");
        int timeout = gateSetup.getInt("timeout", 0);
        String pswd = this.gate.getKeyword();
        if (this.log.isDebugEnabled()) {
            this.log.debug(" gate: " + host + ":" + port + " login: " + login + " pswd: " + pswd);
        }
        SSHSession session = null;
        StringBuffer result = new StringBuffer();
        try {
            session = new SSHSession(host, port, login, pswd);
            session.setTimeout(timeout);
            session.connect();
            result.append(session.doCommand("configure"));
            VlanManager manager = new VlanManager(this.mid, this.con);
            for (UserStatus status : this.statusList) {
                String[] rules;
                Gate parent = this.gate;
                while ((parent = parent.getParent()) != null && parent.getTypeId() == 0) {
                }
                int vid = -1;
                if (parent != null) {
                    vid = manager.getVlan(parent.getId(), status.contractId);
                }
                if (status.status == 0) {
                    for (String rule : rules = this.getOpenRules(status, vid)) {
                        result.append(session.doCommand(rule));
                    }
                    continue;
                }
                for (String rule : rules = this.getCloseRules(status, vid)) {
                    result.append(session.doCommand(rule));
                }
            }
            result.append(session.doCommand("exit"));
        }
        catch (Exception e) {
            this.log.error("", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (session != null) {
                try {
                    session.disconnect();
                }
                catch (BGException e) {
                    this.log.error((Object)e);
                }
            }
        }
    }

    private String[] getOpenRules(UserStatus status, int vid) {
        return this.getRules(status, "\\[OPEN\\](.*)\\[/OPEN\\]", vid);
    }

    private String[] getCloseRules(UserStatus status, int vid) {
        return this.getRules(status, "\\[CLOSE\\](.*)\\[/CLOSE\\]", vid);
    }

    private String[] getRules(UserStatus status, String template, int vid) {
        Pattern pattern;
        Matcher m;
        CiscoRule ciscoRule = new CiscoRule(status.rule.getRuleText());
        String rule = "";
        if (status.ruleType != null) {
            rule = CiscoSSHSwitchGateWorker.generateRule(ciscoRule, vid, this.gateType, status.ruleType);
        }
        if ((m = (pattern = Pattern.compile(template, 32)).matcher(rule)).find()) {
            rule = m.group(1);
        }
        rule.replaceAll("\r", "");
        String[] parts = rule.split("\n");
        return parts;
    }

    public static String generateRule(CiscoRule rule, int vid, GateType gateType, RuleType ruleType) {
        String ruleText = GateCommandUtil.getRule(gateType, ruleType);
        HashMap<String, String> replacements = new HashMap<String, String>();
        if (vid > 0) {
            replacements.put("\\{VID\\}", String.valueOf(vid));
        }
        List<LoopPattern> loops = GateCommandUtil.getAddresLoops(rule.getAddresses());
        String[] ports_ = CiscoSSHSwitchGateWorker.getPorts(rule.getPorts());
        ArrayList<String> portReplacements = new ArrayList<String>();
        portReplacements.add("\\{PORT\\}");
        ArrayList<List<String>> objects = new ArrayList<List<String>>();
        for (String port : ports_) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(port);
            objects.add(list);
        }
        if (ports_ != null) {
            LoopPattern p = new LoopPattern();
            p.setLoopPatern("LOOP_PORT");
            p.setReplacements(portReplacements);
            p.setObjects(objects);
            loops.add(p);
        }
        return GateCommandUtil.generateRule(ruleText, replacements, ruleType, loops);
    }

    private static String[] getPorts(String ports) {
        String[] parts;
        ArrayList<String> portList = new ArrayList<String>();
        if (Utils.isEmptyString((String)ports)) {
            return new String[0];
        }
        for (String part : parts = ports.split(";")) {
            String[] parts2 = part.split(":");
            if (parts2.length < 2) continue;
            String port = parts2[1];
            portList.add(port);
        }
        String[] ports_ = new String[portList.size()];
        for (int i = 0; i < ports_.length; ++i) {
            ports_[i] = (String)portList.get(i);
        }
        return ports_;
    }
}

