/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common;

import jakarta.mail.internet.InternetAddress;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.json.JSONArray;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.localize.Localizer;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.ListItem;
import ru.bitel.common.model.Period;

public class Utils {
    public static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final char[] HEX_LOWERCASE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final long KB = 1024L;
    public static final long MB = 0x100000L;
    public static final long GB = 0x40000000L;
    public static final int MINUTE = 60;
    public static final int HOUR = 3600;
    public static final int DAY = 86400;
    public static final Pattern patternComma = Pattern.compile("\\s*,\\s*");
    public static final Pattern patternSemicolon = Pattern.compile("\\s*;\\s*");
    public static final Pattern patternColon = Pattern.compile("\\s*:\\s*");
    public static String PART = "sdlkfj9879fdgdf08098gdr09809g8d0fg09809d8fg0980d9f8g09809g809dfgsgsdfdsf98sd09f8sd0f8098sdf0";
    private static final SecureRandom random = new SecureRandom();
    public static final String GUID_PREFIX = "GUID";
    public static final AtomicLong guidGenerator = new AtomicLong(System.nanoTime());
    private static final Provider md4Provider;
    private static final Pattern isArrayStringPattern;
    private static final String[] charTable;
    private static final char START_CHAR = '\u0401';
    public static final String CODE_VERSION = "9.2501";
    private static final Map<String, Set<String>> SPEC_VERSIONS;

    public static final boolean isEmptyString(String value) {
        return value == null || value.length() == 0;
    }

    public static final boolean isBlankString(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static final boolean isZeroFilledArray(byte[] val) {
        int size = val.length;
        for (int i = 0; i < size; ++i) {
            if (val[i] == 0) continue;
            return false;
        }
        return true;
    }

    public static final boolean notEmptyString(String value) {
        return value != null && value.length() > 0;
    }

    public static final boolean notBlankString(String value) {
        return value != null && value.trim().length() > 0;
    }

    public static boolean notEmptyCollection(Collection<?> collection) {
        return collection != null && collection.size() > 0;
    }

    public static boolean isEmptyCollection(Collection<?> collection) {
        return !Utils.notEmptyCollection(collection);
    }

    public static boolean notEmptyArray(Object[] array) {
        return array != null && array.length > 0;
    }

    public static final String maskNull(String value) {
        return Utils.maskNull(value, "");
    }

    public static final String maskNull(String value, String def) {
        return value != null ? value : def;
    }

    public static final <K> List<K> maskNull(List<K> value) {
        return value != null ? value : new ArrayList(5);
    }

    public static final <K> Set<K> maskNull(Set<K> value) {
        return value != null ? value : new HashSet();
    }

    public static final BigDecimal maskNull(BigDecimal value) {
        return value != null ? value : BigDecimal.ZERO;
    }

    public static final Long maskNull(Long value) {
        return value != null ? value : Long.valueOf(0L);
    }

    public static final String maskBlank(String value, String defaultValue) {
        return Utils.isBlankString(value) ? defaultValue : value;
    }

    public static int parseInt(String str, int defaultValue) {
        try {
            return Integer.parseInt(str);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static int parseInt(String str) {
        return Utils.parseInt(str, 0);
    }

    public static Integer parseInteger(String str, Integer defaultValue) {
        try {
            return Integer.valueOf(str);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static long parseLong(String str, long defaultValue) {
        try {
            return Long.parseLong(str);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public static long parseLong(String str) {
        return Utils.parseLong(str, 0L);
    }

    public static float parseFloat(String str, float defaultValue) {
        try {
            return Float.parseFloat(str);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public static double parseDouble(String str, double defaultValue) {
        try {
            return Double.parseDouble(str);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public static BigDecimal parseBigDecimal(String str, BigDecimal defaultValue) {
        try {
            return new BigDecimal(str);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public static BigDecimal parseBigDecimalSumma(String str) {
        try {
            return new BigDecimal(str);
        }
        catch (NumberFormatException ex) {
            if (str.indexOf(44) == -1) {
                throw ex;
            }
            return new BigDecimal(str.replace(',', '.'));
        }
    }

    public static boolean parseBoolean(String str, boolean defaultValue) {
        if (Utils.isBlankString(str)) {
            return defaultValue;
        }
        return str.equals("1") || str.equalsIgnoreCase("true") || str.equalsIgnoreCase("yes") || str.equalsIgnoreCase("on");
    }

    public static boolean parseBoolean(String str) {
        return Utils.parseBoolean(str, false);
    }

    public static Period parsePeriod(String date1, String date2, Period defaultPeriod) {
        Period period = defaultPeriod;
        if (date1 != null || date2 != null) {
            Date date3;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            if (date1 != null) {
                try {
                    date3 = dateFormat.parse(date1);
                    if (period == null) {
                        period = new Period();
                    }
                    period.setDateFrom(date3);
                }
                catch (ParseException date3) {
                    // empty catch block
                }
            }
            if (date2 != null) {
                try {
                    date3 = dateFormat.parse(date2);
                    if (period == null) {
                        period = new Period();
                    }
                    period.setDateTo(date3);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        return period;
    }

    public static final List<String> toList(String valuesStr) {
        ArrayList<String> result = new ArrayList<String>();
        if (Utils.notBlankString(valuesStr)) {
            Collections.addAll(result, patternComma.split(valuesStr.trim()));
        }
        return result;
    }

    public static final List<String> toList(String valuesStr, String delim) {
        ArrayList<String> result = new ArrayList<String>();
        if (Utils.notBlankString(valuesStr)) {
            Collections.addAll(result, valuesStr.trim().split(delim));
        }
        return result;
    }

    public static final List<Integer> toIntegerList(String valuesStr) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (Utils.notBlankString(valuesStr)) {
            String[] values;
            for (String value : values = patternComma.split(valuesStr)) {
                result.add(Utils.parseInt(value.trim()));
            }
        }
        return result;
    }

    public static final List<BigDecimal> toBigDecimalList(String valuesStr) {
        ArrayList<BigDecimal> result = new ArrayList<BigDecimal>();
        if (Utils.notBlankString(valuesStr)) {
            String[] values;
            for (String value : values = patternComma.split(valuesStr)) {
                result.add(new BigDecimal(value.trim()));
            }
        }
        return result;
    }

    public static final int[] toIntArray(String valuesStr) {
        int[] array = new int[]{};
        if (Utils.notBlankString(valuesStr)) {
            int i = 0;
            String[] values = patternComma.split(valuesStr);
            array = new int[values.length];
            for (String value : values) {
                array[i++] = Utils.parseInt(value.trim());
            }
        }
        return array;
    }

    public static final List<Long> toLongList(String valuesStr) {
        ArrayList<Long> result = new ArrayList<Long>();
        if (Utils.notBlankString(valuesStr)) {
            String[] values;
            for (String value : values = patternComma.split(valuesStr)) {
                result.add(Utils.parseLong(value.trim()));
            }
        }
        return result;
    }

    public static final Set<String> toSet(String valuesStr) {
        HashSet<String> result = new HashSet<String>();
        if (Utils.notBlankString(valuesStr)) {
            Collections.addAll(result, patternComma.split(valuesStr.trim()));
        }
        return result;
    }

    public static final Set<Integer> toIntegerSet(String valuesStr) {
        HashSet<Integer> result = new HashSet<Integer>();
        if (Utils.notBlankString(valuesStr)) {
            String[] values;
            for (String value : values = patternComma.split(valuesStr)) {
                result.add(Utils.parseInt(value.trim()));
            }
        }
        return result;
    }

    public static final Set<Long> toLongSet(String valuesStr) {
        HashSet<Long> result = new HashSet<Long>();
        if (Utils.notBlankString(valuesStr)) {
            String[] values;
            for (String value : values = patternComma.split(valuesStr)) {
                result.add(Utils.parseLong(value.trim()));
            }
        }
        return result;
    }

    public static final String toString(Iterable<?> valuesList) {
        return Utils.toString(valuesList, ",");
    }

    public static final String toString(Iterable<?> valuesList, String delim) {
        if (valuesList != null) {
            StringBuilder result = new StringBuilder();
            for (Object next : valuesList) {
                result.append(next);
                result.append(delim);
            }
            if (result.length() > 0) {
                result.setLength(result.length() - delim.length());
            }
            return result.toString();
        }
        return "";
    }

    public static final String toString(Object[] valuesList, String delim) {
        return Utils.toString(Arrays.asList(valuesList), delim);
    }

    public static final String toString(Map<?, ?> valuesMap, String delim) {
        return Utils.toString(valuesMap.entrySet(), delim);
    }

    public static final String toString(List<?> valuesList, int fromPos) {
        return Utils.toString(valuesList, ",", fromPos);
    }

    public static final String toString(List<?> valuesList, String delim, int fromPos) {
        StringBuilder result = new StringBuilder();
        int size = valuesList.size();
        for (int i = fromPos; i < size; ++i) {
            result.append(valuesList.get(i));
            result.append(delim);
        }
        if (result.length() > 0) {
            result.setLength(result.length() - 1);
        }
        return result.toString();
    }

    public static final long enumToMask(String mask) {
        long result = 0L;
        if (mask != null) {
            String[] codes = patternComma.split(mask);
            for (int i = 0; i < codes.length; ++i) {
                int code = Utils.parseInt(codes[i], -1);
                if (code < 0) continue;
                result |= 1L << code;
            }
        }
        return result;
    }

    public static String maskToEnum(long mask) {
        StringBuilder result = new StringBuilder();
        long pattern = 1L;
        for (int i = 0; i < 63; ++i) {
            if ((mask & pattern) == pattern) {
                result.append(i).append(',');
            }
            pattern <<= 1;
        }
        if (result.length() > 0) {
            result.setLength(result.length() - 1);
        }
        return result.toString();
    }

    public static String formatCost(float value) {
        return Utils.formatCost(value, 2);
    }

    public static String formatCost(BigDecimal value) {
        return Utils.formatCost(value, 2);
    }

    private static DecimalFormat getFormatString(int precission) {
        StringBuilder sb = new StringBuilder("########0");
        if (precission > 0) {
            sb.append(".");
        }
        for (int i = 0; i < precission; ++i) {
            sb.append("0");
        }
        DecimalFormat df = new DecimalFormat(sb.toString(), Localizer.getDecimalFormatSymbols());
        return df;
    }

    public static String formatCost(float value, int precission) {
        return Utils.getFormatString(precission).format(value);
    }

    public static String formatCost(BigDecimal value, int precission) {
        if (value != null) {
            return Utils.getFormatString(precission).format(value);
        }
        return null;
    }

    public static String formatCostByGrouping(BigDecimal value, int sizeGroup, int precission) {
        if (value == null) {
            return null;
        }
        DecimalFormatSymbols dfs = Localizer.getDecimalFormatSymbols();
        dfs.setGroupingSeparator(' ');
        Object pattern = "###,###,###,###,###";
        if (sizeGroup > 0 && sizeGroup != 3) {
            pattern = ((String)pattern).replaceAll("###", Utils.multiLetter("#", sizeGroup));
        }
        pattern = ((String)pattern).replaceAll("#$", "0");
        if (precission > 0) {
            pattern = (String)pattern + "." + Utils.multiLetter("0", precission);
        }
        return new DecimalFormat((String)pattern, dfs).format(value);
    }

    public static String formatSessionCost(BigDecimal value) {
        if (value != null) {
            DecimalFormatSymbols dfs = Localizer.getDecimalFormatSymbols();
            dfs.setGroupingSeparator(' ');
            DecimalFormat df = new DecimalFormat("###,###,##0.00000", dfs);
            return df.format(value);
        }
        return null;
    }

    public static String formatSessionCost(float value) {
        DecimalFormatSymbols dfs = Localizer.getDecimalFormatSymbols();
        dfs.setGroupingSeparator(' ');
        DecimalFormat df = new DecimalFormat("###,###,##0.00000", dfs);
        return df.format(value);
    }

    public static final String memoryStatus() {
        StringBuilder report = new StringBuilder(50);
        DecimalFormat df = new DecimalFormat("###,###,###,###");
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setGroupingSeparator(' ');
        df.setDecimalFormatSymbols(dfs);
        Runtime r = Runtime.getRuntime();
        report.append("Memory total: ");
        report.append(df.format(r.totalMemory()));
        report.append("; max: ");
        report.append(df.format(r.maxMemory()));
        report.append("; free: ");
        report.append(df.format(r.freeMemory()));
        StringBuilder sb = report.append("\nMemory pools:");
        for (MemoryPoolMXBean memoryPoolMXBean : ManagementFactory.getMemoryPoolMXBeans()) {
            sb.append("\n  ");
            sb.append(memoryPoolMXBean.getType() + "[" + memoryPoolMXBean.getName() + "]: ");
            sb.append("max: ");
            sb.append(df.format(memoryPoolMXBean.getUsage().getMax()));
            sb.append("; used: ");
            sb.append(df.format(memoryPoolMXBean.getUsage().getUsed()));
            sb.append("; peek: ");
            sb.append(df.format(memoryPoolMXBean.getPeakUsage().getUsed()));
        }
        sb = report.append("\nBuffer pools:");
        List<BufferPoolMXBean> bufferPools = ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class);
        for (BufferPoolMXBean pool : bufferPools) {
            sb.append("\n  ");
            sb.append("[" + pool.getName() + "]: ");
            sb.append("count: ");
            sb.append(pool.getCount());
            sb.append("; memoryUsed: ");
            sb.append(df.format(pool.getMemoryUsed()));
        }
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        report.append("\nThread count: ");
        report.append(threadMXBean.getThreadCount());
        return report.toString();
    }

    public static final String memoryStatusShort() {
        long UNIT_DELIM = 0x100000L;
        String UNIT_NAME = "M";
        long useMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        String str = String.valueOf(useMemory / 0x100000L) + "M";
        long totalMemory = Runtime.getRuntime().totalMemory();
        str = str + "/" + String.valueOf(totalMemory / 0x100000L) + "M";
        long maxMemory = Runtime.getRuntime().maxMemory();
        if (maxMemory != Long.MAX_VALUE) {
            str = str + "/" + String.valueOf(maxMemory / 0x100000L) + "M";
        } else {
            str = str + "/unlim";
            maxMemory = totalMemory;
        }
        return str;
    }

    public static String bytesToHexString(byte[] value) {
        return Utils.bytesToString(value, true, null);
    }

    public static byte[] hexStringToBytes(String value) {
        return Utils.stringToBytes(value, " ");
    }

    public static String bytesToString(byte[] value) {
        return Utils.bytesToString(value, true, " ");
    }

    public static String bytesToString(byte[] bytes, boolean upperCase, String delimeter) {
        int delimeterLength;
        char[] hex;
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        char[] cArray = hex = upperCase ? HEX : HEX_LOWERCASE;
        if (delimeter != null && (delimeterLength = delimeter.length()) > 0) {
            StringBuilder sb = new StringBuilder(bytes.length * (2 + delimeterLength));
            int size = bytes.length;
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    sb.append(delimeter);
                }
                sb.append(hex[(bytes[i] & 0xF0) >> 4]);
                sb.append(hex[bytes[i] & 0xF]);
            }
            return sb.toString();
        }
        char[] chars = new char[bytes.length * 2];
        int j = 0;
        for (int i = 0; i < bytes.length; ++i) {
            int v = bytes[i] & 0xFF;
            chars[j++] = hex[v >>> 4];
            chars[j++] = hex[v & 0xF];
        }
        return new String(chars);
    }

    public static byte[] stringToBytes(String s, String delimeter) {
        byte[] result;
        int i;
        StringTokenizer st;
        int size;
        if (Utils.isBlankString(s)) {
            return null;
        }
        if (Utils.notEmptyString(delimeter) && (size = (st = new StringTokenizer(s, delimeter)).countTokens()) > 1) {
            byte[] result2 = new byte[size];
            int pos = 0;
            try {
                while (st.hasMoreTokens()) {
                    result2[pos++] = (byte)Integer.parseInt(st.nextToken().trim(), 16);
                }
            }
            catch (Exception ex) {
                BGLogger.error(ex);
            }
            return result2;
        }
        int size2 = s.length();
        if (size2 % 2 == 0) {
            j = 0;
            i = 0;
            result = new byte[size2 / 2];
        } else {
            j = 1;
            i = 1;
            result = new byte[size2 / 2 + 1];
            result[0] = (byte)Character.digit(s.charAt(0), 16);
        }
        while (i < size2) {
            int digit1 = Character.digit(s.charAt(i++), 16);
            int digit2 = Character.digit(s.charAt(i++), 16);
            result[j++] = (byte)(digit1 * 16 + digit2);
        }
        return result;
    }

    public static byte[] byteBufferAsArray(ByteBuffer data) {
        return Utils.byteBufferAsArray(data, data.capacity());
    }

    public static byte[] byteBufferAsArray(ByteBuffer data, int length) {
        byte[] result = new byte[length];
        data.get(result);
        data.rewind();
        return result;
    }

    public static final Set<Integer> getIdSet(Collection<? extends Id> collection) {
        HashSet<Integer> result = new HashSet<Integer>();
        for (Id id : collection) {
            result.add(id.getId());
        }
        return result;
    }

    public static final String getSystemVariables() {
        StringBuilder result = new StringBuilder();
        Map<String, String> variables = System.getenv();
        for (Map.Entry<String, String> entry : variables.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            result.append(name);
            result.append("=");
            result.append(value);
            result.append("\n");
        }
        return result.toString();
    }

    public static final String getJavaProperties() {
        StringBuilder result = new StringBuilder();
        Properties properties = System.getProperties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String name = entry.getKey().toString();
            String value = entry.getValue().toString();
            result.append(name);
            result.append("=");
            result.append(value);
            result.append("\n");
        }
        return result.toString();
    }

    public static <I> I newInstance(String name, Class<? extends I> clazz) throws BGException {
        try {
            Class<?> iClass = Class.forName(name);
            return iClass.asSubclass(clazz).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
        catch (InvocationTargetException ex) {
            throw new BGException(ex);
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
    }

    public static byte[] getDigestBytes(byte[] value, String algorithm) {
        byte[] digestBytes = null;
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            digest.update(value);
            digestBytes = digest.digest();
        }
        catch (Exception ex) {
            BGLogger.error(ex);
        }
        return digestBytes;
    }

    public static byte[] getDigestBytes(byte[] value) {
        return Utils.getDigestBytes(value, "MD5");
    }

    public static String getDigest(String value, String encoding) {
        return Utils.getDigest(value, encoding, "MD5");
    }

    public static String getDigest(String value, String encoding, String algorithm) {
        return Utils.getDigest(value, encoding, algorithm, true);
    }

    public static String getDigest(String value, String encoding, String algorithm, boolean toUpperCase) {
        StringBuffer passwdDigest = new StringBuffer();
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            digest.update(encoding == null ? value.getBytes() : value.getBytes(encoding));
            passwdDigest.append(Utils.bytesToString(digest.digest(), toUpperCase, null));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return passwdDigest.length() == 0 ? null : passwdDigest.toString();
    }

    public static String swapWords(String str) {
        StringBuilder result = new StringBuilder(str);
        int size = result.length();
        for (int i = 0; i < size - 1; i += 2) {
            char oneChar = result.charAt(i);
            char twoChar = result.charAt(i + 1);
            result.setCharAt(i, twoChar);
            result.setCharAt(i + 1, oneChar);
        }
        return result.toString();
    }

    public static final int pageCount(int count, int onPage) {
        return count % onPage == 0 ? count / onPage : count / onPage + 1;
    }

    public static final String pairToString(List<String[]> param) {
        return Utils.pairToString(param, ",", "=");
    }

    public static final String pairHashToString(Map<String, String> param) {
        ArrayList<String[]> pairs = new ArrayList<String[]>(param.size());
        for (Map.Entry<String, String> me : param.entrySet()) {
            pairs.add(new String[]{me.getKey(), me.getValue()});
        }
        return Utils.pairToString(pairs, ",", "=");
    }

    public static final String pairToString(List<String[]> param, String pairsDelim, String pairDelim) {
        StringBuilder result = new StringBuilder();
        for (String[] me : param) {
            if (result.length() > 0) {
                result.append(pairsDelim);
            }
            result.append(me[0]);
            result.append(pairDelim);
            result.append(me[1]);
        }
        return result.toString();
    }

    public static final List<String[]> stringToPairs(String param) {
        return Utils.stringToPairs(param, ",;", "=");
    }

    public static final Map<String, String> stringToPairsHash(String param) {
        return Utils.listToMap(Utils.stringToPairs(param, ",;", "="));
    }

    public static final Map<String, String> linesToPairsHash(String lines) {
        return Utils.listToMap(Utils.stringToPairs(lines, "\n", "="));
    }

    public static final Map<String, String> listToMap(List<String[]> pairs) {
        HashMap<String, String> result = new HashMap<String, String>(pairs.size());
        for (String[] pair : pairs) {
            result.put(pair[0], pair[1]);
        }
        return result;
    }

    public static final List<String[]> stringToPairs(String param, String pairsDelim, String pairDelim) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        if (param != null && pairsDelim != null) {
            StringTokenizer st = new StringTokenizer(param, pairsDelim);
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                String[] key_value = token.split("\\s*" + pairDelim + "\\s*");
                if (key_value.length != 2) continue;
                result.add(key_value);
            }
        }
        return result;
    }

    public static byte[] readByBlock(InputStream input) throws IOException {
        BufferedInputStream bf = new BufferedInputStream(input);
        Vector<byte[]> blocks = new Vector<byte[]>(5, 5);
        Vector<Integer> blocksLength = new Vector<Integer>(5, 5);
        int BLOCK_LENGTH = 1024;
        int readByte = 0;
        int bytesTotal = 0;
        do {
            byte[] data;
            if ((readByte = bf.read(data = new byte[1024], 0, 1024)) <= 0) continue;
            bytesTotal += readByte;
            blocks.addElement(data);
            blocksLength.addElement(readByte);
        } while (readByte != -1);
        int joffset = 0;
        byte[] allData = new byte[bytesTotal];
        for (int i = 0; i < blocks.size(); ++i) {
            readByte = (Integer)blocksLength.elementAt(i);
            System.arraycopy(blocks.elementAt(i), 0, allData, joffset, readByte);
            joffset += readByte;
        }
        return allData;
    }

    public static boolean flush(InputStream inputStream, OutputStream outputStream) throws IOException {
        int len;
        boolean wasFlush = false;
        byte[] buf = new byte[1024];
        while ((len = inputStream.read(buf)) != -1) {
            outputStream.write(buf, 0, len);
            wasFlush = true;
        }
        return wasFlush;
    }

    public static void readFullBuffer(Reader reader, char[] buffer) throws IOException {
        int read;
        int off = 0;
        int len = buffer.length;
        do {
            if ((read = reader.read(buffer, off, len)) == -1) {
                throw new IOException("insufficient length of data (" + buffer.length + " bytes needed, " + off + " was read)");
            }
            off += read;
        } while ((len -= read) != 0);
    }

    public static void readFullBuffer(InputStream is, byte[] buffer) throws IOException {
        int read;
        int off = 0;
        int len = buffer.length;
        do {
            if ((read = is.read(buffer, off, len)) == -1) {
                throw new IOException("insufficient length of data (" + buffer.length + " bytes needed, " + off + " was read)");
            }
            off += read;
        } while ((len -= read) != 0);
    }

    public static String getMessage(Document doc) throws Exception {
        return XMLUtils.selectText(doc, "/data/text()", "");
    }

    public static final String multiLetter(String letter, int count) {
        StringBuilder result = new StringBuilder(count);
        for (int i = 0; i < count; ++i) {
            result.append(letter);
        }
        return result.toString();
    }

    public static String randomAlphanumeric(int count) {
        StringBuilder result = new StringBuilder();
        if (count > 0) {
            String sym = "qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM0987654321";
            Random random = new Random();
            for (int index = 0; index < count; ++index) {
                result.append("qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM0987654321".charAt(random.nextInt("qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM0987654321".length())));
            }
        }
        return result.toString();
    }

    @Deprecated
    public static final int BuToI(byte value) {
        return Utils.unsignedByteToInt(value);
    }

    @Deprecated
    public static long IuTol(int value) {
        return Utils.unsignedIntToLong(value);
    }

    @Deprecated
    public static final long IuToL(int value) {
        return Utils.unsignedIntToLong(value);
    }

    public static final int unsignedByteToInt(byte value) {
        int val = value;
        if (val < 0) {
            val &= 0xFF;
            val |= 0x80;
        }
        return val;
    }

    public static final long unsignedIntToLong(int value) {
        long val = value;
        if (val < 0L) {
            val &= 0xFFFFFFFFL;
            val |= 0x80000000L;
        }
        return val;
    }

    public static int convertBytesToInt(byte[] bytes) {
        int result = 0;
        if (bytes != null && bytes.length == 4) {
            result = 0xFF & bytes[3] | 0xFF00 & bytes[2] << 8 | 0xFF0000 & bytes[1] << 16 | 0xFF000000 & bytes[0] << 24;
        }
        return result;
    }

    public static int bytesToInt(byte[] bytes) {
        if (bytes == null) {
            return 0;
        }
        switch (bytes.length) {
            case 4: {
                return 0xFF & bytes[3] | 0xFF00 & bytes[2] << 8 | 0xFF0000 & bytes[1] << 16 | 0xFF000000 & bytes[0] << 24;
            }
            case 3: {
                return 0xFF & bytes[2] | 0xFF00 & bytes[1] << 8 | 0xFF0000 & bytes[0] << 16;
            }
            case 2: {
                return 0xFF & bytes[1] | 0xFF00 & bytes[0] << 8;
            }
            case 1: {
                return 0xFF & bytes[0];
            }
            case 0: {
                return 0;
            }
        }
        throw new IllegalArgumentException("bytes.length");
    }

    public static int bytesToInt(byte[] bytes, int pos, int length) {
        if (bytes == null) {
            return 0;
        }
        int maxLength = bytes.length - pos;
        if (length > maxLength) {
            length = maxLength;
        }
        switch (length) {
            case 4: {
                return 0xFF & bytes[pos + 3] | 0xFF00 & bytes[pos + 2] << 8 | 0xFF0000 & bytes[pos + 1] << 16 | 0xFF000000 & bytes[pos] << 24;
            }
            case 3: {
                return 0xFF & bytes[pos + 2] | 0xFF00 & bytes[pos + 1] << 8 | 0xFF0000 & bytes[pos] << 16;
            }
            case 2: {
                return 0xFF & bytes[pos + 1] | 0xFF00 & bytes[pos] << 8;
            }
            case 1: {
                return 0xFF & bytes[pos];
            }
            case 0: {
                return 0;
            }
        }
        throw new IllegalArgumentException("length");
    }

    public static long bytesToLong(byte[] bytes) {
        if (bytes == null) {
            return 0L;
        }
        switch (bytes.length) {
            case 8: {
                return (long)bytes[0] << 56 | ((long)bytes[1] & 0xFFL) << 48 | ((long)bytes[2] & 0xFFL) << 40 | ((long)bytes[3] & 0xFFL) << 32 | ((long)bytes[4] & 0xFFL) << 24 | ((long)bytes[5] & 0xFFL) << 16 | ((long)bytes[6] & 0xFFL) << 8 | (long)bytes[7] & 0xFFL;
            }
            case 7: {
                return ((long)bytes[0] & 0xFFL) << 48 | ((long)bytes[1] & 0xFFL) << 40 | ((long)bytes[2] & 0xFFL) << 32 | ((long)bytes[3] & 0xFFL) << 24 | ((long)bytes[4] & 0xFFL) << 16 | ((long)bytes[5] & 0xFFL) << 8 | (long)bytes[6] & 0xFFL;
            }
            case 6: {
                return ((long)bytes[0] & 0xFFL) << 40 | ((long)bytes[1] & 0xFFL) << 32 | ((long)bytes[2] & 0xFFL) << 24 | ((long)bytes[3] & 0xFFL) << 16 | ((long)bytes[4] & 0xFFL) << 8 | (long)bytes[5] & 0xFFL;
            }
            case 5: {
                return ((long)bytes[0] & 0xFFL) << 32 | ((long)bytes[1] & 0xFFL) << 24 | ((long)bytes[2] & 0xFFL) << 16 | ((long)bytes[3] & 0xFFL) << 8 | (long)bytes[4] & 0xFFL;
            }
            case 4: {
                return ((long)bytes[0] & 0xFFL) << 24 | ((long)bytes[1] & 0xFFL) << 16 | ((long)bytes[2] & 0xFFL) << 8 | (long)bytes[3] & 0xFFL;
            }
            case 3: {
                return ((long)bytes[0] & 0xFFL) << 16 | ((long)bytes[1] & 0xFFL) << 8 | (long)bytes[2] & 0xFFL;
            }
            case 2: {
                return ((long)bytes[0] & 0xFFL) << 8 | (long)bytes[1] & 0xFFL;
            }
            case 1: {
                return (long)bytes[0] & 0xFFL;
            }
            case 0: {
                return 0L;
            }
        }
        throw new IllegalArgumentException("bytes.length");
    }

    public static long bytesToLong(byte[] bytes, int pos, int length) {
        if (bytes == null) {
            return 0L;
        }
        switch (bytes.length) {
            case 8: {
                return (long)bytes[pos] << 56 | ((long)bytes[pos + 1] & 0xFFL) << 48 | ((long)bytes[pos + 2] & 0xFFL) << 40 | ((long)bytes[pos + 3] & 0xFFL) << 32 | ((long)bytes[pos + 4] & 0xFFL) << 24 | ((long)bytes[pos + 5] & 0xFFL) << 16 | ((long)bytes[pos + 6] & 0xFFL) << 8 | (long)bytes[pos + 7] & 0xFFL;
            }
            case 7: {
                return ((long)bytes[pos] & 0xFFL) << 48 | ((long)bytes[pos + 1] & 0xFFL) << 40 | ((long)bytes[pos + 2] & 0xFFL) << 32 | ((long)bytes[pos + 3] & 0xFFL) << 24 | ((long)bytes[pos + 4] & 0xFFL) << 16 | ((long)bytes[pos + 5] & 0xFFL) << 8 | (long)bytes[pos + 6] & 0xFFL;
            }
            case 6: {
                return ((long)bytes[pos] & 0xFFL) << 40 | ((long)bytes[pos + 1] & 0xFFL) << 32 | ((long)bytes[pos + 2] & 0xFFL) << 24 | ((long)bytes[pos + 3] & 0xFFL) << 16 | ((long)bytes[pos + 4] & 0xFFL) << 8 | (long)bytes[pos + 5] & 0xFFL;
            }
            case 5: {
                return ((long)bytes[pos] & 0xFFL) << 32 | ((long)bytes[pos + 1] & 0xFFL) << 24 | ((long)bytes[pos + 2] & 0xFFL) << 16 | ((long)bytes[pos + 3] & 0xFFL) << 8 | (long)bytes[pos + 4] & 0xFFL;
            }
            case 4: {
                return ((long)bytes[pos] & 0xFFL) << 24 | ((long)bytes[pos + 1] & 0xFFL) << 16 | ((long)bytes[pos + 2] & 0xFFL) << 8 | (long)bytes[pos + 3] & 0xFFL;
            }
            case 3: {
                return ((long)bytes[pos] & 0xFFL) << 16 | ((long)bytes[pos + 1] & 0xFFL) << 8 | (long)bytes[pos + 2] & 0xFFL;
            }
            case 2: {
                return ((long)bytes[pos] & 0xFFL) << 8 | (long)bytes[pos + 1] & 0xFFL;
            }
            case 1: {
                return (long)bytes[pos] & 0xFFL;
            }
            case 0: {
                return 0L;
            }
        }
        throw new IllegalArgumentException("length");
    }

    public static long convertBytesToLong(byte[] bytes) {
        long result = ((long)bytes[0] & 0xFFL) << 56 | ((long)bytes[1] & 0xFFL) << 48 | ((long)bytes[2] & 0xFFL) << 40 | ((long)bytes[3] & 0xFFL) << 32 | ((long)bytes[4] & 0xFFL) << 24 | ((long)bytes[5] & 0xFFL) << 16 | ((long)bytes[6] & 0xFFL) << 8 | ((long)bytes[7] & 0xFFL) << 0;
        return result;
    }

    public static byte[] convertIntToBytes(int value) {
        return Utils.convertToBytes(value, 4);
    }

    public static byte[] convertLongToBytes(long value) {
        return Utils.convertToBytes(value, 8);
    }

    private static byte[] convertToBytes(long value, int cnt) {
        byte[] byteValue = new byte[cnt];
        for (int i = 0; i < cnt; ++i) {
            byteValue[cnt - 1 - i] = (byte)(value & 0xFFL);
            value >>= 8;
        }
        return byteValue;
    }

    public static String formatLong(long value) {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setGroupingSeparator(' ');
        DecimalFormat decimalFormat = new DecimalFormat("###,###,###,##0", decimalFormatSymbols);
        decimalFormat.setGroupingUsed(true);
        return decimalFormat.format(value);
    }

    public static String formatBigDecimal(BigDecimal value, int scale) {
        return Utils.maskNull(value).setScale(scale, RoundingMode.HALF_UP).toString();
    }

    public static String formatBigDecimalSumm(BigDecimal value) {
        return Utils.maskNull(value).setScale(2, RoundingMode.HALF_UP).toString();
    }

    public static BigDecimal roundBigDecimalSumm(BigDecimal value) {
        return value.setScale(2, RoundingMode.HALF_UP);
    }

    public static final boolean checkMacAddres(String value) {
        boolean result = value != null && value.trim().length() == 17;
        StringTokenizer st = new StringTokenizer(value, "-: ");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            try {
                Integer.parseInt(token, 16);
            }
            catch (Exception e) {
                result = false;
                break;
            }
        }
        return result;
    }

    public static final byte[] removeZeroTail(byte[] data) {
        byte[] result = null;
        int pos = 0;
        int size = data.length;
        for (int i = 0; i < size; ++i) {
            if (data[i] != 0) continue;
            pos = i;
            break;
        }
        if (pos == 0) {
            result = data;
        } else {
            result = new byte[pos];
            System.arraycopy(data, 0, result, 0, pos);
        }
        return result;
    }

    public static final String booleanToStringInt(boolean value) {
        return value ? "1" : "0";
    }

    public static String formatPhoneNumber(String value) {
        StringBuilder buf;
        block7: {
            int i;
            buf = new StringBuilder();
            if (value == null || value.length() <= 0) break block7;
            for (i = 0; i < value.length(); ++i) {
                if (Character.isDigit(value.charAt(i))) continue;
                return value;
            }
            if (value.charAt(0) == '7' && value.length() == 11) {
                for (i = 0; i < value.length(); ++i) {
                    if (i == 1 || i == 4 || i == 7 || i == 9) {
                        buf.append('-');
                    }
                    buf.append(value.charAt(i));
                }
            } else {
                for (i = 0; i < value.length(); ++i) {
                    if ((i + value.length() % 2) % 2 == 0 && i > 0) {
                        buf.append('-');
                    }
                    buf.append(value.charAt(i));
                }
            }
        }
        return buf.toString().replace('\u0000', ' ');
    }

    public static boolean isArrayString(String string) {
        if (Utils.isEmptyString(string)) {
            return true;
        }
        Matcher matcher = isArrayStringPattern.matcher(string);
        return !matcher.find();
    }

    public static String deleteAfterDog(String value) {
        int pos;
        String result = value;
        if (value != null && (pos = value.indexOf("@")) > 0) {
            result = value.substring(0, pos);
        }
        return result;
    }

    public static String deleteBeforeSharp(String value) {
        int pos;
        String result = value;
        if (value != null && (pos = value.indexOf("#")) >= 0) {
            result = value.substring(pos + 1, value.length());
        }
        return result;
    }

    public static String formatSessionTime(int value) {
        StringBuilder buf = new StringBuilder();
        if (value / 3600 < 10) {
            buf.append('0');
        }
        buf.append(value / 3600);
        buf.append(':');
        if (value % 3600 / 60 < 10) {
            buf.append('0');
        }
        buf.append(value % 3600 / 60);
        buf.append(':');
        if (value % 60 < 10) {
            buf.append('0');
        }
        buf.append(value % 60);
        buf.append(" [").append(Utils.formatInteger(value)).append(']');
        return buf.toString();
    }

    public static String formatSessionTime2(int value) {
        StringBuilder buf = new StringBuilder();
        buf.append(Utils.formatInteger(value)).append(" [");
        if (value / 3600 < 10) {
            buf.append('0');
        }
        buf.append(value / 3600);
        buf.append(':');
        if (value % 3600 / 60 < 10) {
            buf.append('0');
        }
        buf.append(value % 3600 / 60);
        buf.append(':');
        if (value % 60 < 10) {
            buf.append('0');
        }
        buf.append(value % 60);
        buf.append(']');
        return buf.toString();
    }

    public static String formatInteger(int value) {
        StringBuilder buf = new StringBuilder();
        String valueStr = String.valueOf(value);
        int len = valueStr.length() - 1;
        int counter = 0;
        for (int index = len; index > -1; --index) {
            if (counter == 3) {
                buf.insert(0, ' ');
                counter = 0;
            }
            buf.insert(0, valueStr.charAt(index));
            ++counter;
        }
        return buf.toString();
    }

    public static String charsetConvert(String value, String encoding) {
        if (value != null) {
            try {
                value = new String(value.getBytes("ISO-8859-1"), encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return value;
    }

    public static String toTranslit(String text) {
        char[] charBuffer = text.toCharArray();
        StringBuilder sb = new StringBuilder(text.length());
        for (char symbol : charBuffer) {
            int i = symbol - 1025;
            if (i >= 0 && i < charTable.length) {
                String replace = charTable[i];
                sb.append(replace == null ? Character.valueOf(symbol) : replace);
                continue;
            }
            sb.append(symbol);
        }
        return sb.toString();
    }

    public static MessageDigest newMD4() throws NoSuchAlgorithmException {
        if (md4Provider == null) {
            return MessageDigest.getInstance("MD4");
        }
        return MessageDigest.getInstance("MD4", md4Provider);
    }

    public static byte[] getMD4Digest(byte[] input) throws NoSuchAlgorithmException {
        MessageDigest md4 = Utils.newMD4();
        byte[] output = md4.digest(input);
        return output;
    }

    public static boolean checkEmail(String email) {
        boolean result = true;
        try {
            new InternetAddress(email);
        }
        catch (Exception ex) {
            result = false;
        }
        return result;
    }

    public static <E extends Enum<E>> E getListItemEnumFromId(Class<E> enumm, int id, E def) {
        for (Enum op : (Enum[])enumm.getEnumConstants()) {
            if (((ListItem)((Object)op)).getId() != id) continue;
            return (E)op;
        }
        return def;
    }

    public static <E extends Enum<E>> E getListItemEnumFromId(Class<E> enumm, int id) {
        return Utils.getListItemEnumFromId(enumm, id, null);
    }

    public static String unpackValues(long value, int base) {
        StringBuffer sb = new StringBuffer("*");
        if (value > 0L) {
            sb.delete(0, 1);
            int len = 0;
            int p = 0;
            for (long i = 1L; i <= value; i *= 2L) {
                boolean b;
                boolean bl = b = (value & i) > 0L;
                if (b && len == 0) {
                    sb.append(sb.length() == 0 ? "" + (p + base) : "," + (p + base));
                    ++len;
                } else if (b && len > 0) {
                    ++len;
                } else if (!b && len > 1) {
                    sb.append("-" + (p - 1 + base));
                    len = 0;
                } else {
                    len = 0;
                }
                ++p;
            }
            if (len > 1) {
                sb.append("-" + (p - 1 + base));
            }
        }
        return sb.toString();
    }

    public static long packValues(Collection<String> values, int base) {
        long value = 0L;
        if (values != null) {
            for (String token : values) {
                try {
                    int p = token.indexOf("-");
                    if (p != -1) {
                        int v1 = Integer.parseInt(token.substring(0, p));
                        int v2 = Integer.parseInt(token.substring(p + 1));
                        if (v1 < 0 || v2 < 0 || v1 > v2) continue;
                        for (int j = v1; j <= v2; ++j) {
                            value += 1L << j - base;
                        }
                        continue;
                    }
                    value += 1L << Integer.parseInt(token) - base;
                }
                catch (Exception exception) {}
            }
        }
        return value;
    }

    public static final Object convert(Object o, Class<?> clazz) {
        if (o instanceof Number) {
            return Utils.convert((Number)o, clazz);
        }
        if (o instanceof String || o == null) {
            return Utils.convert((String)o, clazz);
        }
        throw new IllegalArgumentException();
    }

    public static final Object convert(Number number, Class<?> clazz) {
        if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            return number.intValue();
        }
        if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
            return number.longValue();
        }
        if (clazz.equals(Float.class) || clazz.equals(Float.TYPE)) {
            return Float.valueOf(number.floatValue());
        }
        if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
            return number.doubleValue();
        }
        return 0;
    }

    public static final Object convert(String text, Class<?> clazz) {
        if (clazz.equals(String.class)) {
            return text;
        }
        if (clazz.equals(BigDecimal.class)) {
            return Utils.parseBigDecimal(text, BigDecimal.ZERO);
        }
        if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            return Utils.parseInt(text, 0);
        }
        if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
            return Utils.parseLong(text, 0L);
        }
        if (clazz.equals(Float.class) || clazz.equals(Float.TYPE)) {
            return Float.valueOf(Utils.parseFloat(text, 0.0f));
        }
        if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
            return Utils.parseDouble(text, 0.0);
        }
        if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
            return Utils.parseBoolean(text, false);
        }
        if (clazz.equals(Date.class)) {
            Date date = null;
            SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");
            if (text != null && format != null) {
                try {
                    date = format.parse(text);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return date;
        }
        return null;
    }

    public static String checkPath(String rawPath) {
        if (rawPath != null && !((String)(rawPath = ((String)rawPath).replace('\\', '/'))).endsWith("/")) {
            rawPath = (String)rawPath + "/";
        }
        return rawPath;
    }

    public static String escapeHTML(String s) {
        int length;
        int newLength = length = s.length();
        boolean someCharacterEscaped = false;
        block18: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            int cint = 0xFFFF & c;
            if (cint < 32) {
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': {
                        break;
                    }
                    default: {
                        --newLength;
                        someCharacterEscaped = true;
                        break;
                    }
                }
                continue;
            }
            switch (c) {
                case '\"': {
                    newLength += 5;
                    someCharacterEscaped = true;
                    continue block18;
                }
                case '&': 
                case '\'': {
                    newLength += 4;
                    someCharacterEscaped = true;
                    continue block18;
                }
                case '<': 
                case '>': {
                    newLength += 3;
                    someCharacterEscaped = true;
                }
            }
        }
        if (!someCharacterEscaped) {
            return s;
        }
        StringBuffer sb = new StringBuffer(newLength);
        block19: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            int cint = 0xFFFF & c;
            if (cint < 32) {
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': {
                        sb.append(c);
                        break;
                    }
                }
                continue;
            }
            switch (c) {
                case '\"': {
                    sb.append("&quot;");
                    continue block19;
                }
                case '\'': {
                    sb.append("&#39;");
                    continue block19;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block19;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block19;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block19;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static void checkJava() throws BGException {
        String vmname;
        Object warnings = "";
        String specver = System.getProperty("java.specification.version");
        if (!SPEC_VERSIONS.get(CODE_VERSION).contains(specver)) {
            warnings = (String)warnings + "\u0421\u043f\u0435\u0446\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u044f " + specver + " \u043d\u0435 \u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u0442\u0441\u044f (\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f " + Utils.toString((Iterable)SPEC_VERSIONS.get(CODE_VERSION)) + ")\n";
        }
        if (!(vmname = System.getProperty("java.vm.name")).startsWith("Java HotSpot") && !vmname.startsWith("OpenJDK")) {
            warnings = (String)warnings + "\u0412\u0438\u0440\u0442\u0443\u0430\u043b\u044c\u043d\u0430\u044f \u043c\u0430\u0448\u0438\u043d\u0430 " + vmname + " \u043d\u0435 \u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u0442\u0441\u044f\n";
        }
        SimpleDateFormat df = new SimpleDateFormat("HZ");
        df.setTimeZone(TimeZone.getTimeZone("Asia/Yekaterinburg"));
        if (!(df.format(new Date(1314567890000L)).equals("3+0600") && df.format(new Date(1324567890000L)).equals("21+0600") && df.format(new Date(1412888888666L)).equals("3+0600") && df.format(new Date(1414888888666L)).equals("5+0500"))) {
            warnings = (String)warnings + "\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0441\u0440\u043e\u0447\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0442\u0430\u0439\u043c\u0437\u043e\u043d\u044b\n";
        }
        if (List.of("Asia/Almaty", "Asia/Qyzylorda", "Asia/Qostanay", "Asia/Aqtobe", "Asia/Aqtau", "Asia/Atyrau", "Asia/Oral").contains(TimeZone.getDefault().getID())) {
            df.setTimeZone(TimeZone.getTimeZone("Asia/Almaty"));
            if (!df.format(new Date(1706727600000L)).equals("1+0600") || !df.format(new Date(1711911600000L)).equals("0+0500")) {
                warnings = (String)warnings + "\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0441\u0440\u043e\u0447\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0442\u0430\u0439\u043c\u0437\u043e\u043d\u044b (\u041a\u0430\u0437\u0430\u0445\u0441\u0442\u0430\u043d)\n";
            }
        }
        if (!((String)warnings).isEmpty()) {
            throw new BGException((String)warnings);
        }
    }

    public static String getOsJavaVersion(boolean full) {
        StringBuilder sb = new StringBuilder(50);
        if (!full) {
            sb.append("os: " + System.getProperty("os.name") + "; java: " + System.getProperty("java.vm.name") + ", v." + System.getProperty("java.version"));
        } else {
            sb.append("os: " + System.getProperty("os.name") + " " + System.getProperty("os.arch") + ", " + System.getProperty("os.version") + "\n");
            sb.append("java: " + System.getProperty("java.vm.name") + ", v." + System.getProperty("java.version") + "\n");
            sb.append("jre home: " + System.getProperty("java.home"));
        }
        return sb.toString();
    }

    public static String guid() {
        return GUID_PREFIX + guidGenerator.decrementAndGet();
    }

    public static <T extends Enum<T>> T parseEnum(Class<T> enumType, String name, T defaultValue) {
        try {
            if (name == null || name.length() == 0) {
                return defaultValue;
            }
            return Enum.valueOf(enumType, name.trim());
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public static DecimalFormat getDecimalFormatSumma() {
        return new DecimalFormat("###,###,###,##0.00");
    }

    public static String checkCanReadFiles(File[] files) {
        StringBuilder message = new StringBuilder();
        for (File file : files) {
            if (file.canRead()) continue;
            if (message.length() > 0) {
                message.append("\n");
            }
            message.append(Utils.getFormatFileName(file, 80));
        }
        return message.length() > 0 ? message.toString() : null;
    }

    public static String getNamesFiles(File[] files) {
        StringBuilder message = new StringBuilder();
        for (File file : files) {
            if (message.length() > 0) {
                message.append("\n");
            }
            message.append(Utils.getFormatFileName(file, 80)).append(" [").append(file.length() / 1024L).append("\u043a\u0431]");
        }
        return message.toString();
    }

    public static String maskEmail(String email) {
        String[] splits1;
        StringBuilder result = new StringBuilder();
        for (String split1 : splits1 = email.split("@")) {
            if (result.length() > 0) {
                result.append('@');
            }
            for (String split2 : split1.split("\\.")) {
                if (result.length() > 0 && !result.toString().endsWith("@")) {
                    result.append('.');
                }
                StringBuilder partResult = new StringBuilder();
                if (split2 != null) {
                    if (split2.length() > 2) {
                        partResult.append(split2.charAt(0));
                        for (int index = 1; index < split2.length() - 1; ++index) {
                            partResult.append('*');
                        }
                        partResult.append(split2.charAt(split2.length() - 1));
                    } else {
                        partResult.append(split2);
                    }
                }
                result.append(partResult.toString());
            }
        }
        return result.toString();
    }

    public static String maskPhoneNumber(String phone, int showDigitBegin, int showDigitEnd) {
        StringBuilder result = new StringBuilder();
        if (phone != null) {
            int counter = 0;
            for (int index = 0; index < phone.length(); ++index) {
                if (!Character.isDigit(phone.charAt(index))) continue;
                ++counter;
            }
            int hiddenDigit = counter - showDigitBegin - showDigitEnd;
            if (hiddenDigit < 0) {
                hiddenDigit = 0;
            }
            for (int index = 0; index < phone.length(); ++index) {
                int ch = phone.charAt(index);
                if (Character.isDigit((char)ch)) {
                    if (showDigitBegin > 0) {
                        --showDigitBegin;
                    } else if (hiddenDigit > 0) {
                        ch = 42;
                        --hiddenDigit;
                    }
                }
                result.append((char)ch);
            }
        }
        return result.toString();
    }

    public static String maskConfidential(String msg2Mask) {
        String result = null;
        if (Utils.notBlankString(msg2Mask)) {
            for (int i = 0; i < msg2Mask.length(); ++i) {
                result = result + "*";
            }
        }
        return result;
    }

    private static String getFormatFileName(File file, int maxlen) {
        String fileName = file.toString();
        if (fileName.length() > maxlen) {
            return fileName.substring(0, maxlen / 2 - 2) + "..." + fileName.substring(fileName.length() - maxlen / 2 - 2);
        }
        return fileName;
    }

    public static List<Integer> getIdList(Collection<? extends Id> items) {
        return items.stream().map(item -> item.getId()).collect(Collectors.toList());
    }

    public static String htmlEncode(String inValue, String ENCODING) {
        try {
            return URLEncoder.encode(inValue, ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static final String insertBOM() {
        return "\ufeff";
    }

    public static <V> List<V> concat(List<V> a, List<V> b) {
        if (a == null || a.size() == 0) {
            if (b == null || b.size() == 0) {
                return new ArrayList();
            }
            return new ArrayList<V>(b);
        }
        if (b == null || b.size() == 0) {
            return new ArrayList<V>(a);
        }
        ArrayList<V> result = new ArrayList<V>(a.size() + b.size());
        result.addAll(a);
        result.addAll(b);
        return result;
    }

    public static <V> Iterable<V> iterable(final Collection<V> a, final Collection<V> b) {
        if (a == null || a.size() == 0) {
            if (b == null || b.size() == 0) {
                return Collections.emptyList();
            }
            return b;
        }
        if (b == null || b.size() == 0) {
            return a;
        }
        return new Iterable<V>(){

            @Override
            public Iterator<V> iterator() {
                return Stream.concat(a.stream(), b.stream()).iterator();
            }
        };
    }

    public static List<Class<?>> getClassList(String packageName) {
        URL url = Utils.class.getResource("/" + packageName.replace(".", "/"));
        if (url != null) {
            try {
                URI uri = url.toURI();
                if ("jar".equals(uri.getScheme())) {
                    FileSystem fs = null;
                    try {
                        fs = FileSystems.getFileSystem(uri);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (fs == null) {
                        fs = FileSystems.newFileSystem(uri, Collections.emptyMap());
                    }
                    return Utils.getClassList2(packageName, fs.getPath("/" + packageName.replace(".", "/"), new String[0]));
                }
                if ("file".equals(uri.getScheme())) {
                    return Utils.getClassList2(packageName, Paths.get(uri));
                }
            }
            catch (Exception ex) {
                BGLogger.error(ex);
            }
        }
        return Collections.emptyList();
    }

    private static List<Class<?>> getClassList2(String packageName, Path dirPath) throws IOException {
        ArrayList clazzs = new ArrayList();
        Files.list(dirPath).forEach(path -> {
            String fileName = path.getFileName().toString();
            if (fileName.endsWith(".class")) {
                String className = packageName + "." + fileName.substring(0, fileName.length() - 6);
                try {
                    clazzs.add(Class.forName(className));
                }
                catch (ClassNotFoundException ex) {
                    BGLogger.error(ex);
                }
            }
        });
        return clazzs;
    }

    public static List<Integer> toIntegerList(JSONArray jsonArray) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (jsonArray != null && !jsonArray.isEmpty()) {
            int len = jsonArray.length();
            for (int index = 0; index < len; ++index) {
                list.add(jsonArray.optInt(index));
            }
        }
        return list;
    }

    public static JSONArray toJsonArray(List<Integer> ids) {
        JSONArray array = new JSONArray();
        if (ids != null && !ids.isEmpty()) {
            ids.forEach(a -> array.put(a));
        }
        return array;
    }

    public static boolean testBit(byte b, int n) {
        return (b & 1 << n) != 0;
    }

    public static boolean testBit(int b, int n) {
        return (b & 1 << n) != 0;
    }

    public static byte makeByte(int bit7, int bit6, int bit5, int bit4, int bit3, int bit2, int bit1, int bit0) {
        return (byte)(128 * bit7 + 64 * bit6 + 32 * bit5 + 16 * bit4 + 8 * bit3 + 4 * bit2 + 2 * bit1 + bit0);
    }

    public static boolean isNY() {
        long T_IN_DAY;
        long TOf\u0421urrYear = System.currentTimeMillis() % 31557600000L;
        return TOf\u0421urrYear > (T_IN_DAY = 86400000L) * 353L || TOf\u0421urrYear < T_IN_DAY * 7L;
    }

    public static String normalizePhone(String phone) {
        if (Utils.isBlankString(phone)) {
            return null;
        }
        String result = phone.replaceAll("\\D", "");
        if (result.length() == 11 && result.startsWith("8")) {
            result = result.replaceFirst("8", "7");
        }
        if (result.length() < 10 || result.length() > 15) {
            return null;
        }
        return result;
    }

    public static String normalizeEmail(String email) {
        if (Utils.isBlankString(email) || !email.contains("@")) {
            return null;
        }
        boolean changed = false;
        int index = email.indexOf("<");
        if (index != -1) {
            email = email.substring(index + 1);
            changed = true;
        }
        if ((index = email.indexOf(">")) != -1) {
            email = email.substring(0, index);
            changed = true;
        }
        if (changed && (Utils.isBlankString(email) || !email.contains("@"))) {
            return null;
        }
        return email.strip();
    }

    public static boolean endsWithIgnoreCase(String str, String suffix) {
        return str.toLowerCase().endsWith(suffix.toLowerCase());
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        return str.toLowerCase().startsWith(prefix.toLowerCase());
    }

    public static String updateConfigParam(String config, String name, String value, String defaultValue) {
        List<Object> lines;
        Objects.requireNonNull(config);
        Objects.requireNonNull(name);
        List<Object> list = lines = config.isEmpty() ? new ArrayList() : Arrays.asList(config.split("\n"));
        if (value == null || value.isEmpty() || value.equals(defaultValue)) {
            config = lines.stream().filter(a -> !a.startsWith(name + "=")).collect(Collectors.joining("\n"));
        } else {
            boolean update = false;
            ArrayList<Object> result = new ArrayList<Object>();
            for (String string : lines) {
                if (string.startsWith(name + "=")) {
                    result.add(name + "=" + value);
                    update = true;
                    continue;
                }
                result.add(string);
            }
            if (!update) {
                result.add(name + "=" + value);
            }
            config = result.stream().collect(Collectors.joining("\n"));
        }
        return config;
    }

    public static UUID randomUUIDv7() {
        byte[] value = Utils.randomBytes();
        ByteBuffer buf = ByteBuffer.wrap(value);
        long high = buf.getLong();
        long low = buf.getLong();
        return new UUID(high, low);
    }

    private static byte[] randomBytes() {
        byte[] value = new byte[16];
        random.nextBytes(value);
        ByteBuffer timestamp = ByteBuffer.allocate(8);
        timestamp.putLong(System.currentTimeMillis());
        System.arraycopy(timestamp.array(), 2, value, 0, 6);
        value[6] = (byte)(value[6] & 0xF | 0x70);
        value[8] = (byte)(value[8] & 0x3F | 0x80);
        return value;
    }

    public static UUID UUID_fromBytes(byte[] bytes) {
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        long high = bb.getLong();
        long low = bb.getLong();
        return new UUID(high, low);
    }

    public static byte[] UUID_asBytes(UUID uuid) {
        ByteBuffer bb = ByteBuffer.allocate(16);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return bb.array();
    }

    public static String normalizeFileName(String fileName) {
        if (fileName == null) {
            return null;
        }
        fileName = fileName.replaceAll("[\\<\\>\\:\\\"\\/\\?\\\\\\*\\|]+", "_");
        fileName = fileName.replaceAll("[\r\n\t]+", "_");
        return fileName;
    }

    public static void main(String[] args) {
        System.out.println("[\\<\\>\\:\\\"\\/\\?\\\\\\*\\|]*");
        System.out.println(Utils.normalizeFileName("erfewr<erewre>ere\tw\rr\new|rewrewrewr*wrewrew?erewrew/erewrewr\\rewrw"));
    }

    static {
        Provider provider = null;
        try {
            MessageDigest.getInstance("MD4");
        }
        catch (NoSuchAlgorithmException e) {
            provider = new Provider("MD4Provider", "1.0", "MD4 MessageDigest"){};
            provider.put("MessageDigest.MD4", "sun.security.provider.MD4");
        }
        md4Provider = provider;
        isArrayStringPattern = Pattern.compile("[a-zA-Z;]+");
        charTable = new String[81];
        Utils.charTable[15] = "A";
        Utils.charTable[16] = "B";
        Utils.charTable[17] = "V";
        Utils.charTable[18] = "G";
        Utils.charTable[19] = "D";
        Utils.charTable[20] = "E";
        Utils.charTable[0] = "E";
        Utils.charTable[21] = "ZH";
        Utils.charTable[22] = "Z";
        Utils.charTable[23] = "I";
        Utils.charTable[24] = "I";
        Utils.charTable[25] = "K";
        Utils.charTable[26] = "L";
        Utils.charTable[27] = "M";
        Utils.charTable[28] = "N";
        Utils.charTable[29] = "O";
        Utils.charTable[30] = "P";
        Utils.charTable[31] = "R";
        Utils.charTable[32] = "S";
        Utils.charTable[33] = "T";
        Utils.charTable[34] = "U";
        Utils.charTable[35] = "F";
        Utils.charTable[36] = "H";
        Utils.charTable[37] = "C";
        Utils.charTable[38] = "CH";
        Utils.charTable[39] = "SH";
        Utils.charTable[40] = "SH";
        Utils.charTable[41] = "'";
        Utils.charTable[42] = "Y";
        Utils.charTable[43] = "'";
        Utils.charTable[44] = "E";
        Utils.charTable[45] = "U";
        Utils.charTable[46] = "YA";
        for (int i = 0; i < charTable.length; ++i) {
            char idx = (char)((char)i + 1025);
            char lower = new String(new char[]{idx}).toLowerCase().charAt(0);
            if (charTable[i] == null) continue;
            Utils.charTable[lower - 1025] = charTable[i].toLowerCase();
        }
        SPEC_VERSIONS = new HashMap<String, Set<String>>(){
            {
                this.put(Utils.CODE_VERSION, new HashSet<String>(){
                    {
                        this.add("17");
                    }
                });
            }
        };
    }
}

