/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.server.datalog;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.base.server.datalog.BGDataLog;
import ru.bitel.bgbilling.kernel.base.server.datalog.DataLogReader;

public class BGDataLogReader<D extends BGDataLog<D>>
extends DataLogReader<D> {
    private static final Logger log = LogManager.getLogger();
    protected final int chunkSize;
    protected int currentChunkId;

    protected BGDataLogReader(D dataLog) {
        super(dataLog, null);
        this.chunkSize = ((BGDataLog)dataLog).chunkSize;
    }

    @Override
    protected ByteBuffer createBuffer(D dataLog, ByteBuffer readBuffer) {
        ByteBuffer buffer;
        if (((BGDataLog)dataLog).compressed) {
            buffer = ByteBuffer.allocate(((BGDataLog)dataLog).readBufferSize);
        } else {
            log.info("Create direct buffer with size=" + ((BGDataLog)dataLog).readBufferSize);
            buffer = ByteBuffer.allocateDirect(((BGDataLog)dataLog).readBufferSize);
        }
        return buffer;
    }

    @Override
    protected int readBuffer(ByteBuffer byteBuffer) throws IOException {
        if (this.chunkSize == 0) {
            log.debug("Read buffer...");
            return super.readBuffer(byteBuffer);
        }
        log.debug("Read buffer (chunked)...");
        int result = super.readBuffer(byteBuffer);
        if (result > 0) {
            int size = byteBuffer.getInt();
            this.currentChunkId = byteBuffer.getInt();
            byteBuffer.getInt();
            byteBuffer.getInt();
            if (result < size + 16) {
                log.error("Size of chunk less than expected: " + (result - 16) + " (" + size + ")");
                size = result - 16;
            }
            byteBuffer.limit(byteBuffer.position() + size);
        }
        return result;
    }

    protected boolean readNext() {
        if (!this.readBuffer.hasRemaining()) {
            try {
                int n = this.readBuffer(this.readBuffer);
                if (n == -1) {
                    return false;
                }
                if (n == 0) {
                    throw new RuntimeException("" + this.readBuffer.remaining());
                }
            }
            catch (Exception e) {
                log.error(e.getMessage() + " " + this.toString(), (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public boolean find(int chunkId, int position) {
        while (this.readNext()) {
            if (this.currentChunkId == chunkId) {
                this.readBuffer.position(position);
                return true;
            }
            this.readBuffer.position(this.readBuffer.limit());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        BGDataLog bGDataLog = (BGDataLog)this.dataLog;
        synchronized (bGDataLog) {
            return this.getClass().getSimpleName() + " [file: " + ((BGDataLog)this.dataLog).file.getAbsolutePath() + "; chunkSize=" + this.chunkSize + "]";
        }
    }

    public void moveToEnd() {
        ((BGDataLog)this.dataLog).readerReachEOS(this);
    }
}

