/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.reports;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xy.XYDataset;

public class Charts {
    protected static final Color TRANSPARENT_PAINT = new Color(0, 0, 0, 0);
    protected static Color[] DEFAULT_PAINT_SEQUENCE = new Color[]{new Color(191, 72, 0), new Color(97, 138, 185), new Color(0, 92, 186), new Color(189, 142, 0)};
    protected static Stroke[] DEFAULT_STROKE_SEQUENCE = new Stroke[]{new BasicStroke(1.0f, 2, 2)};

    public static DrawingSupplier getDrawingSupplier(Color[] colorSequence, Stroke[] strokeSequence) {
        if (colorSequence == null) {
            colorSequence = new Color[]{new Color(97, 138, 185), new Color(191, 72, 0), new Color(16, 150, 24), new Color(255, 153, 0), new Color(153, 0, 153), new Color(0, 153, 198), new Color(127, 0, 0), new Color(236, 25, 122)};
        }
        if (strokeSequence == null) {
            strokeSequence = DEFAULT_STROKE_SEQUENCE;
        }
        return new DefaultDrawingSupplier((Paint[])colorSequence, DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE, strokeSequence, DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE);
    }

    public static JFreeChart createChart(XYPlot plot, XYItemRenderer renderer, DrawingSupplier drawingSupplier) {
        plot.setRenderer(renderer);
        if (drawingSupplier == null) {
            drawingSupplier = Charts.getDrawingSupplier(null, null);
        }
        plot.setDrawingSupplier(drawingSupplier);
        JFreeChart chart = new JFreeChart((Plot)plot);
        chart.setBackgroundPaint((Paint)new Color(0, 0, 0, 0));
        plot.setOutlinePaint((Paint)new Color(0, 0, 0, 0));
        plot.setBackgroundPaint((Paint)new Color(0, 0, 0, 0));
        chart.getLegend().setItemFont(chart.getLegend().getItemFont().deriveFont(10.0f));
        int size = plot.getSeriesCount();
        for (int i = 0; i < size; ++i) {
        }
        plot.setRangeCrosshairPaint((Paint)new Color(0, 0, 0));
        plot.getDomainAxis().setTickLabelFont(plot.getDomainAxis().getTickLabelFont().deriveFont(9.0f));
        plot.getDomainAxis().setAxisLinePaint((Paint)new Color(0, 0, 0));
        plot.getRangeAxis().setTickLabelFont(plot.getDomainAxis().getTickLabelFont().deriveFont(9.0f));
        plot.getRangeAxis().setAxisLinePaint((Paint)new Color(0, 0, 0));
        return chart;
    }

    public static JFreeChart createTimeSeriesChart(XYItemRenderer renderer, XYDataset dataset) {
        return Charts.createTimeSeriesChart(renderer, dataset, null);
    }

    public static JFreeChart createTimeSeriesChart(XYItemRenderer renderer, XYDataset dataset, DrawingSupplier drawingSupplier) {
        DateAxis timeAxis = new DateAxis();
        timeAxis.setLowerMargin(0.02);
        timeAxis.setUpperMargin(0.02);
        NumberAxis valueAxis = new NumberAxis();
        valueAxis.setAutoRangeIncludesZero(false);
        XYPlot plot = new XYPlot(dataset, (ValueAxis)timeAxis, (ValueAxis)valueAxis, null);
        return Charts.createChart(plot, renderer, drawingSupplier);
    }

    public static JFreeChart createPieChart(DefaultPieDataset dataset, DrawingSupplier drawingSupplier) {
        JFreeChart chart = ChartFactory.createPieChart(null, (PieDataset)dataset, (boolean)true, (boolean)true, (boolean)false);
        PiePlot plot = (PiePlot)chart.getPlot();
        plot.setLabelFont(new Font("SansSerif", 0, 9));
        plot.setNoDataMessage("\u041d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445");
        plot.setCircular(false);
        plot.setLabelGap(0.02);
        chart.setBackgroundPaint((Paint)new Color(0, 0, 0, 0));
        plot.setOutlinePaint((Paint)new Color(0, 0, 0, 0));
        plot.setBackgroundPaint((Paint)new Color(0, 0, 0, 0));
        if (drawingSupplier == null) {
            drawingSupplier = Charts.getDrawingSupplier(null, null);
        }
        plot.setDrawingSupplier(drawingSupplier);
        plot.setShadowPaint(null);
        plot.setIgnoreNullValues(true);
        plot.setIgnoreZeroValues(true);
        chart.getLegend().setItemFont(chart.getLegend().getItemFont().deriveFont(10.0f));
        return chart;
    }
}

