/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.directory.api.client;

import java.lang.constant.Constable;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.ws.common.WSLinkedClient;
import ru.bitel.bgbilling.kernel.directory.api.client.ClientDirectoryService;
import ru.bitel.bgbilling.kernel.directory.api.common.CachedDirectory;
import ru.bitel.bgbilling.kernel.directory.api.common.DirectoryItem;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.directory.api.common.service.DirectoryService;
import ru.bitel.common.model.Id;

class ClientDirectoryInfo<K extends Id> {
    private static final ConcurrentMap<Class<?>, ClientDirectoryInfo<?>> DIRECTORY_INFO_MAP = new ConcurrentHashMap();
    final Class<K> clazz;
    final Class<?> serviceClass;
    private final Method methodGet;
    private final Method methodGetByTitle;
    private final Method methodList;
    private final Object[] methodListArgs;
    private final Method methodUpdate;
    private final Method methodDelete;
    private static final Object[] nilArgs = new Object[0];
    private final ConcurrentMap<Integer, SoftReference<? extends CachedDirectory<?>>> cache = new ConcurrentHashMap();

    public static <K extends Id> ClientDirectoryInfo<K> getInstance(Class<K> clazz) throws BGException {
        ClientDirectoryInfo<K> newResult;
        ClientDirectoryInfo<K> result = (ClientDirectoryInfo<K>)DIRECTORY_INFO_MAP.get(clazz);
        if (result == null && (result = DIRECTORY_INFO_MAP.putIfAbsent(clazz, newResult = new ClientDirectoryInfo<K>(clazz))) == null) {
            result = newResult;
        }
        return result;
    }

    private ClientDirectoryInfo(Class<K> clazz) throws BGException {
        this.clazz = clazz;
        DirectoryItem directoryItem = clazz.getAnnotation(DirectoryItem.class);
        if (directoryItem == null) {
            throw new IllegalArgumentException("Annotation DirectoryItem not found in bean!");
        }
        this.serviceClass = directoryItem.serviceClass();
        if (this.serviceClass == Object.class) {
            throw new IllegalArgumentException("Service class is undefined!");
        }
        String deletePrefix = directoryItem.deletePrefix();
        Object bean = clazz.getSimpleName();
        bean = ((String)bean).substring(deletePrefix.length());
        bean = ((String)bean).substring(0, 1).toLowerCase() + ((String)bean).substring(1);
        Method methodGet = null;
        Method methodGetByTitle = null;
        Method methodList = null;
        Object[] methodListArgs = nilArgs;
        Method methodUpdate = null;
        Method methodDelete = null;
        try {
            methodGet = this.serviceClass.getMethod((String)bean + "Get", Integer.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        try {
            methodGetByTitle = this.serviceClass.getMethod((String)bean + "Get", String.class);
        }
        catch (NoSuchMethodException ex) {
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        try {
            block24: {
                String methodName = (String)bean + "List";
                try {
                    methodList = this.serviceClass.getMethod(methodName, new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    for (Method m : this.serviceClass.getMethods()) {
                        if (!methodName.equals(m.getName())) continue;
                        methodList = m;
                    }
                    if (methodList == null) {
                        for (Method m : this.serviceClass.getSuperclass().getMethods()) {
                            if (!methodName.equals(m.getName())) continue;
                            methodList = m;
                        }
                    }
                    if (methodList != null) break block24;
                    throw e;
                }
            }
            Class<?>[] parameterTypes = methodList.getParameterTypes();
            if (parameterTypes.length > 0) {
                methodListArgs = new Object[parameterTypes.length];
                for (int i = 0; i < parameterTypes.length; ++i) {
                    Class<?> parameterType = parameterTypes[i];
                    methodListArgs[i] = Integer.TYPE.equals(parameterType) ? Integer.valueOf(0) : (Long.TYPE.equals(parameterType) ? Long.valueOf(0L) : (Float.TYPE.equals(parameterType) ? Float.valueOf(0.0f) : (Double.TYPE.equals(parameterType) ? (Constable)Double.valueOf(0.0) : (Constable)(Boolean.TYPE.equals(parameterType) ? Boolean.valueOf(false) : null))));
                }
            }
        }
        catch (NoSuchMethodException methodName) {
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        try {
            methodUpdate = this.serviceClass.getMethod((String)bean + "Update", clazz);
        }
        catch (NoSuchMethodException ex) {
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        try {
            methodDelete = this.serviceClass.getMethod((String)bean + "Delete", Integer.TYPE);
        }
        catch (NoSuchMethodException ex) {
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        this.methodGet = methodGet;
        this.methodGetByTitle = methodGetByTitle;
        this.methodList = methodList;
        this.methodListArgs = methodListArgs;
        this.methodUpdate = methodUpdate;
        this.methodDelete = methodDelete;
    }

    public void clearCache(int moduleId) {
        this.cache.remove(moduleId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedDirectory<K> getCache(WSLinkedClient context, Integer moduleId) throws Exception {
        long version = context.getPort(DirectoryService.class, 0).getVersion(this.clazz, moduleId);
        ClientDirectoryInfo clientDirectoryInfo = this;
        synchronized (clientDirectoryInfo) {
            CachedDirectory cache;
            SoftReference cacheRef = (SoftReference)this.cache.get(moduleId);
            CachedDirectory cachedDirectory = cache = cacheRef != null ? (CachedDirectory)cacheRef.get() : null;
            if (cache == null || cache.getVersion() != version) {
                cache = new CachedDirectory(new AtomicLong(version));
                this.cache.put(moduleId, new SoftReference(cache));
            }
            return cache;
        }
    }

    public long getCacheVersion(int moduleId) {
        CachedDirectory cache;
        SoftReference cacheRef = (SoftReference)this.cache.get(moduleId);
        CachedDirectory cachedDirectory = cache = cacheRef != null ? (CachedDirectory)cacheRef.get() : null;
        if (cache == null) {
            return 0L;
        }
        return cache.getVersion();
    }

    public Directory<K> newService(WSLinkedClient context, int moduleId) {
        Object port = context.getPort(this.serviceClass, moduleId);
        return new ClientDirectoryService(port, this.methodGet, this.methodGetByTitle, this.methodList, this.methodListArgs, this.methodUpdate, this.methodDelete);
    }
}

