/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common;

import bitel.billing.module.common.BGDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Calendar;
import javax.swing.KeyStroke;
import ru.bitel.bgbilling.client.common.CalendarPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;

public class CalendarDialog
extends BGDialog {
    CalendarPanel calendarPanel = new CalendarPanel();

    public CalendarDialog(Calendar calendar) {
        this();
        this.setCalendar(calendar);
    }

    public CalendarDialog() {
        this.init();
    }

    private void init() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        this.calendarPanel.setVisibleLabelDate(false);
        this.calendarPanel.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "none");
        this.pack();
        this.moveWindowToCenterScreen();
    }

    private void jbInit() throws Exception {
        this.setModal(true);
        this.setResizable(false);
        this.setTitle(" \u041a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044c ");
        this.getContentPane().setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                CalendarDialog.this.result = "cancel";
                CalendarDialog.this.setCalendar(CalendarDialog.this.calendarPanel.getOldCalendar());
                CalendarDialog.this.setVisible(false);
                CalendarDialog.this.dispose();
            }
        });
        this.calendarPanel.addPropertyChangeListener(e -> {
            String propertyName = e.getPropertyName();
            if ("updateCalendar".equals(propertyName)) {
                this.result = "ok";
                this.setVisible(false);
                this.dispose();
            } else if ("updateTitle".equals(propertyName)) {
                this.setTitle((String)e.getNewValue());
            }
        });
        this.getContentPane().add((Component)this.calendarPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(15, 10, 10, 10), 0, 0));
    }

    public void setCalendar(Calendar calendar) {
        this.calendarPanel.setCalendar(calendar);
    }

    public Calendar getCalendar() {
        return this.calendarPanel.getCalendar();
    }
}

