/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.tree.old;

import java.util.Map;
import ru.bitel.bgbilling.common.bean.RangeParser;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.TariffRequest;
import ru.bitel.common.Utils;

public class NPrefixTariffTreeNode
extends DefaultTariffTreeNode {
    private RangeParser rangeParser;
    private int dest;
    private int zone;

    @Override
    public void init(String data, int deep, int nodeId) {
        super.init(data, deep, nodeId);
        Map<String, String> dataHash = this.getDataInHash();
        try {
            this.rangeParser = new RangeParser(Utils.maskNull((String)dataHash.get("prefix")));
            this.dest = Utils.parseInt((String)dataHash.get("dest"));
            this.zone = Utils.parseInt((String)dataHash.get("zone"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void processRequest(TariffRequest request) {
        String phone = (String)request.getRequestParam("phone");
        String action = (String)request.getRequestParam("action");
        if (action != null && action.equals("reset")) {
            this.processForChilds(request);
        } else if (phone != null && this.rangeParser != null && !request.wasAccepted()) {
            String phoneRest = (String)request.getRequestParam("phone_rest");
            if (phoneRest == null) {
                phoneRest = phone;
            }
            RangeParser.CheckResult result = this.rangeParser.checkPrefixWithResult(phoneRest);
            if (result.result) {
                phoneRest = phoneRest.substring(result.length);
                request.setRequestParam("phone_rest", phoneRest);
                if (this.dest > 0) {
                    request.setResponseParam("dest", this.dest);
                }
                if (this.zone > 0) {
                    request.setResponseParam("zone", this.zone);
                }
                this.processForChilds(request);
                request.setAccepted();
            }
        }
    }
}

