/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common.pattern.editors;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.pattern.editors.ConfigBaseEditor;
import ru.bitel.bgbilling.client.common.pattern.editors.ConfigTitle;
import ru.bitel.common.Utils;

public class ConfigStringEditor
extends ConfigBaseEditor {
    private BGTextField textField = new BGTextField();
    private String regexp = new String();

    public ConfigStringEditor() {
        this.addComp(this.textField);
    }

    public String showDialog(ConfigTitle selectTitle) {
        this.originalValue = selectTitle.getValue();
        if (this.originalValue.length() > 120) {
            this.textField.setColumns(100);
        } else if (this.originalValue.length() > 50) {
            this.textField.setColumns(this.originalValue.length());
        } else {
            this.textField.setColumns(50);
        }
        if (selectTitle.getEl() != null) {
            this.regexp = selectTitle.getEl().getAttribute("valid");
            this.defaultValue = selectTitle.getDefaultValue();
        } else {
            this.regexp = null;
            this.defaultValue = null;
        }
        this.textField.setText(selectTitle.getValue());
        if (!selectTitle.isBold() && selectTitle.getEl() != null) {
            this.textField.setEnabled(false);
            this.checkBox.setSelected(true);
        } else {
            this.checkBox.setSelected(false);
            this.textField.setEnabled(true);
        }
        this.pack();
        this.moveWindowToCenterScreen();
        this.result = "cancel";
        return super.showDialog();
    }

    @Override
    public boolean checkValue(String valueStr) {
        return ConfigStringEditor.checkValue(valueStr, this.regexp);
    }

    public static boolean checkValue(String valueStr, String validText) {
        if (!Utils.isBlankString(validText)) {
            Pattern pattern = Pattern.compile(validText);
            Matcher m = pattern.matcher(valueStr);
            return m.matches();
        }
        return true;
    }
}

