/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.tree.old;

import bitel.billing.server.tariff.TariffTreeNode;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.TariffRequest;

public class DefaultTariffTreeNode
extends BGLogger
implements TariffTreeNode {
    protected TariffTreeNode _parent = null;
    protected int _deep = -1;
    protected int _nodeId = -1;
    protected String _data;
    protected Vector<TariffTreeNode> _childs;

    public void init(String data, int deep, int nodeId) {
        this._deep = deep;
        this._data = data;
        this._nodeId = nodeId;
    }

    public final Vector<TariffTreeNode> getChilds() {
        if (this._childs == null) {
            this._childs = new Vector();
        }
        return this._childs;
    }

    public int getId() {
        return this._nodeId;
    }

    public final void loadChilds(TariffTreeNode parent, HashMap<Integer, Vector<TariffTreeNode>> nodes) {
        this._parent = parent;
        this._childs = nodes.remove(this._nodeId);
        if (this._childs != null) {
            int size = this._childs.size();
            TariffTreeNode child = null;
            for (int i = 0; i < size; ++i) {
                child = this._childs.get(i);
                child.loadChilds((TariffTreeNode)this, nodes);
            }
        }
    }

    public void processRequest(TariffRequest request) {
        String action = (String)request.getRequestParam("action");
        if (action != null && action.equals("reset") || !request.wasAccepted()) {
            this.processForChilds(request);
        }
    }

    protected final void processForChilds(TariffRequest request) {
        if (this._childs != null) {
            int size = this._childs.size();
            for (int i = 0; i < size; ++i) {
                this._childs.get(i).processRequest(request);
            }
        }
    }

    protected final void processForMirrorNode(TariffRequest request) {
        if (this._parent != null) {
            Vector near = this._parent.getChilds();
            int size = near.size();
            for (int i = 0; i < size; ++i) {
                if (near.get(i) != this) continue;
                ((TariffTreeNode)near.get(size - i - 1)).processRequest(request);
                break;
            }
        }
    }

    protected final Map<String, String> getDataInHash() {
        HashMap<String, String> result = new HashMap<String, String>();
        StringTokenizer pairsSt = new StringTokenizer(this._data, "%");
        while (pairsSt.hasMoreTokens()) {
            String pair = pairsSt.nextToken();
            StringTokenizer key_value = new StringTokenizer(pair, "&");
            if (key_value.countTokens() != 2) continue;
            result.put(key_value.nextToken(), key_value.nextToken());
        }
        return result;
    }

    protected final long getServiceAmount(int type, long col) {
        return switch (type) {
            case 0 -> col;
            case 1 -> col * 1024L;
            case 2 -> col * 0x100000L;
            case 3 -> col * 0x40000000L;
            case 4 -> col;
            case 5 -> col * 60L;
            case 6 -> col * 3600L;
            default -> 0L;
        };
    }
}

