/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.function.server.access_restore;

import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.sql.Connection;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import ru.bitel.bgbilling.kernel.container.web.action.ActionRequest;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.function.server.PasswordManager;
import ru.bitel.bgbilling.kernel.contract.function.server.access_restore.RestoreAbstract;
import ru.bitel.bgbilling.kernel.contract.function.server.bean.AccessRestoreStepData;
import ru.bitel.bgbilling.kernel.contract.function.server.bean.ContractPasswordOnce;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class RestoreBySms
extends RestoreAbstract {
    @Override
    public String getModeName() {
        return "sms";
    }

    @Override
    public String getTabTitle() {
        return "SMS";
    }

    @Override
    public AccessRestoreStepData doStep(ActionRequest actionRequest, Contract contract, Connection con) throws Exception {
        AccessRestoreStepData restoreStepData = new AccessRestoreStepData();
        String step = actionRequest.get("step", "select");
        if ("select".equals(step)) {
            this.stepSelectPhone(restoreStepData, contract, con);
        } else if ("checkPhone".equals(step)) {
            this.stepCheckPhone(restoreStepData, contract, actionRequest.get("phone"), con);
        } else if ("checkCode".equals(step)) {
            String phone = actionRequest.get("phone");
            String code = actionRequest.get("code");
            this.stepCheckCode(restoreStepData, contract, phone, code, con);
        }
        return restoreStepData;
    }

    protected void stepSelectPhone(AccessRestoreStepData restoreStepData, Contract contract, Connection con) throws Exception {
        List<String> contractPhone = this.getMaskPhones(this.getContractPhone(contract, con));
        if (contractPhone == null || contractPhone.isEmpty()) {
            restoreStepData.setErrorMessage("phoneNotFound");
            return;
        }
        restoreStepData.setNextStep("checkPhone");
        restoreStepData.getStepData().put("step", "select");
        restoreStepData.getStepData().put("selectTitle", "\u0412\u0430\u0448(\u0438) \u0442\u0435\u043b\u0435\u0444\u043e\u043d(\u044b):");
        restoreStepData.getStepData().put("maskItems", contractPhone);
        restoreStepData.getStepData().put("itemTitle", "\u041d\u043e\u043c\u0435\u0440 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0430:");
        restoreStepData.getStepData().put("itemName", "phone");
        restoreStepData.getStepData().put("itemPlaceHolder", this.setup.get("contract.password.forgot.phone.placeholder", "79XXXXXXXXX"));
        restoreStepData.getStepData().put("itemComment", "\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043e\u0434\u0438\u043d \u0438\u0437 \u041d\u043e\u043c\u0435\u0440\u043e\u0432 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 \u0432 \u0441\u043f\u0438\u0441\u043a\u0435 \u0432\u044b\u0448\u0435, \u043d\u0430 \u044d\u0442\u043e\u0442 \u043d\u043e\u043c\u0435\u0440 \u0431\u0443\u0434\u0435\u0442 \u0432\u044b\u0441\u043b\u0430\u043d \u043f\u043e SMS \u043a\u043e\u0434 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f.");
    }

    protected void stepCheckPhone(AccessRestoreStepData restoreStepData, Contract contract, String phone, Connection con) throws Exception {
        if (phone == null) {
            this.stepSelectPhone(restoreStepData, contract, con);
            restoreStepData.setErrorMessage("phoneNotEnter");
            return;
        }
        if (!this.checkPhone(phone, this.getContractPhone(contract, con))) {
            this.stepSelectPhone(restoreStepData, contract, con);
            restoreStepData.setErrorMessage("phoneNotValid");
            restoreStepData.getStepData().put("errorPhone", phone);
            return;
        }
        int phoneCodeLength = this.getCodeLength();
        String smsMessage = this.getPhoneAccessRestore(phone, phoneCodeLength, contract, con);
        if (smsMessage != null) {
            try {
                this.sendSms(phone, smsMessage);
                this.showCheckCode(restoreStepData, phone, phoneCodeLength);
            }
            catch (Exception ex) {
                restoreStepData.setErrorMessage("phoneSendMessage");
                this.logError(ex);
            }
        } else {
            restoreStepData.setErrorMessage("phoneMessageEmpty");
            restoreStepData.getStepData().put("errorPhone", phone);
        }
    }

    protected void sendSms(String phone, String smsMessage) throws Exception {
        String requestUrl = this.setup.get("sms.url");
        if (requestUrl != null) {
            requestUrl = requestUrl.replace("{phone}", URLEncoder.encode(phone, "utf-8"));
            requestUrl = requestUrl.replace("{text}", URLEncoder.encode(smsMessage, "utf-8"));
            HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(requestUrl)).GET().build();
            HttpResponse<String> response = HttpClient.newHttpClient().send(httpRequest, HttpResponse.BodyHandlers.ofString());
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("sms response = {}", (Object)response.body());
            }
        } else {
            throw new Exception("SMS gate requestUrl = null");
        }
    }

    protected void showCheckCode(AccessRestoreStepData restoreStepData, String phone, int phoneCodeLength) {
        restoreStepData.setNextStep("checkCode");
        restoreStepData.getStepData().put("step", "enterCode");
        restoreStepData.getStepData().put("itemName", "phone");
        restoreStepData.getStepData().put("itemValue", phone);
        restoreStepData.getStepData().put("codeMask", "X".repeat(phoneCodeLength));
    }

    protected void stepCheckCode(AccessRestoreStepData restoreStepData, Contract contract, String phone, String code, Connection con) throws Exception {
        List<String> contractPhone = this.getContractPhone(contract, con);
        if (contractPhone == null) {
            restoreStepData.setErrorMessage("phoneNotFound");
            return;
        }
        if (phone == null) {
            this.stepSelectPhone(restoreStepData, contract, con);
            restoreStepData.setErrorMessage("phoneNotEnter");
            return;
        }
        if (!this.checkPhone(phone, this.getContractPhone(contract, con))) {
            this.stepSelectPhone(restoreStepData, contract, con);
            restoreStepData.setErrorMessage("phoneNotCheck");
            return;
        }
        if (code == null) {
            this.stepCheckPhone(restoreStepData, contract, phone, con);
            restoreStepData.setErrorMessage("codeNotEnter");
            return;
        }
        PasswordManager passwordManager = new PasswordManager(con);
        ContractPasswordOnce contractPasswordOnce = passwordManager.getContractPasswordOnceByContractTitle(contract.getTitle());
        if (contractPasswordOnce == null) {
            restoreStepData.setErrorMessage("codeNotFound");
        } else if (contractPasswordOnce.getCreateTime().isAfter(LocalDateTime.now()) && contractPasswordOnce.getCode().equals(code)) {
            restoreStepData.getStepData().put("step", "gotoLK");
            restoreStepData.getStepData().put("code", code);
            return;
        }
        restoreStepData.setErrorMessage("codeNotValid");
        this.showCheckCode(restoreStepData, phone, this.getCodeLength());
    }

    protected int getCodeLength() {
        return this.setup.getInt("contract.password.forgot.phone.code.length", 6);
    }

    protected List<String> getContractPhone(Contract contract, Connection con) throws Exception {
        List contractPhone = null;
        int paramId = this.setup.getInt("contract.password.forgot.phone.param.id", -1);
        if (paramId > 0) {
            try (ContractDao contractDao = new ContractDao(con, 0);){
                contractPhone = contractDao.getContractParameterPhone(contract.getId(), paramId).map(a -> a.toUnformattedPhoneList()).orElse(null);
            }
        }
        return contractPhone;
    }

    protected List<String> getMaskPhones(List<String> phones) {
        if (phones == null || phones.isEmpty()) {
            return new ArrayList<String>();
        }
        ArrayList<String> resultList = new ArrayList<String>();
        String phoneFilter = this.setup.get("contract.password.forgot.phone.filter", "79");
        if (Utils.notBlankString(phoneFilter)) {
            List<String> phonePrefix = Utils.toList(phoneFilter, ";");
            for (String prefix : phonePrefix) {
                resultList.addAll(phones.stream().filter(a -> a.startsWith(prefix)).toList());
            }
        } else {
            resultList.addAll(phones);
        }
        return resultList.stream().map(a -> Utils.maskPhoneNumber(a, 3, 2)).toList();
    }

    protected boolean checkPhone(String phone, List<String> phoneList) {
        boolean result;
        block1: {
            String checkPhone;
            result = false;
            if (phone == null || phoneList == null) break block1;
            Iterator<String> iterator = phoneList.iterator();
            while (iterator.hasNext() && !(result = (checkPhone = iterator.next()).equals(phone))) {
            }
        }
        return result;
    }

    protected String getPhoneAccessRestore(String phone, int phoneCodeLength, Contract contract, Connection con) throws Exception {
        PasswordManager passwordManager = new PasswordManager(con);
        long passwordExpireMinute = this.setup.getLong("contract.password.forgot.expire.minute", this.setup.getLong("contract.password.forgot.expire.hour", 1L) * 60L);
        String smsText = this.setup.get("contract.password.forgot.phone.text", "\u041f\u0440\u043e\u0432\u0435\u0440\u043e\u0447\u043d\u044b\u0439 \u043a\u043e\u0434 \u0434\u043b\u044f \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u043a \u041b\u0438\u0447\u043d\u043e\u043c\u0443 \u043a\u0430\u0431\u0438\u043d\u0435\u0442\u0443 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 {contract}\n\u041a\u043e\u0434 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f - {code}\n\u041a\u043e\u0434 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u0435\u043d \u0434\u043e {time}.");
        String charArray = this.setup.get("contract.password.forgot.char.array", "1234567890QWERTYUIOPLKJHGFDSAZXCVBNMqwertyuioplkjhgfdsazxcvbnm");
        String password = passwordManager.getOncePassword(phoneCodeLength, charArray);
        passwordManager.deleteByContract(contract.getTitle());
        passwordManager.addPassword(contract.getTitle(), passwordExpireMinute, password);
        return smsText.replaceAll("\\{contract\\}", contract.getTitle()).replaceAll("\\{time\\}", TimeUtils.format(new Date(System.currentTimeMillis() + passwordExpireMinute * 60000L), "dd.MM.yyyy HH:mm:ss")).replaceAll("\\{code\\}", password);
    }
}

