/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.EventHandler;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTreeTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.treetable.BGTreeTableModel;
import ru.bitel.common.function.Async;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceGroup;
import ru.bitel.oss.systems.inventory.resource.common.service.DeviceService;

public abstract class DeviceGroupPanel
extends BGUPanel {
    private DeviceGroupTreeTableModel model = new DeviceGroupTreeTableModel();

    public DeviceGroupPanel(ClientContext clientContext) {
        super((LayoutManager)new GridBagLayout(), clientContext);
    }

    @Override
    protected void jbInit() {
        BGUTreeTable treeTable = new BGUTreeTable(this.model);
        this.add((Component)new JScrollPane(treeTable), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.addPropertyChangeListener("edit", EventHandler.create(PropertyChangeListener.class, treeTable, "enabled", "oldValue"));
        BGSwingUtilites.handleEdit(treeTable, this);
    }

    protected abstract DeviceService<?, ?> getWs();

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh(e -> Async.of(() -> this.getWs().deviceGroupRoot()).thenSwing(a -> this.model.setData(a)));
        new AbstractBGUPanel.BGActionNew(e -> {
            DeviceGroup parent = (DeviceGroup)this.model.getSelectedRow();
            DeviceGroup newDeviceGroup = new DeviceGroup();
            newDeviceGroup.setId(-1);
            newDeviceGroup.setParentId(parent != null ? parent.getId() : 0);
            new DeviceGroupEditor("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0433\u0440\u0443\u043f\u043f\u044b", newDeviceGroup).open();
        });
        new AbstractBGUPanel.BGActionEdit(e -> {
            DeviceGroup deviceGroup = (DeviceGroup)this.model.getSelectedRow();
            if (deviceGroup == null) {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
                return;
            }
            new DeviceGroupEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0433\u0440\u0443\u043f\u043f\u044b", deviceGroup).open();
        });
        new AbstractBGUPanel.BGActionDelete(e -> {
            DeviceGroup deviceGroup = (DeviceGroup)this.model.getSelectedRow();
            if (deviceGroup == null) {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f");
                return;
            }
            if (deviceGroup == this.model.getRoot()) {
                ClientUtils.showErrorMessageDialog("\u041a\u043e\u0440\u043d\u0435\u0432\u0443\u044e \u0433\u0440\u0443\u043f\u043f\u0443 \u0443\u0434\u0430\u043b\u044f\u0442\u044c \u043d\u0435\u043b\u044c\u0437\u044f");
                return;
            }
            if (BGSwingUtilites.confirmDelete("\u0433\u0440\u0443\u043f\u043f\u0443", deviceGroup)) {
                this.getWs().deviceGroupDelete(deviceGroup.getId());
                this.performAction("refresh");
            }
        });
    }

    class DeviceGroupTreeTableModel
    extends BGTreeTableModel<DeviceGroup> {
        public DeviceGroupTreeTableModel() {
            super(DeviceGroupTreeTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", DeviceGroup.class, -1, 300, -1, "title", false);
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, 400, -1, "comment", false);
            this.addColumnId();
        }

        @Override
        public Icon getIcon(DeviceGroup value) {
            return super.getIcon(value);
        }
    }

    class DeviceGroupEditor
    extends BGEditorDialog<DeviceGroup> {
        private BGTextField title;
        private JTextArea comment;

        public DeviceGroupEditor(String title, DeviceGroup data) {
            super(title, data);
            this.title = new BGTextField(50);
            this.comment = new JTextArea(4, 50);
        }

        @Override
        public void doDialogPanel() {
            this.addFieldV("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:", this.title);
            this.addFieldV("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:", new JScrollPane(this.comment));
            this.title.setText(((DeviceGroup)this.data).getTitle());
            this.comment.setText(((DeviceGroup)this.data).getComment());
            this.comment.setMargin(new Insets(3, 3, 3, 3));
        }

        @Override
        public boolean doApply() throws Exception {
            if (this.title.getText().isBlank()) {
                ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0433\u0440\u0443\u043f\u043f\u044b");
                return false;
            }
            ((DeviceGroup)this.data).setTitle(this.title.getText());
            ((DeviceGroup)this.data).setComment(this.comment.getText());
            int id = DeviceGroupPanel.this.getWs().deviceGroupUpdate((DeviceGroup)this.data);
            DeviceGroupPanel.this.performAction("refresh");
            DeviceGroupPanel.this.model.setSelectedRow(id);
            return true;
        }
    }
}

