/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.task.server.task;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;

public class TaskGenerator
extends TaskBase {
    private static final int q = 3;
    public static final int ACTION_ADD = 0;
    public static final int ACTION_DEL = 1;
    private PreparedStatement psSelectSourceList = null;
    private PreparedStatement psSelectSourceListMid = null;
    private PreparedStatement psInsertTaskLoad = null;
    private PreparedStatement psInsertTaskProccess = null;
    private PreparedStatement psDeleteTaskProccess = null;
    private PreparedStatement psDeleteTaskLoad = null;
    private boolean generateForAll = false;

    @Override
    public String getDescription() {
        return this.defaultDescription + "\u0417\u0430\u0434\u0430\u0447\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u043b\u043e\u0433\u043e\u0432 \u0441 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u043e\u0432. \u0413\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0434\u043b\u044f \u0432\u0441\u0435\u0445: " + this.generateForAll + ".";
    }

    public TaskGenerator() {
    }

    public TaskGenerator(Connection con) {
        try {
            this.createPreparedStatements(con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void executeTask() {
        Connection con = this.setup.getDBConnectionFromPool();
        try {
            this.createPreparedStatements(con);
            Calendar time = this.getOperatingTime();
            time.add(11, -1);
            this.loadTaskAdd(time);
        }
        catch (Exception e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
        finally {
            ServerUtils.closeConnection(con);
        }
    }

    private void createPreparedStatements(Connection con) throws SQLException {
        Object query = "SELECT id FROM source WHERE ( isNull(date1) or date1<=? ) AND ( isNull(date2) or date2>=? ) ";
        if (!this.generateForAll) {
            query = (String)query + "AND source_type IN ( 1, 2 )";
        }
        this.psSelectSourceList = con.prepareStatement((String)query);
        query = "SELECT id FROM source WHERE ( isNull(date1) or date1<=? ) AND ( isNull(date2) or date2>=? ) and mid=?";
        this.psSelectSourceListMid = con.prepareStatement((String)query);
        query = "INSERT INTO task_load ( dt, param, count ) VALUES ( ?, ?, ? )";
        this.psInsertTaskLoad = con.prepareStatement((String)query);
        query = "INSERT INTO task_proccess ( mid, dt, param ) VALUES ( ?, ?, ? )";
        this.psInsertTaskProccess = con.prepareStatement((String)query);
        query = "DELETE FROM task_proccess WHERE mid=? AND dt=? AND param=?";
        this.psDeleteTaskProccess = con.prepareStatement((String)query);
        query = "DELETE FROM task_load WHERE dt=? AND param=?";
        this.psDeleteTaskLoad = con.prepareStatement((String)query);
    }

    public void loadTask(int action, Date date, int sourceID, List<String> hourss) {
        if (date != null && hourss != null) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(date);
            block4: for (int h = 0; h < hourss.size(); ++h) {
                int hh = Utils.parseInt((String)hourss.get(h), (int)-1);
                if (hh <= -1 || hh >= 24) continue;
                calendar.set(11, hh);
                switch (action) {
                    case 0: {
                        this.loadTaskAdd(calendar, sourceID);
                        continue block4;
                    }
                    case 1: {
                        this.loadTaskDelete(calendar, sourceID);
                    }
                }
            }
        }
    }

    public void loadTaskAll(int action, Date date, int mid, List<String> hours) {
        if (date != null && hours != null) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(date);
            block4: for (int h = 0; h < hours.size(); ++h) {
                String hValue = hours.get(h).trim();
                int hh = Utils.parseInt((String)hValue, (int)-1);
                if (hh <= -1 || hh >= 24) continue;
                calendar.set(11, hh);
                switch (action) {
                    case 0: {
                        this.loadTaskAllAdd(calendar, mid);
                        continue block4;
                    }
                    case 1: {
                        this.loadTaskAllDelete(calendar, mid);
                    }
                }
            }
        }
    }

    private void loadTaskAdd(Calendar date) {
        if (date != null) {
            java.sql.Date sqlDate = new java.sql.Date(date.getTime().getTime());
            try {
                this.psSelectSourceList.setDate(1, sqlDate);
                this.psSelectSourceList.setDate(2, sqlDate);
                try (ResultSet rs = this.psSelectSourceList.executeQuery();){
                    while (rs.next()) {
                        this.loadTaskAdd(date, rs.getInt(1));
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void loadTaskAdd(Calendar date, int sourceID) {
        if (date != null) {
            try {
                date = this.clearMinSecMillisec(date);
                this.psInsertTaskLoad.setTimestamp(1, new Timestamp(date.getTime().getTime()));
                this.psInsertTaskLoad.setInt(2, sourceID);
                this.psInsertTaskLoad.setInt(3, 3);
                this.psInsertTaskLoad.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void loadTaskAllAdd(Calendar date, int mid) {
        if (date != null) {
            try {
                java.sql.Date sqlDate = new java.sql.Date(date.getTime().getTime());
                date = this.clearMinSecMillisec(date);
                Timestamp time = new Timestamp(date.getTime().getTime());
                this.psInsertTaskLoad.setTimestamp(1, time);
                this.psInsertTaskLoad.setInt(3, 3);
                this.psSelectSourceListMid.setDate(1, sqlDate);
                this.psSelectSourceListMid.setDate(2, sqlDate);
                this.psSelectSourceListMid.setInt(3, mid);
                ResultSet rs = this.psSelectSourceListMid.executeQuery();
                while (rs.next()) {
                    this.psInsertTaskLoad.setInt(2, rs.getInt(1));
                    this.psInsertTaskLoad.executeUpdate();
                }
                rs.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void loadTaskDelete(Calendar date, int source_id) {
        if (date != null) {
            try {
                date = this.clearMinSecMillisec(date);
                Timestamp time = new Timestamp(date.getTime().getTime());
                this.psDeleteTaskLoad.setTimestamp(1, time);
                this.psDeleteTaskLoad.setInt(2, source_id);
                this.psDeleteTaskLoad.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void loadTaskAllDelete(Calendar date, int mid) {
        if (date != null) {
            try {
                java.sql.Date sqlDate = new java.sql.Date(date.getTime().getTime());
                date = this.clearMinSecMillisec(date);
                Timestamp time = new Timestamp(date.getTime().getTime());
                this.psDeleteTaskLoad.setTimestamp(1, time);
                this.psSelectSourceListMid.setDate(1, sqlDate);
                this.psSelectSourceListMid.setDate(2, sqlDate);
                this.psSelectSourceListMid.setInt(3, mid);
                ResultSet rs = this.psSelectSourceListMid.executeQuery();
                while (rs.next()) {
                    this.psDeleteTaskLoad.setInt(2, rs.getInt(1));
                    this.psDeleteTaskLoad.executeUpdate();
                }
                rs.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void processTask(int action, Date date, int mid, int sourceID, List<String> hours) {
        if (date != null && hours != null) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(date);
            block4: for (int h = 0; h < hours.size(); ++h) {
                String value = hours.get(h).trim();
                int hh = Utils.parseInt((String)value, (int)-1);
                if (hh <= -1 || hh >= 24) continue;
                calendar.set(11, hh);
                switch (action) {
                    case 0: {
                        this.processTaskAdd(calendar, mid, sourceID);
                        continue block4;
                    }
                    case 1: {
                        this.processTaskDelete(calendar, mid, sourceID);
                    }
                }
            }
        }
    }

    public void processTask(int action, Date date, int mid, List<String> hours) {
        if (date != null && hours != null) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(date);
            block4: for (int h = 0; h < hours.size(); ++h) {
                String value = hours.get(h).trim();
                int hh = Utils.parseInt((String)value, (int)-1);
                if (hh <= -1 || hh >= 24) continue;
                calendar.set(11, hh);
                switch (action) {
                    case 0: {
                        this.processTaskAdd(calendar, mid);
                        continue block4;
                    }
                    case 1: {
                        this.processTaskDelete(calendar, mid);
                    }
                }
            }
        }
    }

    public void processTaskAdd(Calendar date, int mid) {
        if (date != null) {
            try {
                java.sql.Date sqlDate = new java.sql.Date(date.getTime().getTime());
                this.psSelectSourceListMid.setDate(1, sqlDate);
                this.psSelectSourceListMid.setDate(2, sqlDate);
                this.psSelectSourceListMid.setInt(3, mid);
                ResultSet rs = this.psSelectSourceListMid.executeQuery();
                while (rs.next()) {
                    this.processTaskAdd(date, mid, rs.getInt(1));
                }
                rs.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void processTaskAdd(Calendar date, int mid, int param) {
        if (date != null) {
            try {
                date = this.clearMinSecMillisec(date);
                this.psInsertTaskProccess.setInt(1, mid);
                this.psInsertTaskProccess.setTimestamp(2, new Timestamp(date.getTime().getTime()));
                this.psInsertTaskProccess.setInt(3, param);
                this.psInsertTaskProccess.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void processTaskDelete(Calendar date, int mid) {
        if (date != null) {
            try {
                java.sql.Date sqlDate = new java.sql.Date(date.getTime().getTime());
                this.psSelectSourceListMid.setDate(1, sqlDate);
                this.psSelectSourceListMid.setDate(2, sqlDate);
                this.psSelectSourceListMid.setInt(3, mid);
                ResultSet rs = this.psSelectSourceListMid.executeQuery();
                while (rs.next()) {
                    this.processTaskDelete(date, mid, rs.getInt(1));
                }
                rs.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void processTaskDelete(Calendar date, int mid, int param) {
        if (date != null) {
            try {
                date = this.clearMinSecMillisec(date);
                Timestamp time = new Timestamp(date.getTime().getTime());
                this.psDeleteTaskProccess.setInt(1, mid);
                this.psDeleteTaskProccess.setTimestamp(2, time);
                this.psDeleteTaskProccess.setInt(3, param);
                this.psDeleteTaskProccess.executeUpdate();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Calendar clearMinSecMillisec(Calendar time) {
        Calendar dateHH = (Calendar)time.clone();
        dateHH.clear(14);
        dateHH.clear(13);
        dateHH.clear(12);
        return dateHH;
    }

    @Override
    protected boolean initTask() {
        this.generateForAll = this.taskSetup.getInt("generate.for.all", -1) > 0;
        return true;
    }
}

