/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.client.tree;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.label.common.bean.ContractLabelItem;
import ru.bitel.bgbilling.kernel.contract.label.common.service.ContractLabelService;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.client.TariffPanelEditor;
import ru.bitel.bgbilling.kernel.tariff.client.editor.MultiSelectEditor;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;

public class ContractLabelsTariffTreeNode
extends DefaultTariffTreeNode {
    private static final String STORE_KEY = "contractLabelIds";
    private static final Icon icon = ClientUtils.getIcon("fugue/category");
    private JLabel view = new JLabel();
    private MultiSelectEditor<IdTitle> labelEditor = null;
    private List<IdTitle> labels = new ArrayList<IdTitle>();
    private String labelTitle;

    @Override
    public void init(int id, int mtree, String type, TariffTree tree, ModuleTariffConfig config, TariffTreeNode parent, Map<Integer, List<Element>> childsArray) {
        super.init(id, mtree, type, tree, config, parent, childsArray);
        this.view.setIcon(icon);
        TariffPanelEditor tariffPanelEditor = (TariffPanelEditor)tree.getParent();
        try {
            ContractLabelService contractLabelService = ((ClientContext)tariffPanelEditor.getContext()).getWebService(ContractLabelService.class, 0);
            ContractLabelItem contractLabelItem = contractLabelService.getContractLabelTree();
            this.addLabel(contractLabelItem, null);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    private void addLabel(ContractLabelItem contractLabelItem, String prefix) {
        if (contractLabelItem == null) {
            return;
        }
        if (contractLabelItem.getParentId() == 0) {
            prefix = contractLabelItem.getId() < 100 ? "\u0413\u0440\u0443\u043f\u043f\u0430: " : "\u041c\u0435\u0442\u043a\u0430: ";
        } else {
            this.labels.add(new IdTitle(contractLabelItem.getId(), (String)prefix + contractLabelItem.getTitle()));
            prefix = (String)prefix + contractLabelItem.getTitle();
        }
        String childPrefix = (String)prefix + (contractLabelItem.getParentId() == 0 ? "" : " => ");
        List<ContractLabelItem> contractLabelItems = contractLabelItem.getChildren();
        if (contractLabelItems != null) {
            contractLabelItems.forEach(a -> this.addLabel((ContractLabelItem)a, childPrefix));
        }
    }

    @Override
    public Component getView() throws Exception {
        return this.view;
    }

    @Override
    public void setData(String data) {
        super.setData(data);
        this.updateView();
    }

    private void updateView() {
        this.extractData();
        this.view.setText(this.labelTitle);
    }

    @Override
    protected JPanel getEditorPanel() {
        if (this.labelEditor == null) {
            this.labelEditor = new MultiSelectEditor<IdTitle>(this.labels, true);
        }
        return this.labelEditor;
    }

    @Override
    protected void loadData() {
        this.getEditorPanel();
        this.labelEditor.setSelect(Utils.toString(this.getLabelIds()));
        this.labelEditor.setMode(this.getMode());
    }

    @Override
    protected void serializeData() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(STORE_KEY, this.labelEditor.getSelect());
        data.put("mode", "or".equals(this.labelEditor.getMode()) ? "0" : "1");
        this.setDataInHash(data);
        this.updateView();
    }

    public void extractData() {
        List<Integer> labelIds = this.getLabelIds();
        StringBuffer str = new StringBuffer();
        if (this.labels != null && !labelIds.isEmpty()) {
            labelIds.forEach(id -> str.append(str.length() > 0 ? "<br>" : "").append(" ").append(this.getLabelTitle((int)id)));
        }
        this.labelTitle = "<html>" + this.getLabelTitle() + "<br>" + str.toString() + "</html>";
    }

    public String getLabelTitle(int id) {
        return "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;* " + this.labels.stream().filter(a -> a.getId() == id).map(IdTitle::getTitle).findFirst().orElse("#" + id);
    }

    public List<Integer> getLabelIds() {
        Map<String, String> data = this.getDataInHash();
        List<Integer> list = Utils.toIntegerList(data.getOrDefault(STORE_KEY, ""));
        list.addAll(Utils.toIntegerList(data.getOrDefault("contractGroups", "")).stream().map(a -> a + 2).toList());
        return list;
    }

    public String getMode() {
        Map<String, String> data = this.getDataInHash();
        return data.getOrDefault("mode", "0").equals("0") ? "or" : "and";
    }

    protected String getLabelTitle() {
        return "\u041c\u0435\u0442\u043a\u0438(\u0433\u0440\u0443\u043f\u043f\u044b) \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 [\u0440\u0435\u0436\u0438\u043c: " + ("or".equals(this.getMode()) ? "\u0418\u041b\u0418" : "\u0418") + "]: ";
    }
}

