<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xalan="http://xml.apache.org/xalan"
    xmlns:exslt="http://exslt.org/common"
	version="1.0">

<xsl:output method="html" encoding="UTF-8" indent="yes"/>

<xsl:template match="/data">
<html>
<head>
 <meta http-equiv="content-type" content="text/html; charset=UTF-8" />
 <style>body {font-family: sans-serif;}</style>
</head>
 


<body>
	<h3>Информация по договору <xsl:value-of select="contract/@title"/> (<xsl:value-of select="contract/@comment"/>) на <xsl:value-of select="contract/@time"/></h3>

	<table width="800" border="0" cellpaddind="3">
		<tr>
			<td><b>Режим:</b></td>
			<td>
				<xsl:if test="contract/@mode='0'">КРЕДИТ</xsl:if>
				<xsl:if test="contract/@mode='1'">ДЕБЕТ</xsl:if>
			</td>
			<td></td>
			<td></td>
		</tr>
		<tr>	
			<td><b>Остаток на счете:</b></td>
			<td><xsl:value-of select="contract/@balance_rest"/></td>
			<td><b>Пароль доступа к статистике:</b></td>
			<td><xsl:value-of select="contract/@pswd"/></td>
		</tr>	
		<tr>
			<td><b>Лимит:</b></td>
			<td><xsl:value-of select="contract/@limit"/></td>
			<td><b>Лицо:</b></td>
			<td>
				<xsl:if test="contract/@fc='0'">ФИЗИЧЕСКОЕ</xsl:if>
				<xsl:if test="contract/@fc='1'">ЮРИДИЧЕСКОЕ</xsl:if>
			</td>
		</tr>
	</table>
	<br/>
	
	<b>Параметры договора:</b>
	<table width="800" border="0" cellpaddind="3">
		<tr>
			<td bgcolor="#a0a0a0"><b>Параметр</b></td>
			<td bgcolor="#a0a0a0"><b>Значение</b></td>		
		</tr>
		<xsl:for-each select="parameters/parameter">
		<tr>
			<td><xsl:value-of select="@title"/></td>
			<td><xsl:value-of select="@value"/></td>
		</tr>
		</xsl:for-each>
	</table>
	
	<br/>
	<b>Тарифные планы:</b>
	<table width="800" border="0" cellpaddind="3">
		<xsl:for-each select="contract/tariff">
			<tr><td>
			<xsl:value-of select="@tariff_plan"/>
			</td></tr>				
		</xsl:for-each>				
	</table>
	
	<br/>
	<b>Перечень потребляемых услуг:</b>	
	<table width="800" border="0" cellpaddind="3">
		<xsl:for-each select="module">
		<tr>
			<td><b> - <xsl:value-of select="@title"/></b></td>
		</tr>
		<tr>
			<xsl:variable name="mid"><xsl:value-of select="@id"/></xsl:variable>
		
						
			<td><table width="100%" border="0" cellpaddind="3">
			
			<xsl:choose>				
			
			<!-- Dial-UP -->
			<xsl:when test="@name='dialup'">
				<tr>
					<td bgcolor="#a0a0a0"><b>Логин</b></td>
					<td bgcolor="#a0a0a0"><b>Алиасы</b></td>
					<td bgcolor="#a0a0a0"><b>Пароль</b></td>
					<td bgcolor="#a0a0a0"><b>Состояние</b></td>
				</tr>
								
				<xsl:for-each select="./*[name()=concat( 'user_login_', $mid )]">
					<tr>
						<xsl:variable name="lid" select="@id"/>
					
						<td><xsl:value-of select="@login"/></td>
						<td>
							<xsl:for-each select="../*[name()=concat( 'user_alias_', $mid ) and @login_id=$lid]">
								<xsl:value-of select="@login_alias"/>&#160;  
							</xsl:for-each>						
						</td>
						<td><xsl:value-of select="@pswd"/></td>
						<td>
							<xsl:if test="@status='0'">доступ разрешен</xsl:if>
							<xsl:if test="@status='1'">доступ запрещен</xsl:if>
						</td>
				    </tr>
				</xsl:for-each>
			</xsl:when>	
						
			<!-- INET -->
			<xsl:when test="@name='inet'">
				<tr>
					<td bgcolor="#a0a0a0"><b>Сервис</b></td>
					<td bgcolor="#a0a0a0"><b>Тип</b></td>
					<td bgcolor="#a0a0a0"><b>Устройство</b></td>
					<td bgcolor="#a0a0a0"><b>Период</b></td>
					<td bgcolor="#a0a0a0"><b>Статус</b></td>
					<td bgcolor="#a0a0a0"><b>Состояние</b></td>
					<td bgcolor="#a0a0a0"><b>Пароль</b></td>
				</tr>
				
				<xsl:for-each select="./*[name()=concat( 'inet_serv_', $mid )]">
					<tr>						
						<td><xsl:value-of select="@title"/></td>
						<td><xsl:value-of select="@_typeTitle"/></td>
						<td><xsl:value-of select="@_deviceTitle"/><!-- (<xsl:value-of select="@_deviceComment"/>) --></td>
						<td>
							<xsl:value-of select="@dateFrom"/>-
							<xsl:choose>
								<xsl:when test="@dateTo!=''"><xsl:value-of select="@dateTo"/></xsl:when>
								<xsl:otherwise>..</xsl:otherwise>
							</xsl:choose>
							
						</td>
						<td>
							<xsl:if test="0 >= @parentId">
								<xsl:choose>
								<xsl:when test="@status='0'">открыт</xsl:when>
								<xsl:when test="@status='1'">закрыт</xsl:when>
								<xsl:when test="@status='2'">заблокирован</xsl:when>
								</xsl:choose>
							</xsl:if>
						</td>
						<td>
							<xsl:if test="0 >= @parentId">
								<xsl:choose>
								<xsl:when test="@deviceState='-1'">удален</xsl:when>
								<xsl:when test="@deviceState='1'">включен</xsl:when>
								<xsl:when test="@deviceState='0'">отключен</xsl:when>
								</xsl:choose>
							</xsl:if>
						</td>
						<td><xsl:value-of select="@password"/></td>
				    </tr>
				</xsl:for-each>
			</xsl:when>
			
			<!-- TV -->
			<xsl:when test="@name='tv'">
				<tr>
					<td bgcolor="#a0a0a0"><b>Аккаунт</b></td>
<!-- 					<td bgcolor="#a0a0a0"><b>Тип</b></td> -->
<!-- 					<td bgcolor="#a0a0a0"><b>Устройство</b></td> -->
					<td bgcolor="#a0a0a0"><b>Период</b></td>
					<td bgcolor="#a0a0a0"><b>Статус</b></td>
					<td bgcolor="#a0a0a0"><b>Состояние</b></td>
					<td bgcolor="#a0a0a0"><b>Пароль</b></td>
				</tr>
				
				<xsl:variable name="accounts" select="./*[name()=concat( 'tv_account_', $mid )]"/>
				
			    <xsl:call-template name="tv">
			    	<xsl:with-param name="accounts" select="$accounts"/>
			    	<xsl:with-param name="currentAccounts" select="$accounts[@parentId=0]"/>
				</xsl:call-template>
			</xsl:when>
			
			<!-- VOIP -->
			<xsl:when test="@name='voiceip'">
				<tr>
					<td bgcolor="#a0a0a0"><b>Логин</b></td>
					<td bgcolor="#a0a0a0"><b>Телефоны безпарольного доступа</b></td>
					<td bgcolor="#a0a0a0"><b>Пароль</b></td>
					<td bgcolor="#a0a0a0"><b>Состояние</b></td>
				</tr>
								
				<xsl:for-each select="./*[name()=concat( 'user_login_', $mid )]">
					<tr>
						<xsl:variable name="lid" select="@id"/>
					
						<td><xsl:value-of select="@login"/></td>
						<td>
							<xsl:for-each select="../*[name()=concat( 'user_alias_', $mid ) and @login_id=$lid]">
								<xsl:value-of select="@login_alias"/>&#160;  
							</xsl:for-each>						
						</td>
						<td><xsl:value-of select="@pswd"/></td>
						<td>
							<xsl:if test="@status='0'">доступ разрешен</xsl:if>
							<xsl:if test="@status='1'">доступ запрещен</xsl:if>
						</td>
				    </tr>
				</xsl:for-each>
			</xsl:when>
			
			<!-- VOICE -->
			<xsl:when test="@name='voice'">
				<tr><td bgcolor="#a0a0a0"><b>Телефон</b></td></tr>
				<xsl:for-each select="./*[name()=concat( 'voice_account_', $mid )]">
					<tr><td><xsl:value-of select="@number"/></td></tr>
				</xsl:for-each>
			</xsl:when>
			
			<!-- IPN -->
			<xsl:when test="@name='ipn'">
				<tr>
					<td bgcolor="#a0a0a0"><b>Начало диапазона</b></td>
					<td bgcolor="#a0a0a0"><b>Конец диапазона</b></td>
				</tr>
								
				<xsl:for-each select="./*[name()=concat( 'ipn_user_range_', $mid )]">
					<tr>
						<xsl:variable name="addr" select="@addr1"/>
						<td><xsl:value-of select="concat( floor($addr div 16777216),'.',floor($addr div 65536) mod 256,'.',floor($addr div 256) mod 256 ,'.',$addr mod 256)"/></td>
						<xsl:variable name="addr" select="@addr2"/>
						<td><xsl:value-of select="concat( floor($addr div 16777216),'.',floor($addr div 65536) mod 256,'.',floor($addr div 256) mod 256 ,'.',$addr mod 256)"/></td>
				    </tr>
				</xsl:for-each>
			</xsl:when>
			
			<!-- TrayInfo -->
			<xsl:when test="@name='trayinfo'">
				<tr>
					<td bgcolor="#a0a0a0"><b>Логин</b></td>
					<td bgcolor="#a0a0a0"><b>Пароль</b></td>					
				</tr>
								
				<xsl:for-each select="./*[name()=concat( 'trayinfo_login_', $mid )]">
					<tr>
						<td><xsl:value-of select="@id"/></td>
						<td><xsl:value-of select="@pswd"/></td>
				    </tr>
				</xsl:for-each>
			</xsl:when>
			
			<!-- E-Mail -->
			<xsl:when test="@name='email'">
				<tr>
					<td bgcolor="#a0a0a0"><b>E-Mail</b></td>
					<td bgcolor="#a0a0a0"><b>Пересылки</b></td>
					<td bgcolor="#a0a0a0"><b>Пароль</b></td>
					<td bgcolor="#a0a0a0"><b>Квота (КБ)</b></td>
				</tr>
								
				<xsl:for-each select="./*[name()=concat( 'email_account_', $mid )]">
					<tr>
						<xsl:variable name="did" select="@did"/>
						<xsl:variable name="id" select="@id"/>
					
						<td><xsl:value-of select="concat( @account, '@', ../*[name()=concat( 'email_domain_', $mid )]/domain[@id=$did]/@name )"/></td>
						<td>
							<xsl:for-each select="../*[name()=concat( 'email_forward_', $mid ) and @aid=$id]">
								<xsl:value-of select="@email"/>&#160;
							</xsl:for-each>
						</td>
						<td><xsl:value-of select="@password"/></td>
						<td><xsl:value-of select="@quota"/></td>
				    </tr>
				</xsl:for-each>
			</xsl:when>
			
			<!-- Карточки -->			
			<xsl:when test="@name='card'">
				<tr>
					<td bgcolor="#a0a0a0"><b>Тип карты, разрешенной к использованию для пополнения счета</b></td>
				</tr>								
				<xsl:for-each select="/data/contract_service[@mid=$mid]">
					<tr>
						<td><xsl:value-of select="@title"/></td>
				    </tr>
				</xsl:for-each>			
			</xsl:when>
			
			<!-- Абонплаты -->			
			<xsl:when test="@name='npay'">
				<tr>
					<td bgcolor="#a0a0a0"><b>Начисляемые абонплаты</b></td>
				</tr>
				<xsl:variable name="table_name" select="concat('npay_service_object_', $mid)"/>
				<xsl:for-each select="*[local-name()=$table_name]">
					<tr>
						<td>
						 	<xsl:value-of select="@title"/>
						</td>
				    </tr>
				</xsl:for-each>			
			</xsl:when>
			
			<xsl:when test="@name='megogo'">
				<tr>
					<td bgcolor="#a0a0a0"><b>Логин</b></td>
					<td bgcolor="#a0a0a0"><b>Пароль</b></td>
					<td bgcolor="#a0a0a0"><b>Megogo id</b></td>
				</tr>
				<xsl:variable name="table_name" select="concat('megogo_contract_credentials_', $mid)"/>
				<xsl:for-each select="*[local-name()=$table_name]">
					<tr>
						<td>
						 	<xsl:value-of select="@login"/>
						</td>
						<td>
						 	<xsl:value-of select="@pwd"/>
						</td>
						<td>
						 	<xsl:value-of select="@uid"/>
						</td>
				    </tr>
				</xsl:for-each>			
			</xsl:when>
			
			<xsl:otherwise >
				<xsl:for-each select="/data/contract_service[@mid=$mid]">
					<tr>
						<td><xsl:value-of select="@title"/></td>
				    </tr>
				</xsl:for-each>			
			</xsl:otherwise>		
			</xsl:choose>
												
			
			</table></td>						
		</tr>
		</xsl:for-each>
	</table>
</body>
</html>
</xsl:template>

<xsl:template name="tv">
<xsl:param name="accounts"/>
<xsl:param name="currentAccounts"/>

<xsl:for-each select="$currentAccounts">
	
	<xsl:variable name="id" select="@id"/>
	
	<tr>						
		<td><xsl:value-of select="@title"/></td>
<!-- 		<td><xsl:value-of select="@_specTitle"/></td> -->
<!-- 		<td><xsl:value-of select="@_deviceTitle"/></td> -->
		<td>
			<xsl:value-of select="@dateFrom"/>-
			<xsl:choose>
				<xsl:when test="@dateTo!=''"><xsl:value-of select="@dateTo"/></xsl:when>
				<xsl:otherwise>..</xsl:otherwise>
			</xsl:choose>
			
		</td>
		<td>
			<xsl:if test="@status='0'">открыт</xsl:if>
			<xsl:if test="@status='1'">закрыт</xsl:if>
			<xsl:if test="@status='2'">заблокирован</xsl:if>
		</td>
		<td>
			<xsl:if test="@deviceState='-1'">удален</xsl:if>
			<xsl:if test="@deviceState='1'">включен</xsl:if>
			<xsl:if test="@deviceState='0'">отключен</xsl:if>
		</td>
		<td><xsl:value-of select="@password"/></td>
    </tr>
    
    <xsl:call-template name="tv">
    	<xsl:with-param name="accounts" select="$accounts"/>
    	<xsl:with-param name="currentAccounts" select="$accounts[@parentId=$id]"/>
	</xsl:call-template>
    
</xsl:for-each>

</xsl:template>


</xsl:stylesheet>
