/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.container.resource;

import jakarta.annotation.Resource;
import java.lang.reflect.Proxy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ContainerContext;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.container.resource.ResourceAdapter;
import ru.bitel.bgbilling.kernel.container.service.server.ServiceFactory;
import ru.bitel.bgbilling.kernel.container.service.server.ServiceInfo;

class ServiceResourceAdapter
implements ResourceAdapter<Object> {
    private static final Logger logger = LogManager.getLogger();

    @Override
    public Object borrow(ContainerContext ctx, int moduleId, Resource resource, Class<?> clazz, Class<?> resourceClazz, Class<?> serviceClass, Object bean) throws BGException {
        if (ctx instanceof ServerContext) {
            return ((ServerContext)ctx).getService(serviceClass, moduleId);
        }
        return ServiceFactory.newService(serviceClass, moduleId);
    }

    @Override
    public void commit(Object r) {
    }

    @Override
    public void recycle(Object r) {
        try {
            if (!(r instanceof Proxy) && !Proxy.isProxyClass(r.getClass())) {
                ServiceInfo<?> helper = ServiceInfo.getServiceHelper(r.getClass());
                helper.preDestroy(r);
            }
        }
        catch (Exception e) {
            logger.error(r + ":" + e.getMessage(), (Throwable)e);
        }
    }
}

