/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.integration.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.integration.common.bean.Register;
import ru.bitel.bgbilling.kernel.integration.common.bean.RegisterItem;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class RegisterItemManager {
    private Connection con;

    public RegisterItemManager(Connection con) {
        this.con = con;
    }

    public void createTable(String tableName) throws SQLException {
        String query = "CREATE TABLE " + tableName + " (id int AUTO_INCREMENT PRIMARY KEY,unique_id varchar(60) NOT NULL,rid int default 0,cid int default 0,dt date,summa decimal(10,2) default 0,pid int default 0,ptid int default 0,comment varchar(200) default '', extra_params TEXT, KEY rid(rid),KEY unique_id(unique_id) )";
        ServerUtils.checkAndCreatePeriodicTableName(this.con, tableName, query);
    }

    public void updateRegisterItem(Register register, RegisterItem item) throws BGException {
        try {
            String query = null;
            PreparedStatement ps = null;
            String tableName = ServerUtils.getMonthTableName("payment_register_item", register.getDate());
            this.createTable(tableName);
            if (item.getId() <= 0) {
                query = "INSERT INTO " + tableName + " ( rid, cid, summa, pid, ptid, comment, dt, unique_id, extra_params ) VALUES ( ?, ?, ?, ?, ?, ?, ? , ?, ? )";
                ps = this.con.prepareStatement(query, 1);
            } else {
                query = "UPDATE " + tableName + " SET rid=?, cid=?, summa=?, pid=?, ptid=?, comment=?, dt=?, unique_id=?, extra_params=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(10, item.getId());
            }
            ps.setInt(1, item.getRegisterId());
            ps.setInt(2, item.getContractId());
            ps.setBigDecimal(3, item.getSumma());
            ps.setInt(4, item.getBalanceItemId());
            ps.setInt(5, item.getBalanceItemTypeId());
            ps.setString(6, item.getBalanceItemComment());
            ps.setDate(7, TimeUtils.convertDateToSqlDate((Date)item.getDate()));
            ps.setString(8, item.getUniqueId());
            ps.setString(9, item.extraParametersAsString());
            ps.executeUpdate();
            if (item.getId() <= 0) {
                item.setId(ServerUtils.lastInsertId(ps));
            }
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void deleteRegisterItems(Register register) throws BGException {
        String tableName = ServerUtils.getMonthTableName("payment_register_item", register.getDate());
        if (!ServerUtils.tableExists(this.con, tableName)) {
            return;
        }
        String query = "DELETE FROM " + tableName + " WHERE rid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, register.getId());
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public List<RegisterItem> getRegisterItems(Register register) throws BGException {
        ArrayList<RegisterItem> result = new ArrayList<RegisterItem>();
        String tableName = ServerUtils.getMonthTableName("payment_register_item", register.getDate());
        if (!ServerUtils.tableExists(this.con, tableName)) {
            return result;
        }
        String query = "SELECT * FROM " + tableName + " WHERE rid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, register.getId());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                RegisterItem item = new RegisterItem();
                this.loadItemFromRS(item, rs, register.getRegisterType());
                result.add(item);
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public String checkItemsWithUniqueId(Register register, String id) {
        try {
            if (Utils.isBlankString((String)id)) {
                return null;
            }
            String tableName = ServerUtils.getMonthTableName("payment_register_item", register.getDate());
            if (ServerUtils.tableExists(this.con, tableName)) {
                String query = "SELECT item.id, register.date, register.title, contract.title FROM " + tableName + " AS item LEFT JOIN payment_register  AS register ON item.rid=register.id LEFT JOIN contract ON item.cid=contract.id WHERE unique_id=?";
                PreparedStatement ps = this.con.prepareStatement(query);
                ps.setString(1, id);
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    String error = "\u0437\u0430\u043f\u0438\u0441\u044c \u0441 \u0430\u043d\u0430\u043b\u043e\u0433\u0438\u0447\u043d\u044b\u043c id \u0435\u0441\u0442\u044c \u0432 \u0440\u0435\u0435\u0441\u0442\u0440\u0435 " + rs.getString(3) + " \u043e\u0442 " + TimeUtils.formatDate((Date)rs.getDate(2));
                    String contract = rs.getString(4);
                    if (Utils.notBlankString((String)contract)) {
                        error = error + " \u0434\u043e\u0433\u043e\u0432\u043e\u0440 " + contract;
                    }
                    return error;
                }
                rs.close();
                ps.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    private void loadItemFromRS(RegisterItem item, ResultSet rs, int type) throws SQLException {
        item.setId(rs.getInt("id"));
        item.setBalanceItemId(rs.getInt("pid"));
        item.setBalanceItemTypeId(rs.getInt("ptid"));
        item.setRegisterId(rs.getInt("rid"));
        item.setSumma(rs.getBigDecimal("summa"));
        item.setContractId(rs.getInt("cid"));
        item.setBalanceItemComment(rs.getString("comment"));
        item.setDate(rs.getDate("dt"));
        String params = rs.getString("extra_params");
        if (Utils.notBlankString((String)params)) {
            HashMap<String, String> extraParametersMap = new HashMap<String, String>();
            String[] extra = params.split(";");
            for (int i = 0; i < extra.length; ++i) {
                String parameter = extra[i].trim();
                if (!parameter.contains(":")) continue;
                String key = parameter.substring(0, parameter.indexOf(":"));
                String value = parameter.substring(parameter.indexOf(":") + 1, parameter.length());
                extraParametersMap.put(key, value);
            }
            item.setExtraParametersMap(extraParametersMap);
        }
        try {
            item.setUniqueId(rs.getString("unique_id"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

