/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.script;

import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.script.GlobalScriptEditor;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGSwingUtilites;

public class GlobalScripts
extends BGPanel {
    private GlobalScriptEditor editor = null;
    private CardLayout cardLayout = new CardLayout();
    private BGTable table = new BGTable();

    public GlobalScripts() {
        this.module = "script.global";
        this.editor = new GlobalScriptEditor(this);
        this.editor.init(this.module, 0);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        this.table.setHeader(this.rb_name, this.moduleDoc, "gscript");
        this.trySetData();
    }

    private void jbInit() throws Exception {
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.setName("table");
        mainPanel.add((Component)new JScrollPane(this.table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.setLayout(new BorderLayout());
        this.setLayout(this.cardLayout);
        this.add((Component)this.editor, "editor");
        this.add((Component)mainPanel, "table");
        this.cardLayout.show(this, "table");
        BGSwingUtilites.handleLDMouseClicked(this.table, e -> this.editItem());
    }

    private void startEdit(String id) {
        this.editor.setId(id);
        this.cardLayout.show(this, "editor");
        this.editor.setData();
    }

    public void hideEditor() {
        this.cardLayout.show(this, "table");
        this.trySetData();
    }

    @Override
    public void setData() throws Exception {
        Request req = new Request().setModule(this.module).setAction("GlobalScriptTable");
        Document doc = this.getDocument(req);
        if (ClientUtils.checkStatus(doc)) {
            this.table.updateData(XMLUtils.selectNode(doc, "/data/table"));
        }
    }

    @Override
    public void newItem() {
        if (this.editor.isShowing()) {
            this.editor.newItem();
            return;
        }
        this.startEdit("new");
    }

    @Override
    public void editItem() {
        if (this.editor.isShowing()) {
            this.editor.editItem();
            return;
        }
        String id = ClientUtils.getRowId(this.table);
        this.startEdit(id);
    }

    @Override
    public void deleteItem() {
        if (this.editor.isShowing()) {
            this.editor.deleteItem();
            return;
        }
        String id = ClientUtils.getRowId(this.table);
        if (id != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0421\u043a\u0440\u0438\u043f\u0442 \u0443\u0434\u0430\u043b\u0438\u0442\u0441\u044f \u0432\u043c\u0435\u0441\u0442\u0435 \u0441 \u0431\u044d\u043a\u0430\u043f\u0430\u043c\u0438. \u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0441\u043a\u0440\u0438\u043f\u0442?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("DeleteGlobalScript");
            request.setAttribute("id", id);
            if (ClientUtils.checkStatus(this.getDocument(request))) {
                this.trySetData();
            }
        }
    }
}

