/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.event.processors;

import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.application.server.Lifecycle;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.limit.server.bean.LimitManager;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.processors.BalanceEventProcessor;
import ru.bitel.bgbilling.kernel.event.processors.CommonKernelEventProcessor;
import ru.bitel.bgbilling.kernel.event.processors.ScriptEventProcessor;
import ru.bitel.bgbilling.kernel.tariff.option.server.TariffOptionWorker;
import ru.bitel.bgbilling.server.util.Setup;

public class ServerEventProcessor
implements Lifecycle {
    final TariffOptionWorker tariffOptionWorker;
    final BalanceEventProcessor balanceEventProcessor;
    private final ScriptEventProcessor scriptEventProcessor;
    final CommonKernelEventProcessor commonKernelEventProcessor;

    public ServerEventProcessor(Setup setup) throws BGException {
        EventProcessor ep = EventProcessor.getInstance();
        if (setup.get("no.event.process", null) == null) {
            this.balanceEventProcessor = new BalanceEventProcessor(setup);
            this.commonKernelEventProcessor = new CommonKernelEventProcessor(setup);
            EventProcessor.getInstance().addListener(new EventListener<PaymentEvent>(){

                @Override
                public void notify(PaymentEvent e, EventListenerContext ctx) throws BGException {
                    new LimitManager(ctx.getConnection()).clientPaymentEvent(e);
                }
            }, PaymentEvent.class);
            this.tariffOptionWorker = new TariffOptionWorker(ep, setup);
            this.scriptEventProcessor = new ScriptEventProcessor(setup, false);
        } else {
            this.balanceEventProcessor = null;
            this.tariffOptionWorker = null;
            this.scriptEventProcessor = null;
            this.commonKernelEventProcessor = null;
        }
    }

    @Override
    public void start() throws Exception {
        if (this.tariffOptionWorker != null) {
            this.tariffOptionWorker.start();
        }
        if (this.scriptEventProcessor != null) {
            this.scriptEventProcessor.start();
        }
    }

    @Override
    public void stop() throws Exception {
    }
}

