/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius;

import java.nio.ByteBuffer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeInfo;
import ru.bitel.bgbilling.kernel.network.radius.RadiusDictionary;
import ru.bitel.bgbilling.kernel.network.tlv.Tlv;

public class RadiusAttribute<V>
extends Tlv<RadiusAttributeInfo<V>, V> {
    private static final Logger log = LogManager.getLogger();
    protected final int tag;
    int bufferPosition;

    public int getTag() {
        return this.tag;
    }

    public RadiusAttribute(RadiusAttributeInfo<V> info, int tag, ByteBuffer data, V value) {
        super(info, data, value);
        this.tag = tag;
    }

    protected RadiusAttribute(RadiusAttributeInfo<V> info, int tag, ByteBuffer data) {
        super(info, data);
        this.tag = tag;
    }

    protected RadiusAttribute(RadiusAttributeInfo<V> info, int tag, V value) {
        super(info, value);
        this.tag = tag;
    }

    public RadiusAttribute(int vendor, int type, int tag, ByteBuffer data) {
        this((RadiusAttributeInfo<ByteBuffer>)RadiusDictionary.getAttributeInfo(vendor, type), tag, data);
    }

    public RadiusAttribute(int vendor, int type, int tag, V value) {
        this(RadiusDictionary.getAttributeInfo(vendor, type), tag, value);
    }

    public RadiusAttribute(int vendor, int type, ByteBuffer data) {
        this((RadiusAttributeInfo<ByteBuffer>)RadiusDictionary.getAttributeInfo(vendor, type), 0, data);
    }

    ByteBuffer getDataInternal() {
        return this.data;
    }

    public RadiusAttribute<V> clone() {
        if (this.data.isDirect()) {
            return new RadiusAttribute<ByteBuffer>((RadiusAttributeInfo<ByteBuffer>)((RadiusAttributeInfo)this.info), this.tag, ByteBuffer.wrap(this.getDataAsByteArray()));
        }
        return new RadiusAttribute<ByteBuffer>((RadiusAttributeInfo<ByteBuffer>)((RadiusAttributeInfo)this.info), this.tag, this.data.duplicate());
    }

    static RadiusAttribute<?> newInstance(int vendor, int type, ByteBuffer data) {
        return RadiusDictionary.newRadiusAttribute(vendor, type, data);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean withName) {
        if (withName) {
            StringBuilder result = new StringBuilder(100);
            result.append(((RadiusAttributeInfo)this.info).name);
            if (((RadiusAttributeInfo)this.info).tag == 1 || ((RadiusAttributeInfo)this.info).tag == 2 && this.tag > 0) {
                result.append(":");
                result.append(this.tag);
            }
            result.append("=");
            String valueToString = "";
            try {
                valueToString = ((RadiusAttributeInfo)this.info).valueToString(this);
            }
            catch (Exception e) {
                log.error("Error while value print", (Throwable)e);
                valueToString = "error!!";
            }
            result.append(valueToString);
            return result.toString();
        }
        return ((RadiusAttributeInfo)this.info).valueToString(this);
    }

    public void write(ByteBuffer bb) {
        ((RadiusAttributeInfo)this.info).write(this, bb);
    }

    public boolean equals(Object o) {
        if (o instanceof RadiusAttribute) {
            try {
                Object value1 = this.getValue();
                Object value2 = ((RadiusAttribute)o).getValue();
                if (value1 != null && value2 != null && value1.equals(value2)) {
                    return true;
                }
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return false;
    }

    public static class RadiusAttributeAbinary
    extends RadiusAttribute<String> {
        protected RadiusAttributeAbinary(RadiusAttributeInfo<String> info, int tag, ByteBuffer data) {
            super(info, tag, data);
        }

        protected RadiusAttributeAbinary(RadiusAttributeInfo<String> info, int tag, String data) {
            super(info, tag, data);
        }

        public RadiusAttributeAbinary(int vendor, int type, ByteBuffer data) {
            super(vendor, type, 0, data);
        }

        public RadiusAttributeAbinary(int vendor, int type, String data) {
            super(vendor, type, 0, data);
        }

        public RadiusAttributeAbinary(int vendor, int type, int tag, ByteBuffer data) {
            super(vendor, type, tag, data);
        }

        public RadiusAttributeAbinary(int vendor, int type, int tag, String data) {
            super(vendor, type, tag, data);
        }

        @Deprecated
        public String getStringValue() {
            return (String)this.getValue();
        }

        @Override
        public RadiusAttributeAbinary clone() {
            if (this.data.isDirect()) {
                return new RadiusAttributeAbinary((RadiusAttributeInfo<String>)((RadiusAttributeInfo)this.info), this.tag, ByteBuffer.wrap(this.getDataAsByteArray()));
            }
            return new RadiusAttributeAbinary((RadiusAttributeInfo<String>)((RadiusAttributeInfo)this.info), this.tag, this.data.duplicate());
        }
    }

    public static class RadiusAttributeIpAddr
    extends RadiusAttributeInteger {
        protected RadiusAttributeIpAddr(RadiusAttributeInfo<Integer> info, int tag, ByteBuffer data) {
            super(info, tag, data);
        }

        public RadiusAttributeIpAddr(RadiusAttributeInfo<Integer> info, int tag, int value) {
            super(info, tag, value);
        }

        public RadiusAttributeIpAddr(int vendor, int type, int value) {
            super(vendor, type, value);
        }

        public RadiusAttributeIpAddr(int vendor, int type, int tag, int value) {
            super(vendor, type, value);
        }

        @Override
        public RadiusAttributeIpAddr clone() {
            return new RadiusAttributeIpAddr((RadiusAttributeInfo<Integer>)((RadiusAttributeInfo)this.info), this.tag, (int)((Integer)this.getValue()));
        }
    }

    public static class RadiusAttributeInteger
    extends RadiusAttribute<Integer> {
        protected RadiusAttributeInteger(RadiusAttributeInfo<Integer> info, int tag, ByteBuffer data) {
            super(info, tag, data);
        }

        public RadiusAttributeInteger(RadiusAttributeInfo<Integer> info, int tag, int value) {
            super(info, tag, Integer.valueOf(value));
        }

        public RadiusAttributeInteger(int vendor, int type, int value) {
            this(RadiusDictionary.getAttributeInfo(vendor, type), 0, value);
        }

        public RadiusAttributeInteger(int vendor, int type, int tag, int value) {
            this(RadiusDictionary.getAttributeInfo(vendor, type), tag, value);
        }

        @Deprecated
        public final int getIntValue() {
            return (Integer)this.getValue();
        }

        @Override
        public RadiusAttributeInteger clone() {
            return new RadiusAttributeInteger((RadiusAttributeInfo<Integer>)((RadiusAttributeInfo)this.info), this.tag, (int)((Integer)this.getValue()));
        }
    }

    public static class RadiusAttributeString
    extends RadiusAttribute<String> {
        protected RadiusAttributeString(RadiusAttributeInfo<String> info, int tag, ByteBuffer data) {
            super(info, tag, data);
        }

        protected RadiusAttributeString(RadiusAttributeInfo<String> info, int tag, String data) {
            super(info, tag, RadiusAttributeString.controlStringLength(data));
        }

        public RadiusAttributeString(int vendor, int type, int tag, ByteBuffer data) {
            this(RadiusDictionary.getAttributeInfo(vendor, type), tag, data);
        }

        public RadiusAttributeString(int vendor, int type, ByteBuffer data) {
            this(RadiusDictionary.getAttributeInfo(vendor, type), 0, data);
        }

        public RadiusAttributeString(int vendor, int type, String data) {
            this(RadiusDictionary.getAttributeInfo(vendor, type), 0, data);
        }

        public RadiusAttributeString(int vendor, int type, int tag, String data) {
            this(RadiusDictionary.getAttributeInfo(vendor, type), tag, data);
        }

        @Override
        public RadiusAttributeString clone() {
            if (this.data.isDirect()) {
                return new RadiusAttributeString((RadiusAttributeInfo<String>)((RadiusAttributeInfo)this.info), this.tag, ByteBuffer.wrap(this.getDataAsByteArray()));
            }
            return new RadiusAttributeString((RadiusAttributeInfo<String>)((RadiusAttributeInfo)this.info), this.tag, this.data.duplicate());
        }

        private static final String controlStringLength(String value) {
            if (value.length() > 252) {
                log.error("Too long attribute value: '" + value + "', cutting..");
                return value.substring(0, 252);
            }
            return value;
        }
    }
}

