/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.base.client;

import bitel.billing.module.services.ServicePanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.lang.reflect.Constructor;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.EventSubscriber;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.base.client.ContractEditor;
import ru.bitel.bgbilling.kernel.contract.base.client.ContractPanel;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.common.Utils;

public class ContractPanel_Report
extends ContractPanel
implements EventSubscriber<UpdateContractTreeEvent> {
    private JTabbedPane reportTabbedPane = new JTabbedPane();
    private boolean inited = false;

    public ContractPanel_Report(ContractEditor editor) {
        this.init(editor);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        EventBus.subscribe(UpdateContractTreeEvent.class, (EventSubscriber)this);
    }

    private void jbInit() throws Exception {
        this.reportTabbedPane.setTabPlacement(1);
        this.setLayout(new GridBagLayout());
        this.add(this.reportTabbedPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setData() {
        if (!this.inited) {
            this.inited = true;
            this.refreshSelectedPanel();
        }
    }

    protected void refreshSelectedPanel() {
        JPanel panel = this.getSelectedTab();
        if (panel != null) {
            if (panel instanceof BGPanel) {
                ((BGPanel)panel).trySetData();
            } else if (panel instanceof BGUPanel) {
                ((BGUPanel)panel).performAction("refresh");
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "refresh") {
            this.refreshSelectedPanel();
            return;
        }
        super.actionPerformed(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(ContractEditor editor) {
        super.init(editor);
        if (this.reportTabbedPane.getTabCount() == 0) {
            try {
                this.reportTabbedPane.removeAll();
                List<BGModule> contractModules = ((ModuleService)this.getContext().getWebService(ModuleService.class, 0)).contractModules(this.getContractId());
                if (Utils.notEmptyCollection(contractModules)) {
                    for (BGModule bgModule : contractModules) {
                        int packageID = bgModule.getId();
                        String packageName = bgModule.getInstalledModule().getPackageClient();
                        String packageTitle = bgModule.getTitle();
                        if (packageName == null || packageTitle == null || packageID == -1) continue;
                        try {
                            String className = packageName + ".ServiceReportPanel";
                            String module = ClientUtils.getValueFromResourceBundle((String)(packageName + ".setup"), (String)"module.id", (String)this.module);
                            ClientContext context = new ClientContext(module, packageID, this.getContractId(), this.rb_name);
                            ClientContext.push((ClientContext)context);
                            try {
                                JPanel panel = (JPanel)Utils.newInstance((String)className, JPanel.class);
                                if (panel instanceof ServicePanel) {
                                    ((ServicePanel)panel).init(this.getContractId(), packageID);
                                } else {
                                    if (!(panel instanceof BGUPanel)) continue;
                                    Constructor<?> constructor = panel.getClass().getConstructor(ClientContext.class);
                                    panel = (BGUPanel)constructor.newInstance(context);
                                }
                                this.reportTabbedPane.add((Component)panel, packageTitle);
                            }
                            finally {
                                ClientContext.pop();
                            }
                        }
                        catch (Exception ex) {
                            ClientUtils.showErrorMessageDialog((Throwable)ex);
                        }
                    }
                }
                this.reportTabbedPane.addChangeListener(e -> {
                    if (!this.fl) {
                        this.refreshSelectedPanel();
                    }
                });
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
    }

    private JPanel getSelectedTab() {
        return (JPanel)this.reportTabbedPane.getSelectedComponent();
    }

    public void deleteItem() {
        Component comp = this.reportTabbedPane.getSelectedComponent();
        if (comp instanceof BGPanel) {
            ((BGPanel)comp).deleteItem();
        }
    }

    public void editItem() {
        Component comp = this.reportTabbedPane.getSelectedComponent();
        if (comp instanceof BGPanel) {
            ((BGPanel)comp).editItem();
        }
    }

    public void onEvent(UpdateContractTreeEvent event) {
        this.inited = false;
        this.fl = true;
        if (event.getContractId() == this.getContractId()) {
            while (this.reportTabbedPane.getTabCount() > 0) {
                this.reportTabbedPane.removeTabAt(0);
            }
            this.init(this.editor);
        }
        this.fl = false;
    }
}

