/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common;

import bitel.billing.module.common.BGDialog;
import bitel.billing.module.common.CheckListCellRenderer;
import bitel.billing.module.common.CheckListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import ru.bitel.bgbilling.client.common.BGTabPanel;
import ru.bitel.bgbilling.client.common.BGUTabPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.common.client.BGButtonPanel;
import ru.bitel.common.client.list.BGUList;

public class TabbedClose
extends BGDialog {
    BGUList<BGUListItem> tabsList = new BGUList();

    public TabbedClose() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        this.tabsList.setCellRenderer(new CheckListCellRenderer());
        new CheckListener(this.tabsList);
        WindowAdapter wndCloser = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TabbedClose.this.setListItemSelected(false);
                TabbedClose.this.setVisible(false);
            }
        };
        this.addWindowListener(wndCloser);
        this.pack();
        this.moveWindowToCenterScreen();
    }

    private void jbInit() throws Exception {
        JScrollPane jScrollPane = new JScrollPane(this.tabsList);
        jScrollPane.setPreferredSize(new Dimension(300, 200));
        BGButtonPanel bGControlPanel_06 = new BGButtonPanel(BGButtonPanel.SELECTALL, BGButtonPanel.CLEAR, BGButtonPanel.GLUE, BGButtonPanel.OK, BGButtonPanel.CANCEL);
        bGControlPanel_06.addActionListener(e -> this.bGControlPanel_06_actionPerformed(e));
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this.setTitle("\u0417\u0430\u043a\u0440\u044b\u0442\u044c \u0432\u043a\u043b\u0430\u0434\u043a\u0438");
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 0, 10), 0, 0));
        this.getContentPane().add((Component)bGControlPanel_06, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
    }

    void setListItemSelected(boolean selected) {
        ListModel object = this.tabsList.getModel();
        if (object instanceof DefaultListModel) {
            DefaultListModel model = (DefaultListModel)object;
            for (int i = 0; i < model.getSize(); ++i) {
                Object object2 = model.getElementAt(i);
                if (!(object2 instanceof BGUListItem)) continue;
                BGUListItem item = (BGUListItem)object2;
                item.setSelected(selected);
            }
            this.tabsList.repaint();
        }
    }

    void bGControlPanel_06_actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (BGButtonPanel.SELECTALL.getActionCommand().equals(actionCommand)) {
            this.setListItemSelected(true);
        } else if (BGButtonPanel.CLEAR.getActionCommand().equals(actionCommand)) {
            this.setListItemSelected(false);
        } else if (BGButtonPanel.OK.getActionCommand().equals(actionCommand)) {
            this.setVisible(false);
        } else if (BGButtonPanel.CANCEL.getActionCommand().equals(actionCommand)) {
            this.setListItemSelected(false);
            this.setVisible(false);
        }
    }

    public void setTabsList(Component[] tabs) {
        if (tabs == null || tabs.length == 0) {
            return;
        }
        ArrayList<BGUListItem> items = new ArrayList<BGUListItem>();
        for (int i = 0; i < tabs.length; ++i) {
            BGUListItem item = null;
            Component component = tabs[i];
            if (component instanceof BGTabPanel) {
                BGTabPanel panel = (BGTabPanel)component;
                item = new BGUListItem(0, panel.getTabTitle());
            } else {
                component = tabs[i];
                if (!(component instanceof BGUTabPanel)) continue;
                BGUTabPanel panel = (BGUTabPanel)component;
                item = new BGUListItem(0, panel.getTabTitle());
            }
            item.setAttribute("id", tabs[i]);
            items.add(item);
        }
        this.tabsList.setData(items);
    }

    public Vector<Object> getTabsList() {
        Vector<Object> list = new Vector<Object>();
        ListModel model = this.tabsList.getModel();
        for (int i = 0; i < ((DefaultListModel)model).size(); ++i) {
            BGUListItem item = (BGUListItem)((DefaultListModel)model).getElementAt(i);
            if (!item.isSelected()) continue;
            list.addElement(item.getAttribute("id"));
        }
        return list;
    }
}

