/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.phone.client;

import bitel.billing.module.common.BGSelectFilePanel;
import bitel.billing.module.common.IntTextField;
import jakarta.activation.DataHandler;
import jakarta.xml.ws.Holder;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.EventHandler;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.phone.client.ServiceConfigRangeMap;
import ru.bitel.bgbilling.kernel.base.phone.common.bean.RangeMap;
import ru.bitel.bgbilling.kernel.base.phone.common.bean.RangeMapItem;
import ru.bitel.bgbilling.kernel.base.phone.common.service.RangeMapService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;

class RangeMapTreeEditor
extends BGUPanel {
    RangeMapService rangeMapService = ((ClientContext)this.getContext()).getPort(RangeMapService.class);
    private final ServiceConfigRangeMap serviceConfigRangeMap;
    private int currentMapId = -1;
    private BGUTable treeTable;
    private BGTableModel<RangeMapItem> model;
    private BGEditor editor;
    private int selected = 0;

    public RangeMapTreeEditor(ServiceConfigRangeMap serviceConfigRangeMap) {
        super(new GridBagLayout());
        this.serviceConfigRangeMap = serviceConfigRangeMap;
        this.setName("tree");
    }

    @Override
    protected void jbInit() {
        this.model = new BGTableModel<RangeMapItem>("phoneCode"){

            @Override
            protected void initColumns() {
                this.addColumn("\u0414\u0438\u0430\u043f\u0430\u0437\u043e\u043d", RangeMapItem.class, -1, 300, -1, null, false);
                this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", -1, 250, -1, null, false);
                this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, 300, -1, "title", false);
            }

            @Override
            public Object getValue(RangeMapItem val, int column) throws Exception {
                switch (column) {
                    case 0: {
                        return val.toString();
                    }
                    case 1: {
                        return TimeUtils.formatPeriod(val.getDateFrom(), val.getDateTo());
                    }
                }
                return super.getValue(val, column);
            }
        };
        this.treeTable = new BGUTable(this.model);
        this.editor = new BGEditor();
        this.editor.addForm(new RangeMapTreeItemEditor());
        this.editor.addForm(new RangeMapImport());
        this.editor.addForm(new RangeMapExport());
        this.editor.setVisible(false);
        this.editor.setBorder(new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 "));
        BGDialogToolBar toolBar = new BGDialogToolBar();
        toolBar.setDefaultButtons(e -> this.editor.performAction(e.getActionCommand()), BGDialogToolBar.ButtonData.IMPORT, BGDialogToolBar.ButtonData.EXPORT);
        toolBar.setFloatable(false);
        toolBar.compact();
        this.add((Component)toolBar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 3), 0, 0));
        BGTextField find = new BGTextField(20);
        JPanel panel = new JPanel(new GridBagLayout());
        BGButton findButton = new BGButton("\u041d\u0430\u0439\u0442\u0438");
        panel.add((Component)find, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 5), 0, 0));
        panel.add((Component)findButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 5), 0, 0));
        panel.add(Box.createHorizontalGlue(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 5), 0, 0));
        ActionListener actionListener = e -> {
            RangeMapItem item;
            int i;
            int size;
            String text = find.getText();
            List<RangeMapItem> list = this.model.getRows();
            int from = -1;
            RangeMapItem sel = this.model.getSelectedRow();
            if (sel != null) {
                size = list.size();
                for (i = 0; i < size; ++i) {
                    item = list.get(i);
                    if (item != sel) continue;
                    from = i;
                    break;
                }
            }
            size = list.size();
            for (i = from + 1; i < size; ++i) {
                item = list.get(i);
                if (!item.matches(text)) continue;
                this.model.setSelectedRow(item);
                return;
            }
            size = from;
            for (i = 0; i < size; ++i) {
                item = list.get(i);
                if (!item.matches(text)) continue;
                this.model.setSelectedRow(item);
                return;
            }
        };
        findButton.addActionListener(actionListener);
        find.addActionListener(actionListener);
        this.add((Component)panel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 0, 3), 0, 0));
        this.add((Component)new JScrollPane(this.treeTable), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 0, 3), 0, 0));
        this.add((Component)this.editor, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 0, 3), 0, 0));
        this.editor.addPropertyChangeListener("edit", EventHandler.create(PropertyChangeListener.class, this.treeTable, "enabled", "oldValue"));
        this.editor.addActionListener("ok", e -> this.setData());
        BGButton close = new BGButton("\u0417\u0430\u043a\u0440\u044b\u0442\u044c");
        close.addActionListener(e -> this.performActionClose());
        this.add((Component)close, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 3, 3, 3), 0, 0));
        BGSwingUtilites.handleEdit(this.treeTable, this.editor);
    }

    @Override
    protected void initActions() {
    }

    public void setData() {
        RangeMap rangeMap = this.serviceConfigRangeMap.table.model.getSelectedRow();
        if (rangeMap != null) {
            this.setBorder(new BGTitleBorder("\u0413\u0440\u0443\u043f\u043f\u0430 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u043e\u0432 \"" + rangeMap.getTitle() + "\""));
            this.currentMapId = rangeMap.getId();
            List<RangeMapItem> list = null;
            try {
                list = this.rangeMapService.rangeMapItemList(this.currentMapId, null);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
            if (list != null) {
                this.model.setData(list);
                if (this.selected != 0) {
                    // empty if block
                }
                this.selected = 0;
                this.performActionOpen();
            }
        }
    }

    class RangeMapTreeItemEditor
    extends BGUPanel {
        private int currentId;
        private BGTextField rangeFrom;
        private BGTextField rangeTo;
        private BGControlPanelPeriodNoB periodNoB;
        private BGTextField title;

        public RangeMapTreeItemEditor() {
            super(new GridBagLayout());
            this.rangeFrom = new BGTextField();
            this.rangeTo = new BGTextField();
            this.periodNoB = new BGControlPanelPeriodNoB();
            this.title = new BGTextField();
            this.setName("itemEdiitor");
        }

        @Override
        protected void jbInit() {
            this.rangeFrom.setHorizontalAlignment(0);
            this.rangeTo.setHorizontalAlignment(0);
            this.add((Component)new JLabel("\u0414\u0438\u0430\u043f\u0430\u0437\u043e\u043d:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 0), 0, 0));
            this.add((Component)this.rangeFrom, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 17, 2, new Insets(3, 3, 3, 0), 0, 0));
            this.add((Component)new JLabel("-"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 3, 3, 0), 0, 0));
            this.add((Component)this.rangeTo, new GridBagConstraints(3, 0, 1, 1, 0.5, 0.0, 17, 2, new Insets(3, 3, 3, 5), 0, 0));
            this.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434:"), new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 0), 0, 0));
            this.add((Component)this.periodNoB, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
            this.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 0), 0, 0));
            this.add((Component)this.title, new GridBagConstraints(1, 1, 5, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        }

        @Override
        protected void initActions() {
            new AbstractBGUPanel.BGActionNew(e -> {
                this.currentId = 0;
                this.rangeFrom.setEditable(true);
                this.rangeFrom.setText("");
                this.rangeTo.setEditable(true);
                this.rangeTo.setText("");
                this.periodNoB.setDateString1("");
                this.periodNoB.setDateString2("");
                this.title.setText("");
                this.performActionOpen();
            });
            new AbstractBGUPanel.BGActionEdit(e -> {
                RangeMapItem item = RangeMapTreeEditor.this.model.getSelectedRow();
                if (item != null) {
                    this.currentId = item.getId();
                    this.rangeFrom.setEditable(true);
                    this.rangeFrom.setText(item.getRangeFrom());
                    this.rangeTo.setEditable(true);
                    this.rangeTo.setText(item.getRangeTo());
                    this.periodNoB.setDateCalendar1(TimeUtils.convertDateToCalendar(item.getDateFrom()));
                    this.periodNoB.setDateCalendar2(TimeUtils.convertDateToCalendar(item.getDateTo()));
                    this.title.setText(item.getTitle());
                    this.performActionOpen();
                }
            });
            new AbstractBGUPanel.BGActionDelete(e -> {
                RangeMapItem item = RangeMapTreeEditor.this.model.getSelectedRow();
                if (item != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                    RangeMapTreeEditor.this.rangeMapService.rangeMapItemDelete(RangeMapTreeEditor.this.currentMapId, item.getId());
                    this.performActionClose();
                    RangeMapTreeEditor.this.setData();
                }
            });
            new AbstractBGUPanel.DefaultAction("ok", "Ok"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    int id;
                    RangeMapItem item = new RangeMapItem();
                    item.setId(RangeMapTreeItemEditor.this.currentId);
                    item.setRangeFrom(RangeMapTreeItemEditor.this.rangeFrom.getText());
                    item.setRangeTo(RangeMapTreeItemEditor.this.rangeTo.getText());
                    item.setDateFrom(RangeMapTreeItemEditor.this.periodNoB.getDateFrom());
                    item.setDateTo(RangeMapTreeItemEditor.this.periodNoB.getDateTo());
                    item.setTitle(RangeMapTreeItemEditor.this.title.getText());
                    RangeMapTreeEditor.this.selected = id = RangeMapTreeEditor.this.rangeMapService.rangeMapItemUpdate(RangeMapTreeEditor.this.currentMapId, item);
                    RangeMapTreeItemEditor.this.performActionClose();
                }
            };
        }
    }

    class RangeMapImport
    extends BGUPanel {
        private JRadioButton fileSource;
        private JRadioButton clipSource;
        private JRadioButton importLoad;
        private JRadioButton importUpdate;
        private BGSelectFilePanel fileSelect;
        private IntTextField prefix;
        private JTextArea clipboard;

        public RangeMapImport() {
            super(new GridBagLayout());
            this.fileSource = new JRadioButton("\u0444\u0430\u0439\u043b\u0430");
            this.clipSource = new JRadioButton("\u0431\u0443\u0444\u0435\u0440\u0430 \u043e\u0431\u043c\u0435\u043d\u0430");
            this.importLoad = new JRadioButton("\u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c");
            this.importUpdate = new JRadioButton("\u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c");
            this.setName("import");
        }

        @Override
        protected void jbInit() {
            this.fileSelect = new BGSelectFilePanel();
            this.prefix = new IntTextField();
            this.clipboard = new JTextArea();
            this.clipboard.setEditable(false);
            ButtonGroup group = new ButtonGroup();
            group.add(this.fileSource);
            group.add(this.clipSource);
            group = new ButtonGroup();
            group.add(this.importLoad);
            group.add(this.importUpdate);
            this.add((Component)new JLabel("\u0412\u0437\u044f\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435 \u0438\u0437: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 0), 0, 0));
            this.add((Component)this.fileSource, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
            this.add((Component)this.clipSource, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
            this.add((Component)new JLabel("\u041e\u043f\u0446\u0438\u0438 \u0438\u043c\u043f\u043e\u0440\u0442\u0430: "), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 3, 0, 0), 0, 0));
            this.add((Component)this.importLoad, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
            this.add((Component)this.importUpdate, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
            this.add((Component)new JLabel("\u0424\u0430\u0439\u043b:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 0), 0, 0));
            this.add((Component)this.fileSelect, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 5, 0, 3), 0, 0));
            this.add((Component)new JLabel("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043f\u0440\u0435\u0444\u0438\u043a\u0441:"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 0), 0, 0));
            this.add((Component)this.prefix, new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 17, 0, new Insets(3, 5, 0, 3), 0, 0));
            new IntTextField();
            this.add((Component)new JLabel("\u0421\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435 \u0431\u0443\u0444\u0435\u0440\u0430:"), new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 0), 0, 0));
            this.add((Component)BGSwingUtilites.wrapScrollPane(this.clipboard, 100, 150), new GridBagConstraints(0, 5, 3, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
            this.fileSource.setSelected(true);
            this.importLoad.setSelected(true);
        }

        @Override
        protected void initActions() {
            new AbstractBGUPanel.BGActionRefresh(e -> RangeMapTreeEditor.this.setData());
            new AbstractBGUPanel.DefaultAction("import", "import"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws BGException {
                    try {
                        RangeMapImport.this.clipboard.setText((String)RangeMapImport.this.getToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor));
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog(ex);
                    }
                    RangeMapImport.this.performActionOpen();
                }
            };
            new AbstractBGUPanel.DefaultAction("ok", "\u0418\u043c\u043f\u043e\u0440\u0442"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    String data = null;
                    if (RangeMapImport.this.fileSource.isSelected()) {
                        File file = RangeMapImport.this.fileSelect.getSelectedFile();
                        if (file == null) {
                            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u0430\u0439\u043b!");
                            return;
                        }
                        try {
                            data = new String(Utils.readByBlock(new FileInputStream(file)), "UTF-8");
                        }
                        catch (Exception ex) {
                            ClientUtils.showErrorMessageDialog("\u041e\u0448\u0438\u0431\u043a\u0430: " + ex.getMessage());
                            return;
                        }
                    } else {
                        data = RangeMapImport.this.clipboard.getText();
                    }
                    if (Utils.isBlankString(data)) {
                        ClientUtils.showErrorMessageDialog("\u041d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445!");
                        return;
                    }
                    RangeMapTreeEditor.this.rangeMapService.rangeMapImport(RangeMapTreeEditor.this.currentMapId, RangeMapImport.this.importUpdate.isSelected(), RangeMapImport.this.prefix.getText(), data);
                    RangeMapImport.this.performActionClose();
                }
            };
        }
    }

    private class RangeMapExport
    extends BGUPanel {
        private JRadioButton exportAll;
        private JRadioButton exportSelected;
        private BGSelectFilePanel fileSelect;

        public RangeMapExport() {
            super(new GridBagLayout());
            this.exportAll = new JRadioButton("\u0432\u0441\u0451");
            this.exportSelected = new JRadioButton("\u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u0443\u0437\u0435\u043b");
            this.setName("export");
        }

        @Override
        protected void jbInit() {
            ButtonGroup group = new ButtonGroup();
            group.add(this.exportAll);
            group.add(this.exportSelected);
            this.exportAll.setSelected(true);
            this.fileSelect = new BGSelectFilePanel();
            this.add((Component)new JLabel("\u0424\u0430\u0439\u043b:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 0), 0, 0));
            this.add((Component)this.fileSelect, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 5, 3, 3), 0, 0));
        }

        @Override
        protected void initActions() {
            new AbstractBGUPanel.DefaultAction("export", "export"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws BGException {
                    RangeMapExport.this.performActionOpen();
                }
            };
            new AbstractBGUPanel.DefaultAction("ok", "\u042d\u043a\u0441\u043f\u043e\u0440\u0442"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws BGException {
                    File file = RangeMapExport.this.fileSelect.getSelectedFile();
                    if (file == null) {
                        ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u0430\u0439\u043b!");
                        return;
                    }
                    try {
                        Holder data = new Holder();
                        RangeMapTreeEditor.this.rangeMapService.rangeMapExport(RangeMapTreeEditor.this.currentMapId, null, (Holder<DataHandler>)data);
                        FileOutputStream fos = new FileOutputStream(file);
                        ((DataHandler)data.value).writeTo((OutputStream)fos);
                        fos.flush();
                        fos.close();
                        RangeMapExport.this.performActionClose();
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog(ex);
                    }
                }
            };
        }
    }
}

