/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius.datalog;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import ru.bitel.bgbilling.kernel.base.server.datalog.BGDataLog;
import ru.bitel.bgbilling.kernel.base.server.datalog.BGDataLogReader;
import ru.bitel.bgbilling.kernel.base.server.datalog.ReadableDataLog;
import ru.bitel.bgbilling.kernel.base.server.datalog.WritableDataLog;
import ru.bitel.bgbilling.kernel.network.radius.datalog.RadiusDataLogReader;
import ru.bitel.bgbilling.kernel.network.radius.datalog.RadiusDataLogWriter;

public class RadiusDataLog
extends BGDataLog<RadiusDataLog>
implements ReadableDataLog<BGDataLogReader<?>>,
WritableDataLog<RadiusDataLogWriter> {
    public static final int DATALOG_TYPE_RADIUS = 2;
    private volatile Boolean streamed;
    private RadiusDataLogWriter streamedWriter;

    public RadiusDataLog(int id, File file, RandomAccessFile raf, FileChannel channel) {
        super(id, file, raf, channel, 2);
    }

    @Override
    public BGDataLogReader<?> newReader(Map<String, Object> params) {
        if (!this.inited) {
            throw new IllegalStateException();
        }
        return this.initReader(new RadiusDataLogReader(this));
    }

    @Override
    protected boolean readTLV(int type, int length, ByteBuffer readBuffer) throws IOException {
        if (!super.readTLV(type, length, readBuffer)) {
            switch (type) {
                case 10: {
                    if (this.version >= 4) break;
                    BGDataLog.Streaming streaming = new BGDataLog.Streaming();
                    this.readParameter(readBuffer, STREAMING, streaming, length);
                    this.setParameter(STREAMING, streaming);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RadiusDataLogWriter newWriter(Map<String, Object> params) {
        if (!this.inited) {
            throw new IllegalStateException();
        }
        if (this.streamed == null) {
            this.lock.lock();
            try {
                BGDataLog.Streaming streamed = this.getParameter(STREAMING);
                this.streamed = streamed != null && streamed.value > 0;
            }
            finally {
                this.lock.unlock();
            }
        }
        if (!this.streamed.booleanValue()) {
            return this.initWriter(new RadiusDataLogWriter(this));
        }
        this.lock.lock();
        try {
            if (this.streamedWriter == null) {
                this.streamedWriter = this.initWriter(new RadiusDataLogWriter(this){

                    @Override
                    public void flush() throws IOException {
                        ReentrantLock lock = RadiusDataLog.this.lock;
                        lock.lock();
                        try {
                            super.flush();
                        }
                        finally {
                            lock.unlock();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void writeRecord(ByteBuffer byteBuffer, long time, int[] positionArray) throws IOException {
                        ReentrantLock lock = RadiusDataLog.this.lock;
                        lock.lock();
                        try {
                            super.writeRecord(byteBuffer, time, positionArray);
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                });
            }
            RadiusDataLogWriter radiusDataLogWriter = this.streamedWriter;
            return radiusDataLogWriter;
        }
        finally {
            this.lock.unlock();
        }
    }
}

