/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.basic.server.action.web;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.container.web.action.ActionMessage;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariff;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariffGroup;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.PersonalTariff;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.tariff.ContractTariffDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.tariff.ContractTariffGroupDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.tariff.PersonalTariffManager;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.CancelTariffEvent;
import ru.bitel.bgbilling.kernel.event.events.ChangeTariffByTaskEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractTariffDeleteEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractTariffUpdateEvent;
import ru.bitel.bgbilling.kernel.event.events.GetChangeTariffDatesEvent;
import ru.bitel.bgbilling.kernel.event.events.GetTariffListEvent;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffGroup;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffGroupTariff;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffPlan;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffGroupDao;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffPlanDao;
import ru.bitel.bgbilling.kernel.tariff.server.event.ContractTariffChangedEvent;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.Sorter;

public class ActionTariffPlan
extends AbstractAction {
    private Date now = new Date();

    public ActionTariffPlan() {
        super("contract");
    }

    @Override
    public void execute() throws BGException {
        this.setResultParam("jspPage", "contract/tariff_plan.jsp");
        if (this.req.getBoolean("getBody", false)) {
            this.requestDispatcher(this.moduleName, "../contract/tariff_plan");
        }
    }

    public void tariff() throws Exception {
        try (TariffGroupDao tariffGroupDao = new TariffGroupDao(this.con);
             TariffPlanDao tariffPlanDao = new TariffPlanDao(this.con);){
            ContractTariffDao contractTariffDao = new ContractTariffDao(this.con);
            Map<Integer, TariffPlan> tariffMap = tariffPlanDao.getTariffPlanMap();
            List<ContractTariff> contractTariffList = contractTariffDao.list(this.contractId, null).stream().filter(t -> t.getPeriod().getDateTo() == null || !TimeUtils.dateBefore(t.getPeriod().getDateTo(), this.now)).collect(Collectors.toList());
            List<PersonalTariff> personalTariffList = new PersonalTariffManager(this.con).getPersonalTariffList(this.contractId);
            ArrayList list = new ArrayList();
            HashMap cancelMap = new HashMap();
            Sorter<ContractTariff, PersonalTariff, Date> sorter = this.getSorter(contractTariffList, personalTariffList);
            while (sorter.hasNext()) {
                ContractTariff contractTariff;
                Date date1 = null;
                Date date2 = null;
                HashMap<String, Object> row = new HashMap<String, Object>();
                Object next = sorter.getNext();
                if (next instanceof PersonalTariff) {
                    PersonalTariff personalTariff = (PersonalTariff)next;
                    date1 = TimeUtils.convertCalendarToDate(personalTariff.getDate1());
                    date2 = TimeUtils.convertCalendarToDate(personalTariff.getDate2());
                    row.put("title", personalTariff.isUseTitleInWeb() ? personalTariff.getTitle() : personalTariff.getTitleWeb());
                    row.put("type", "1");
                } else if (next instanceof ContractTariff) {
                    contractTariff = (ContractTariff)next;
                    date1 = contractTariff.getPeriod().getDateFrom();
                    date2 = contractTariff.getPeriod().getDateTo();
                    row.put("type", "0");
                    row.put("id", contractTariff.getId());
                    row.put("fromTariffId", contractTariff.getReplacedFromContractTariffId());
                }
                row.put("date1", date1);
                row.put("date2", date2);
                if (date2 != null && TimeUtils.dateBefore(date2, this.now)) continue;
                if (next instanceof PersonalTariff) {
                    list.add(row);
                    continue;
                }
                contractTariff = (ContractTariff)next;
                row.put("comment", contractTariff.getComment());
                boolean canCancel = contractTariff.getReplacedFromContractTariffId() > 0 && TimeUtils.dateBefore(this.now, contractTariff.getPeriod().getDateFrom());
                row.put("canCancel", canCancel ? "1" : "0");
                if (!canCancel) {
                    list.add(row);
                } else {
                    cancelMap.put(contractTariff.getReplacedFromContractTariffId(), row);
                }
                row.put("contractTariffId", String.valueOf(contractTariff.getId()));
                row.put("tariffId", String.valueOf(contractTariff.getTariffPlanId()));
                int tariffPlanID = contractTariff.getTariffPlanId();
                TariffPlan plan = tariffMap.get(tariffPlanID);
                if (plan == null) continue;
                row.put("title", plan.isUseTitleInWeb() ? plan.getTitle() : plan.getTitleWeb());
                row.put("description", plan.getDescription());
                List<TariffPlan> changeTariffList = this.getToTariffPlanList(contractTariff, tariffMap, tariffGroupDao);
                if (changeTariffList.size() == 0) continue;
                row.put("toTariffList", changeTariffList);
            }
            this.setResultParam("tariffList", list);
            this.setResultParam("cancelMap", cancelMap);
        }
        this.requestDispatcher(this.moduleName, "tariff_plan_form");
    }

    public void selectTariff() throws Exception {
        int fromTariffId = this.req.getInt("fromTariffId", 0);
        try (TariffPlanDao tariffPlanDao = new TariffPlanDao(this.con);
             TariffGroupDao tariffGroupDao = new TariffGroupDao(this.con);){
            ContractTariffDao contractTariffDao = new ContractTariffDao(this.con);
            List<TariffPlan> changeTariffList = null;
            Map<Integer, TariffPlan> tariffMap = tariffPlanDao.getTariffPlanMap();
            ContractTariff contractTariff = (ContractTariff)contractTariffDao.get(fromTariffId);
            if (contractTariff != null) {
                changeTariffList = this.getGroupTariffList(contractTariff, tariffPlanDao, tariffGroupDao, tariffMap);
            }
            boolean noSelectTariff = contractTariff == null;
            noSelectTariff = noSelectTariff || contractTariff.getContractId() != this.contractId;
            noSelectTariff = noSelectTariff || contractTariff.getPeriod().getDateTo() != null;
            noSelectTariff = noSelectTariff || contractTariff.getPeriod().getDateFrom() != null && TimeUtils.dateBefore(this.now, contractTariff.getPeriod().getDateFrom());
            boolean bl = noSelectTariff = noSelectTariff || changeTariffList.isEmpty();
            if (noSelectTariff) {
                this.tariff();
            } else {
                this.setResultParam("mode", "selectTariff");
                this.setResultParam("tariffMap", tariffPlanDao.getTariffPlanMap());
                this.setResultParam("fromTariff", contractTariff);
                this.setResultParam("toTariffList", changeTariffList);
                this.requestDispatcher(this.moduleName, "tariff_plan_form");
            }
        }
    }

    public void selectDate() throws Exception {
        int fromTariffId = this.req.getInt("fromTariffId", 0);
        int toTariffId = this.req.getInt("toTariffId", 0);
        try (TariffPlanDao tariffPlanDao = new TariffPlanDao(this.con);
             TariffGroupDao tariffGroupDao = new TariffGroupDao(this.con);){
            TariffGroup tariffGroup;
            boolean noSelectDate;
            ContractTariffDao contractTariffDao = new ContractTariffDao(this.con);
            Map<Integer, TariffPlan> tariffMap = tariffPlanDao.getTariffPlanMap();
            ContractTariff fromContractTariff = (ContractTariff)contractTariffDao.get(fromTariffId);
            boolean bl = noSelectDate = fromContractTariff == null || fromContractTariff.getContractId() != this.contractId;
            if (!noSelectDate && (tariffGroup = (TariffGroup)tariffGroupDao.get(this.getTariffGroupId(fromContractTariff))) != null) {
                noSelectDate = true;
                for (TariffPlan toTariffPlan : this.getGroupTariffList(fromContractTariff, tariffPlanDao, tariffGroupDao, tariffMap)) {
                    if (toTariffId != toTariffPlan.getId()) continue;
                    this.setResultParam("toTariff", toTariffPlan);
                    this.setResultParam("changeTariffDate", this.getChangeTariffDate(tariffGroup, fromTariffId, toTariffId));
                    noSelectDate = false;
                    break;
                }
            }
            if (noSelectDate) {
                this.tariff();
            } else {
                this.setResultParam("mode", "selectDate");
                this.setResultParam("tariffMap", tariffPlanDao.getTariffPlanMap());
                this.setResultParam("fromTariff", fromContractTariff);
                this.requestDispatcher(this.moduleName, "tariff_plan_form");
            }
        }
    }

    public void list() throws Exception {
        try (TariffPlanDao tariffPlanDao = new TariffPlanDao(this.con);){
            Map<Integer, TariffPlan> tariffMap = tariffPlanDao.getTariffPlanMap();
            this.setResultParam("tariffMap", tariffMap);
            ArrayList list = new ArrayList();
            GregorianCalendar now = new GregorianCalendar();
            ContractTariffDao contractTariffDao = new ContractTariffDao(this.con);
            contractTariffDao.list(this.contractId, null).forEach(contractTariff -> {
                Period period = contractTariff.getPeriod();
                if (!TimeUtils.dateBeforeOrEq(period.getDateFrom(), now.getTime()) || period.getDateTo() != null && !TimeUtils.dateBeforeOrEq(now.getTime(), period.getDateTo())) {
                    list.add(contractTariff);
                }
            });
            this.setResultParam("tariffList", list);
        }
        this.requestDispatcher(this.moduleName, "tariff_plan_log");
    }

    public void cancelChangeTariff() throws Exception {
        int contractTariffId = this.req.getInt("contractTariffId", -1);
        ActionMessage message = new ActionMessage("tariffRoot", "tariff", "tariffPlanQuery", "\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430");
        ContractTariffDao contractTariffDao = new ContractTariffDao(this.con);
        ContractTariff contractTariff = (ContractTariff)contractTariffDao.get(contractTariffId);
        if (contractTariff == null) {
            message.setError("\u041e\u0428\u0418\u0411\u041a\u0410: \u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u044c \u043e \u0442\u0430\u0440\u0438\u0444\u0435 [#contractTariffId=" + contractTariffId + "]");
        } else if (contractTariff.getContractId() != this.contractId) {
            message.setError("\u041e\u0428\u0418\u0411\u041a\u0410: \u042d\u0442\u043e \u043d\u0435 \u0432\u0430\u0448 \u0442\u0430\u0440\u0438\u0444");
        } else if (contractTariff.getReplacedFromContractTariffId() <= 0) {
            message.setText("\u041e\u0428\u0418\u0411\u041a\u0410: \u041d\u0435\u0442 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043d\u0430 \u0447\u0442\u043e \u043e\u0442\u043c\u0435\u043d\u044f\u0442\u044c");
        } else {
            ContractTariff contractTariffPrevious = (ContractTariff)contractTariffDao.get(contractTariff.getReplacedFromContractTariffId());
            if (contractTariffPrevious == null) {
                this.setResultParam("error", "\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u044c \u043e \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0435\u043c \u0442\u0430\u0440\u0438\u0444\u0435 (contractTariffId=" + contractTariff.getReplacedFromContractTariffId() + ")");
                throw new BGException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u044c \u043e \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0435\u043c \u0442\u0430\u0440\u0438\u0444\u0435 (contractTariffId=" + contractTariff.getReplacedFromContractTariffId() + ")");
            }
            CancelTariffEvent event = new CancelTariffEvent(this.userId, this.contractId, contractTariff, contractTariffPrevious);
            event = EventProcessor.getInstance().request(event);
            if (Utils.notBlankString(event.getError())) {
                this.setResultParam("error", event.getError());
                throw new BGException(event.getError());
            }
            if (Utils.notBlankString(event.getMessage())) {
                message.setText(event.getMessage());
                this.setResultParam("message", event.getMessage());
            }
            if (!event.isProcessed()) {
                contractTariffPrevious.getPeriod().setDateTo(null);
                contractTariffDao.update(contractTariffPrevious);
                contractTariffDao.delete(contractTariff.getId());
            }
            this.context.publishAfterCommit(new ContractTariffChangedEvent(this.contractId));
            this.context.publishAfterCommit(new ContractTariffUpdateEvent(this.userId, this.contractId, contractTariffPrevious, false));
            this.context.publishAfterCommit(new ContractTariffDeleteEvent(this.userId, this.contractId, contractTariff.getId()));
        }
        this.setResultParam("message", message);
        this.requestDispatcher("include", "popup_message");
    }

    public void changeTariff() throws Exception {
        ActionMessage message;
        block28: {
            int fromTariffId = this.req.getInt("fromTariffId", 0);
            int toTariffId = this.req.getInt("toTariffId", 0);
            message = new ActionMessage("tariffRoot", "tariff", "tariffPlanQuery", "\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430");
            Date toTariffDate = TimeUtils.parseDate(this.req.get("toTariffDate"), "dd.MM.yyyy");
            try (TariffPlanDao tariffPlanDao = new TariffPlanDao(this.con);
                 TariffGroupDao tariffGroupDao = new TariffGroupDao(this.con);){
                ContractTariffDao contractTariffDao = new ContractTariffDao(this.con);
                ContractTariff fromContractTariff = (ContractTariff)contractTariffDao.get(fromTariffId);
                if (fromContractTariff == null || fromContractTariff.getContractId() != this.contractId) {
                    message.setError("\u041e\u0428\u0418\u0411\u041a\u0410: \u0418\u0441\u0445\u043e\u0434\u043d\u044b\u0439 \u0442\u0430\u0440\u0438\u0444 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d [#" + fromTariffId + "]");
                    break block28;
                }
                if (fromTariffId == toTariffId) {
                    message.setError("\u041e\u0428\u0418\u0411\u041a\u0410: \u0418\u0441\u0445\u043e\u0434\u043d\u044b\u0439 \u0438 \u0446\u0435\u043b\u0435\u0432\u043e\u0439 \u0442\u0430\u0440\u0438\u0444 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u044e\u0442 [#" + fromTariffId + "]");
                    break block28;
                }
                int tariffGroupId = this.getTariffGroupId(fromContractTariff);
                TariffGroup tariffGroup = (TariffGroup)tariffGroupDao.get(tariffGroupId);
                Optional<TariffGroupTariff> tariffGroupTariff = null;
                TariffPlan toTariffPlan = null;
                if (tariffGroup == null) {
                    message.setError("\u041e\u0428\u0418\u0411\u041a\u0410: \u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0442\u0430\u0440\u0438\u0444\u043d\u0430\u044f \u0433\u0440\u0443\u043f\u043f\u0430 [#" + tariffGroupId + "]");
                    break block28;
                }
                tariffGroupTariff = tariffGroup.getPlanList().stream().filter(t -> t.getId() == toTariffId).findFirst();
                if (!tariffGroupTariff.isPresent()) {
                    message.setError("\u041e\u0428\u0418\u0411\u041a\u0410: \u0426\u0435\u043b\u0435\u0432\u043e\u0439 \u0442\u0430\u0440\u0438\u0444 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u0433\u0440\u0443\u043f\u043f\u0435 [#" + toTariffId + "]");
                    break block28;
                }
                if (!TimeUtils.dateInRange(this.now, tariffGroupTariff.get().getDate1(), tariffGroupTariff.get().getDate2())) {
                    message.setError("\u041e\u0428\u0418\u0411\u041a\u0410: \u041f\u0435\u0440\u0438\u043e\u0434\u0430 \u0442\u0430\u0440\u0438\u0444\u0430 \u0432 \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u0439 \u0433\u0440\u0443\u043f\u043f\u0435 [" + TimeUtils.formatPeriod(tariffGroupTariff.get().getDate1(), tariffGroupTariff.get().getDate2()) + "]");
                    break block28;
                }
                toTariffPlan = (TariffPlan)tariffPlanDao.get(toTariffId);
                if (toTariffPlan == null) {
                    message.setError("\u041e\u0428\u0418\u0411\u041a\u0410: \u0426\u0435\u043b\u0435\u0432\u043e\u0439 \u0442\u0430\u0440\u0438\u0444 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d [#" + toTariffId + "]");
                    break block28;
                }
                if (!toTariffPlan.isUsed()) {
                    message.setError("\u041e\u0428\u0418\u0411\u041a\u0410: \u0426\u0435\u043b\u0435\u0432\u043e\u0439 \u0442\u0430\u0440\u0438\u0444 \u043f\u043e\u043c\u0435\u0447\u0435\u043d \u043a\u0430\u043a \"\u043d\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u044b\u0439\" [#" + toTariffId + "]");
                    break block28;
                }
                if (toTariffDate == null) {
                    message.setError("\u041e\u0428\u0418\u0411\u041a\u0410: \u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u0430 \u0434\u0430\u0442\u0430 \u0441\u043c\u0435\u043d\u044b \u0442\u0430\u0440\u0438\u0444\u0430");
                    break block28;
                }
                if (!this.getChangeTariffDate(tariffGroup, fromTariffId, toTariffId).stream().anyMatch(a -> {
                    System.out.println(a.getTime() + " " + a + " " + toTariffDate.getTime());
                    return a.getTime() == toTariffDate.getTime();
                })) {
                    message.setError("\u041e\u0428\u0418\u0411\u041a\u0410: \u041d\u0435 \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u0430\u044f \u0434\u0430\u0442\u0430 \u0441\u043c\u0435\u043d\u044b \u0442\u0430\u0440\u0438\u0444\u0430 [" + this.req.get("toTariffDate") + "]");
                    break block28;
                }
                ChangeTariffByTaskEvent event = new ChangeTariffByTaskEvent(this.userId, this.contractId, tariffGroup, fromContractTariff, toTariffPlan, toTariffDate);
                event = EventProcessor.getInstance().request(event);
                if (Utils.notBlankString(event.getError())) {
                    message.setError("\u041e\u0428\u0418\u0411\u041a\u0410: " + event.getError());
                } else if (Utils.notBlankString(event.getMessage())) {
                    message.setText(event.getMessage());
                }
                ContractTariff newTariff = null;
                if (!event.isProcessed() && fromContractTariff != null) {
                    try {
                        this.con.commit();
                        newTariff = new ContractTariff().setContractId(this.contractId).setPeriod(new Period(toTariffDate, null)).setPosition(tariffGroup.getPos()).setTariffGroupId(fromContractTariff.getTariffGroupId()).setTariffPlanId(toTariffId).setComment(this.setup.get("contract.tariff.change.comment", "\u0421\u043c\u0435\u043d\u0430 \u0442\u0430\u0440\u0438\u0444\u0430 \u0447\u0435\u0440\u0435\u0437 \u043b\u0438\u0447\u043d\u044b\u0439 \u043a\u0430\u0431\u0438\u043d\u0435\u0442")).setReplacedFromContractTariffId(fromContractTariff.getId());
                        contractTariffDao.update(newTariff);
                        fromContractTariff.getPeriod().setDateTo(TimeUtils.getPrevDay(toTariffDate));
                        if (TimeUtils.dateBefore(fromContractTariff.getPeriod().getDateTo(), fromContractTariff.getPeriod().getDateFrom())) {
                            contractTariffDao.delete(fromContractTariff.getId());
                        } else {
                            contractTariffDao.update(fromContractTariff);
                        }
                    }
                    catch (Exception ex) {
                        newTariff = null;
                        message.setText("\u041e\u0428\u0418\u0411\u041a\u0410: " + ex.getMessage());
                    }
                }
                this.context.publishAfterCommit(new ContractTariffChangedEvent(this.contractId));
                if (newTariff != null) {
                    this.context.publishAfterCommit(new ContractTariffUpdateEvent(this.userId, this.contractId, newTariff, true));
                    message.setText("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430");
                }
            }
        }
        this.setResultParam("message", message);
        this.requestDispatcher("include", "popup_message");
    }

    protected void setDataToRequest() throws BGException {
    }

    private Sorter<ContractTariff, PersonalTariff, Date> getSorter(List<ContractTariff> contractTariffList, List<PersonalTariff> personalTariffList) {
        Sorter<ContractTariff, PersonalTariff, Date> sorter = new Sorter<ContractTariff, PersonalTariff, Date>(contractTariffList, personalTariffList, true){

            @Override
            public Date getSecondValue(PersonalTariff personalTariff) {
                return personalTariff.getDate1().getTime();
            }

            @Override
            public Date getFirstValue(ContractTariff contractTariff) {
                return contractTariff.getPeriod().getDateFrom();
            }
        };
        return sorter;
    }

    private int getTariffGroupId(ContractTariff contractTariff) throws Exception {
        ContractTariffGroup contractTariffGroup;
        int tariffGroupId = contractTariff.getTariffGroupId();
        if (tariffGroupId < 0 && (contractTariffGroup = (ContractTariffGroup)new ContractTariffGroupDao(this.con).get(this.contractId)) != null) {
            tariffGroupId = contractTariffGroup.getTariffGroupId();
        }
        return tariffGroupId;
    }

    private List<TariffPlan> getGroupTariffList(ContractTariff contractTariff, TariffPlanDao tariffPlanDao, TariffGroupDao tariffGroupDao, Map<Integer, TariffPlan> tariffMap) throws Exception {
        TariffGroup tariffGroup;
        List<TariffPlan> changeTariffList = new ArrayList<TariffPlan>();
        if (contractTariff != null && (tariffGroup = (TariffGroup)tariffGroupDao.get(this.getTariffGroupId(contractTariff))) != null) {
            TariffPlan tariffPlan = (TariffPlan)tariffPlanDao.get(contractTariff.getTariffPlanId());
            changeTariffList = this.getGroupTariffList(tariffMap, tariffGroup, tariffPlan, contractTariff);
        }
        return changeTariffList;
    }

    private List<TariffPlan> getGroupTariffList(Map<Integer, TariffPlan> tariffMap, TariffGroup tariffGroup, TariffPlan tariffPlan, ContractTariff contractTariff) throws BGException {
        List<TariffPlan> changeTariffList = new ArrayList<TariffPlan>();
        List<TariffGroupTariff> tariffList = tariffGroup.getPlanList();
        for (TariffGroupTariff tariffGroupTariff : tariffList) {
            TariffPlan toPlan = tariffMap.get(tariffGroupTariff.getId());
            if (toPlan == null || tariffPlan.getId() == toPlan.getId() || !toPlan.isUsed() || !TimeUtils.dateInRange(this.now, tariffGroupTariff.getDate1(), tariffGroupTariff.getDate2())) continue;
            changeTariffList.add(toPlan);
        }
        GetTariffListEvent tariffListEvent = new GetTariffListEvent(this.contractId, contractTariff, tariffGroup, this.userId);
        tariffListEvent = EventProcessor.getInstance().request(tariffListEvent);
        List<TariffPlan> tariffListFromEvent = tariffListEvent.getTariffList();
        if (tariffListFromEvent != null) {
            changeTariffList = tariffListFromEvent;
        }
        return changeTariffList;
    }

    private List<TariffPlan> getToTariffPlanList(ContractTariff contractTariff, Map<Integer, TariffPlan> tariffMap, TariffGroupDao tariffGroupDao) throws Exception {
        List<TariffPlan> changeTariffList = new ArrayList<TariffPlan>();
        if (contractTariff.getPeriod().getDateTo() != null || contractTariff.getPeriod().getDateFrom() != null && TimeUtils.dateBefore(this.now, contractTariff.getPeriod().getDateFrom())) {
            return changeTariffList;
        }
        int tariffGroupId = this.getTariffGroupId(contractTariff);
        if (tariffGroupId < 1) {
            return changeTariffList;
        }
        TariffGroup tariffGroup = (TariffGroup)tariffGroupDao.get(tariffGroupId);
        if (tariffGroup != null) {
            TariffPlan plan = tariffMap.get(contractTariff.getTariffPlanId());
            changeTariffList = this.getGroupTariffList(tariffMap, tariffGroup, plan, contractTariff);
        }
        return changeTariffList;
    }

    private List<Date> getChangeTariffDate(TariffGroup tariffGroup, int fromTariffId, int toTariffId) throws BGException {
        GetChangeTariffDatesEvent event = new GetChangeTariffDatesEvent(this.userId, this.contractId, tariffGroup, this.now, fromTariffId, toTariffId);
        event = EventProcessor.getInstance().request(event);
        ArrayList<Date> changeTariffDate = new ArrayList();
        if (event.getDateList() != null) {
            changeTariffDate = event.getDateList();
        } else if (Utils.isEmptyString(event.getError())) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.set(11, 0);
            calendar.clear(12);
            calendar.clear(13);
            calendar.clear(14);
            int transferMode = tariffGroup.getTransferMode();
            int calendarField = 6;
            if (transferMode != 1) {
                if (transferMode == 4) {
                    ((Calendar)calendar).add(6, 1);
                } else if (transferMode == 2) {
                    calendarField = 3;
                    ((Calendar)calendar).add(3, 1);
                    calendar.set(7, 2);
                } else {
                    calendarField = 2;
                    ((Calendar)calendar).add(2, 1);
                    calendar.set(5, 1);
                }
            }
            Calendar limitDate = (Calendar)((Calendar)calendar).clone();
            limitDate.add(6, tariffGroup.getDaysForward());
            while (calendar.before(limitDate)) {
                changeTariffDate.add(calendar.getTime());
                ((Calendar)calendar).add(calendarField, 1);
            }
        }
        return changeTariffDate;
    }
}

