/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.range;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.tariff.server.range.TrafficRange;
import ru.bitel.bgbilling.kernel.tariff.server.range.TrafficRangeContract;
import ru.bitel.bgbilling.kernel.tariff.server.range.TrafficRangeDayContract;
import ru.bitel.bgbilling.kernel.tariff.server.range.TrafficRangeKey;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficRangeDetail;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficRangeDetailReport;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficRangeDetailValue;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public abstract class TrafficRangeDao
implements AutoCloseable {
    private final Connection con;
    private final int moduleId;
    protected String tableName;
    protected String detailTableNamePrefix;
    private PreparedStatement selectCounterAndAmountPS;
    private PreparedStatement updateAndSelectAmountPS;
    private PreparedStatement insertPS;
    private PreparedStatement selectAmountPS;
    private PreparedStatement updateDetailPS;
    private PreparedStatement insertDetailPS;
    private Date month;
    private int yy;
    private int mm;
    private int nextYy;
    private int nextMm;

    public TrafficRangeDao(Connection con, int moduleId) throws BGException {
        this.con = con;
        this.moduleId = moduleId;
    }

    public void setCurrentMonth(Date month) throws BGException {
        this.month = month;
        Calendar calendar = TimeUtils.convertDateToCalendar(this.month);
        this.yy = calendar.get(1);
        this.mm = calendar.get(2) + 1;
        TimeUtils.clear_HOUR_MIN_MIL_SEC(calendar);
        calendar.set(5, 1);
        this.nextYy = calendar.get(1);
        this.nextMm = calendar.get(2) + 1;
        try {
            if (this.insertPS != null) {
                this.insertPS.close();
            }
            if (this.updateDetailPS != null) {
                this.updateDetailPS.close();
            }
            if (this.insertDetailPS != null) {
                this.insertDetailPS.close();
            }
            if (this.updateAndSelectAmountPS != null) {
                this.updateAndSelectAmountPS.close();
            }
            if (this.selectCounterAndAmountPS != null) {
                this.selectCounterAndAmountPS.close();
            }
            this.selectCounterAndAmountPS = this.con.prepareStatement("SELECT counter, amount FROM " + this.tableName + " WHERE contractId=? AND treeNodeId=? AND rangeKey=? AND ((yy=? AND mm=?) OR (yy=? AND mm=?))");
            this.updateAndSelectAmountPS = this.con.prepareStatement("UPDATE " + this.tableName + " SET counter=counter+1, amount=amount+?, maxAmount=? WHERE contractId=? AND treeNodeId=? AND rangeKey=? AND ((yy=? AND mm=?) OR (yy=? AND mm=?)) ORDER BY yy, mm");
            this.insertPS = this.con.prepareStatement("INSERT INTO " + this.tableName + " ( contractId, treeNodeId, rangeKey, counter, amount, maxAmount, yy, mm ) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
            String detailTableName = ServerUtils.getModuleMonthTableName((String)this.detailTableNamePrefix, (Date)month, (int)this.moduleId);
            this.updateDetailPS = this.con.prepareStatement("UPDATE " + detailTableName + " SET amount=amount+? WHERE contractId=? AND treeNodeId=? AND rangeKey=? AND day=?");
            this.insertDetailPS = this.con.prepareStatement("INSERT INTO " + detailTableName + " (contractId, treeNodeId, rangeKey, day, amount) VALUES (?, ?, ?, ?, ?)");
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public int add(int contractId, TrafficRangeKey rangeKey, int day, long delta, long[] amountRef, long amount, int counter, long maxAmount) throws BGException {
        try {
            PreparedStatement updatePS = this.updateAndSelectAmountPS;
            updatePS.setLong(1, delta);
            updatePS.setLong(2, maxAmount);
            updatePS.setInt(3, contractId);
            updatePS.setLong(4, rangeKey.treeNodeId);
            updatePS.setLong(5, rangeKey.key);
            updatePS.setInt(6, this.yy);
            updatePS.setInt(7, this.mm);
            updatePS.setInt(8, this.nextYy);
            updatePS.setInt(9, this.nextMm);
            int i = 0;
            while (true) {
                if (updatePS.executeUpdate() > 0) {
                    this.selectCounterAndAmountPS.setInt(1, contractId);
                    this.selectCounterAndAmountPS.setLong(2, rangeKey.treeNodeId);
                    this.selectCounterAndAmountPS.setLong(3, rangeKey.key);
                    this.selectCounterAndAmountPS.setInt(4, this.yy);
                    this.selectCounterAndAmountPS.setInt(5, this.mm);
                    this.selectCounterAndAmountPS.setInt(6, this.nextYy);
                    this.selectCounterAndAmountPS.setInt(7, this.nextMm);
                    try (ResultSet rs = this.selectCounterAndAmountPS.executeQuery();){
                        if (rs.next()) {
                            counter = rs.getInt(1);
                            amountRef[0] = rs.getLong(2);
                            break;
                        }
                        counter = 0;
                        amountRef[0] = delta;
                        break;
                    }
                }
                try {
                    ++counter;
                    amountRef[0] = amount;
                    PreparedStatement insertPS = this.insertPS;
                    insertPS.setInt(1, contractId);
                    insertPS.setLong(2, rangeKey.treeNodeId);
                    insertPS.setLong(3, rangeKey.key);
                    insertPS.setLong(4, counter);
                    insertPS.setLong(5, amount);
                    insertPS.setLong(6, maxAmount);
                    insertPS.setInt(7, this.yy);
                    insertPS.setInt(8, this.mm);
                    insertPS.executeUpdate();
                }
                catch (SQLException e) {
                    if (e.getSQLState() == null || !e.getSQLState().startsWith("23") || i > 10) {
                        throw e;
                    }
                    ++i;
                    continue;
                }
                break;
            }
            this.addDetail(contractId, rangeKey, day, delta);
            return counter;
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    private void addDetail(int contractId, TrafficRangeKey rangeKey, int day, long delta) throws SQLException {
        PreparedStatement updatePS = this.updateDetailPS;
        updatePS.setLong(1, delta);
        updatePS.setInt(2, contractId);
        updatePS.setLong(3, rangeKey.treeNodeId);
        updatePS.setLong(4, rangeKey.key);
        updatePS.setLong(5, day);
        int i = 0;
        while (updatePS.executeUpdate() <= 0) {
            try {
                PreparedStatement insertPS = this.insertDetailPS;
                insertPS.setInt(1, contractId);
                insertPS.setLong(2, rangeKey.treeNodeId);
                insertPS.setLong(3, rangeKey.key);
                insertPS.setLong(4, day);
                insertPS.setLong(5, delta);
                insertPS.executeUpdate();
                break;
            }
            catch (SQLException e) {
                if (e.getSQLState() == null || !e.getSQLState().startsWith("23") || i > 10) {
                    throw e;
                }
                ++i;
            }
        }
    }

    public void checkTables(Connection con, Statement stmt, Date date, int mid) throws SQLException {
        String trafficRangeDetailTableName;
        if (!ServerUtils.tableExists((Connection)con, (String)this.tableName)) {
            stmt.executeUpdate("CREATE TABLE `" + this.tableName + "` ( `contractId` INT NOT NULL, `treeNodeId` bigint(20) NOT NULL, `rangeKey` bigint(20) NOT NULL, `amount` bigint(20) NOT NULL, `counter` INT NOT NULL, `maxAmount` bigint(20) NOT NULL DEFAULT '-1', `yy` int(11) NOT NULL, `mm` int(11) NOT NULL,PRIMARY KEY (`contractId`,`treeNodeId`,`rangeKey`,`yy`,`mm`) ) /*!50100 PARTITION BY HASH( contractId ) PARTITIONS 8*/");
        }
        if (!ServerUtils.tableExists((Connection)con, (String)(trafficRangeDetailTableName = ServerUtils.getModuleMonthTableName((String)this.detailTableNamePrefix, (Date)date, (int)mid)))) {
            stmt.executeUpdate("CREATE TABLE `" + trafficRangeDetailTableName + "` ( `contractId` INT NOT NULL, `treeNodeId` bigint(20) NOT NULL, `rangeKey` bigint(20) NOT NULL, `day` INT NOT NULL, `amount` bigint(20) NOT NULL, PRIMARY KEY `key`(`contractId`, `treeNodeId`, `rangeKey`, `day`) ) /*!50100 PARTITION BY HASH( contractId ) PARTITIONS 8*/");
        }
    }

    public void clear(Set<Integer> contractIds, Date dateFrom, Date dateTo) throws BGException {
        if (dateFrom == null || dateTo == null) {
            throw new BGIllegalArgumentException();
        }
        GregorianCalendar calendarFrom = new GregorianCalendar();
        calendarFrom.setTime(dateFrom);
        TimeUtils.clear_HOUR_MIN_MIL_SEC(calendarFrom);
        GregorianCalendar calendarTo = new GregorianCalendar();
        calendarTo.setTime(dateTo);
        TimeUtils.clear_HOUR_MIN_MIL_SEC(calendarTo);
        if (TimeUtils.compare(calendarFrom, calendarTo, 2) != 0) {
            throw new BGIllegalArgumentException();
        }
        String detailTableName = ServerUtils.getModuleMonthTableName((String)this.detailTableNamePrefix, (Date)calendarFrom.getTime(), (int)this.moduleId);
        StringBuilder sb = new StringBuilder(32);
        sb.append(detailTableName).append(" WHERE");
        if (contractIds != null) {
            sb.append(" contractId IN (").append(Utils.toString(contractIds)).append(") AND");
        }
        sb.append(" day>=? AND day<=?");
        String querySelect = "SELECT contractId, treeNodeId, rangeKey, SUM(amount) FROM " + sb.toString();
        String queryDelete = "DELETE FROM " + detailTableName;
        try (PreparedStatement psSelect = this.con.prepareStatement(querySelect);
             PreparedStatement psDelete = this.con.prepareStatement(queryDelete);){
            psSelect.setInt(1, calendarFrom.get(5));
            psSelect.setInt(2, calendarTo.get(5));
            psDelete.setInt(1, calendarFrom.get(5));
            psDelete.setInt(2, calendarTo.get(5));
            try (ResultSet rs = psSelect.executeQuery();){
                while (rs.next()) {
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    public void get(int contractId, TrafficRangeKey rangeKey, TrafficRange range) throws BGException {
        try {
            PreparedStatement ps = this.selectAmountPS;
            if (ps == null) {
                ps = this.selectAmountPS = this.con.prepareStatement("SELECT counter, amount, maxAmount FROM " + this.tableName + " WHERE contractId=? AND treeNodeId=? AND rangeKey=? ORDER BY yy DESC, mm DESC LIMIT 1");
            }
            ps.setInt(1, contractId);
            ps.setLong(2, rangeKey.treeNodeId);
            ps.setLong(3, rangeKey.key);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                range.counter = rs.getInt(1);
                range.amount = rs.getLong(2) + range.delta;
                range.maxAmount = rs.getLong(3);
            } else {
                range.counter = 0;
                range.amount = 0L;
            }
            rs.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    public void report(int contractId, Long treeNodeId, Date dateFrom, Date dateTo, TrafficRangeDetailReport report) throws BGException {
        try {
            LinkedHashMap<Long, TrafficRangeDetailValue> valueMap = new LinkedHashMap<Long, TrafficRangeDetailValue>();
            PreparedStatement ps = this.con.prepareStatement("SELECT rangeKey, amount, counter, maxAmount FROM " + this.tableName + " WHERE contractId=? AND treeNodeId=? AND yy=? AND mm=? ORDER BY rangeKey");
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(dateFrom);
            int yy = calendar.get(1);
            int mm = calendar.get(2) + 1;
            int dayFrom = calendar.get(5);
            calendar.setTime(dateTo);
            int dayTo = calendar.get(5);
            ps.setInt(1, contractId);
            ps.setLong(2, treeNodeId);
            ps.setLong(3, yy);
            ps.setLong(4, mm);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                long rangeKey = rs.getLong(1);
                long amount = rs.getLong(2);
                long maxAmount = rs.getLong(4);
                TrafficRangeDetailValue detailValue = new TrafficRangeDetailValue();
                detailValue.setRangeKey(rangeKey);
                detailValue.setAmount(amount);
                detailValue.setMaxAmount(maxAmount);
                valueMap.put(rangeKey, detailValue);
            }
            this.listDetail(contractId, treeNodeId, dateFrom, dayFrom, dayTo, calendar, valueMap);
            report.setDetailValueList(new ArrayList<TrafficRangeDetailValue>(valueMap.values()));
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    private void listDetail(int contractId, long treeNodeId, Date dateFrom, int dayFrom, int dayTo, Calendar calendar, LinkedHashMap<Long, TrafficRangeDetailValue> valueMap) throws BGException, SQLException {
        String tableName = ServerUtils.getModuleMonthTableName((String)this.detailTableNamePrefix, (Date)dateFrom, (int)this.moduleId);
        if (!ServerUtils.tableExists((Connection)this.con, (String)tableName)) {
            return;
        }
        String query = "SELECT rangeKey, day, amount FROM " + tableName + " WHERE contractId=? AND treeNodeId=? AND day>=? AND day<=? ORDER BY rangeKey, day";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.setLong(2, treeNodeId);
            ps.setLong(3, dayFrom);
            ps.setLong(4, dayTo);
            long currentRangeKey = -1L;
            ArrayList<TrafficRangeDetail> currentValueList = null;
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    long rangeKey = rs.getLong(1);
                    int day = rs.getInt(2);
                    long amount = rs.getLong(3);
                    if (currentRangeKey != rangeKey) {
                        currentValueList = null;
                        TrafficRangeDetailValue currentValue = valueMap.get(rangeKey);
                        if (currentValue != null) {
                            currentValueList = new ArrayList<TrafficRangeDetail>();
                            currentValue.setDetailList(currentValueList);
                        }
                        currentRangeKey = rangeKey;
                    }
                    if (currentValueList == null) continue;
                    currentValueList.add(new TrafficRangeDetail().setAmount(amount).setDay(day).setHour(TrafficRangeKey.getHourOfDay(rangeKey, calendar)));
                }
            }
        }
    }

    public List<TrafficRangeContract> contractTrafficRangeList(int contractId, LocalDate date) throws SQLException {
        Objects.requireNonNull(date, "date must be not null");
        ArrayList<TrafficRangeContract> trafficRangeContracts = new ArrayList<TrafficRangeContract>();
        String query = "SELECT * FROM " + this.tableName + " WHERE contractId=? AND yy=? AND mm=? ORDER BY rangeKey";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, contractId);
            ps.setInt(index++, date.getYear());
            ps.setInt(index++, date.getMonthValue());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    trafficRangeContracts.add(new TrafficRangeContract().setTreeNodeId(rs.getLong("treeNodeId")).setRangeKey(rs.getLong("rangeKey")).setCounter(rs.getLong("counter")).setAmount(rs.getLong("amount")).setMaxAmount(rs.getLong("maxAmount")));
                }
            }
        }
        return trafficRangeContracts;
    }

    public List<TrafficRangeDayContract> contractTrafficRangeDayList(int contractId, LocalDate date) throws SQLException {
        Objects.requireNonNull(date, "date must be not null");
        String tableName = ServerUtils.getModuleMonthTableName((String)this.detailTableNamePrefix, (LocalDate)date, (int)this.moduleId);
        if (!ServerUtils.tableExists((Connection)this.con, (String)tableName)) {
            return Collections.emptyList();
        }
        ArrayList<TrafficRangeDayContract> trafficRangeDayContracts = new ArrayList<TrafficRangeDayContract>();
        String query = "SELECT * FROM " + tableName + " WHERE contractId=? ORDER BY rangeKey";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, contractId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    trafficRangeDayContracts.add(new TrafficRangeDayContract().setTreeNodeId(rs.getLong("treeNodeId")).setRangeKey(rs.getLong("rangeKey")).setDay(rs.getInt("day")).setAmount(rs.getLong("amount")));
                }
            }
        }
        return trafficRangeDayContracts;
    }

    @Override
    public void close() {
        ServerUtils.recycle((Object[])new Object[]{this.selectCounterAndAmountPS, this.updateAndSelectAmountPS, this.insertPS, this.updateDetailPS, this.insertDetailPS});
    }
}

