/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.plugin.common;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.plugin.common.BGPlugInElement;
import ru.bitel.common.XMLUtils;

public abstract class BGPluginBase {
    private static Logger log = LogManager.getLogger();
    protected String id = null;
    protected String name = null;
    protected String version = null;
    protected Document document = null;
    private ResourceBundle resourceBundle = null;
    private Map<String, BGPlugInElement> extensionMap = new HashMap<String, BGPlugInElement>();
    private Set<Class<?>> eventPointSet = new HashSet();
    private Object eventObject = null;

    public void setDocument(Document document) throws Exception {
        this.document = document;
        Element rootElement = document.getDocumentElement();
        this.id = rootElement.getAttribute("id");
        this.name = rootElement.getAttribute("name");
        this.version = rootElement.getAttribute("version");
        for (Element extension : XMLUtils.selectElements((Node)document.getDocumentElement(), (String)"/plugin/extension")) {
            BGPlugInElement plugInElement = new BGPlugInElement();
            String point = extension.getAttribute("point");
            plugInElement.setElement(extension);
            plugInElement.setPlugin(this);
            if (point == null || point.trim().length() <= 0) continue;
            this.extensionMap.put(point, plugInElement);
        }
        try {
            Class<?> eventClass = Class.forName(this.getEventClassName());
            Class<?>[] interfaces = eventClass.getInterfaces();
            this.eventObject = eventClass.newInstance();
            for (Class<?> point : interfaces) {
                this.eventPointSet.add(point);
                if (!log.isDebugEnabled()) continue;
                log.debug("plugin event class " + this.getEventClassName() + " listen point " + point.getCanonicalName());
            }
        }
        catch (ClassNotFoundException e) {
            log.debug("not found plugin event class " + this.getEventClassName());
        }
        catch (Exception e) {
            throw new BGException("error plugin event class create instance", (Throwable)e);
        }
    }

    protected abstract String getEventClassName();

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.getResourceString(this.name);
    }

    public String getVersion() {
        return this.version;
    }

    public String getResourceString(String key) {
        String str = null;
        if (this.resourceBundle != null) {
            try {
                str = key.startsWith("%") ? this.resourceBundle.getString(key.substring(1)) : this.resourceBundle.getString(key);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (str == null) {
            str = key;
        }
        return str;
    }

    Map<String, BGPlugInElement> getExtensionMap() {
        return this.extensionMap;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public Set<Class<?>> getEventPointSet() {
        return this.eventPointSet;
    }

    public Object getEventObject() {
        return this.eventObject;
    }

    public <T> T getInvokeablePoint(Class<T> point) {
        T ip = null;
        if (point != null && this.eventPointSet.contains(point)) {
            try {
                ip = point.cast(this.eventObject);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return ip;
    }
}

