/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.common.util;

import java.sql.Connection;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.customer.CustomerLink;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.customer.CustomerDao;
import ru.bitel.bgbilling.kernel.customer.common.bean.Customer;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrEmail;

public class CustomerUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getValue(int contractId, String fieldKey, String defaultValue) {
        try (Connection connection = Setup.getSetup().getDBConnectionFromPool();){
            CustomerDao customerDao = new CustomerDao(connection);
            Optional<CustomerLink> optional = customerDao.getCustomerLink(contractId, LocalDateTime.now());
            if (!optional.isPresent()) return defaultValue;
            String string = customerDao.getCustomerParameter(optional.get().getCustomerId(), fieldKey);
            return string;
        }
        catch (Exception ex) {
            return "ERROR: " + ex.getLocalizedMessage();
        }
    }

    public static Customer.CustomerType getCustomerType(JSONObject customer) {
        return customer != null ? Customer.CustomerType.defineType(customer.optString("personType")) : null;
    }

    public static List<EntityAttrEmail.EmailContact> getContactEmails(JSONObject customer) {
        Object object;
        ArrayList<EntityAttrEmail.EmailContact> emails = new ArrayList<EntityAttrEmail.EmailContact>();
        if (customer != null && (object = customer.optQuery("/customer/contact/email")) instanceof JSONArray) {
            JSONArray customerContactEmail = (JSONArray)object;
            for (int index = 0; index < customerContactEmail.length(); ++index) {
                Object object2 = customerContactEmail.get(index);
                if (!(object2 instanceof JSONObject)) continue;
                JSONObject contact = (JSONObject)object2;
                emails.add(new EntityAttrEmail.EmailContact(contact.optString("name"), contact.optString("value")));
            }
        }
        return emails;
    }
}

