/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.call.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Date;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.modules.card.server.bean.Card;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class CardCallUtils {
    private int mid = -1;
    private Connection con;

    public CardCallUtils(Connection con, int mid) {
        this.con = con;
        this.mid = mid;
    }

    public int createLogin(int cid, Card card, int sessionCount) {
        int id;
        block20: {
            id = -1;
            if (card != null && (card.getStatus() == 2 || card.getStatus() == 1)) {
                Object query = null;
                try (ContractDao contractDao = new ContractDao(this.con, 0);){
                    Contract contract = (Contract)contractDao.get(cid);
                    if (contract == null) break block20;
                    query = "INSERT INTO user_login_" + this.mid + " ( cid, login, pswd, date1, date2, comment, session ) VALUES ( ?, ?, ?, ?, ?, ?, ? )";
                    try (PreparedStatement ps = this.con.prepareStatement((String)query, 1);){
                        ps.setInt(1, contract.getId());
                        ps.setLong(2, card.getCardCode());
                        ps.setString(3, card.getCardPinCode());
                        ps.setDate(4, TimeUtils.convertDateToSqlDate((Date)contract.getDateFrom()));
                        ps.setDate(5, TimeUtils.convertDateToSqlDate((Date)contract.getDateTo()));
                        ps.setString(6, "Card N " + card.getId());
                        ps.setInt(7, sessionCount);
                        ps.executeUpdate();
                        id = ServerUtils.lastInsertId(ps);
                    }
                    query = "INSERT INTO log_login_pswd VALUES ( NOW(), 0, ?, ? )";
                    ps = this.con.prepareStatement((String)query);
                    try {
                        ps.setInt(1, this.mid);
                        ps.setInt(2, id);
                        ps.executeUpdate();
                    }
                    finally {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return id;
    }
}

