/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.bgsecure.action;

import bitel.billing.server.contract.action.base.ActionBase;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.ActionExpressionData;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.ActionExpressionDataDao;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.BGSActionUtils;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.common.XMLUtils;

public class ActionGetAllModuleActions
extends ActionBase {
    private static Element actionslElement;
    private static Date lastLoadedTime;

    @Override
    public void doAction() throws Exception {
        if (this.resentlyWasLoaded() && actionslElement != null) {
            this.rootNode.appendChild(this.rootNode.getOwnerDocument().importNode(actionslElement, true));
            return;
        }
        lastLoadedTime = new Date();
        ActionExpressionDataDao actionExpressionDataDao = new ActionExpressionDataDao(this.con);
        HashMap actionExpressionDatas = new HashMap();
        actionExpressionDataDao.list().forEach(a -> {
            String name = a.getComponentId();
            ArrayList<ActionExpressionData> datas = (ArrayList<ActionExpressionData>)actionExpressionDatas.get(name);
            if (datas == null) {
                datas = new ArrayList<ActionExpressionData>();
                actionExpressionDatas.put(name, datas);
            }
            datas.add((ActionExpressionData)((Object)((Object)a)));
        });
        actionslElement = BGSActionUtils.fillXml(this.rootNode, "kernel", "0", "\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0439 \u043c\u043e\u0434\u0443\u043b\u044c");
        this.addExtAction((List)actionExpressionDatas.get("kernel"), "0");
        for (BGModule bGModule : ModuleCache.getInstance().getModulesList()) {
            String moduleId = String.valueOf(bGModule.getId());
            actionslElement = BGSActionUtils.fillXml(this.rootNode, bGModule.getName(), moduleId, bGModule.getTitle());
            this.addExtAction((List)actionExpressionDatas.get(bGModule.getName()), moduleId);
        }
        for (Map.Entry entry : BGPluginManagerServer.getManager().getPluginsMap().entrySet()) {
            actionslElement = BGSActionUtils.fillXml(this.rootNode, (String)entry.getKey(), "p" + ((BGPluginServer)entry.getValue()).getPluginUID(), ((BGPluginServer)entry.getValue()).getName());
            this.addExtAction((List)actionExpressionDatas.get(entry.getKey()), "p" + ((BGPluginServer)entry.getValue()).getPluginUID());
        }
    }

    private void addExtAction(List<ActionExpressionData> actionExpressionDatas, String id) throws Exception {
        if (actionExpressionDatas != null) {
            for (ActionExpressionData data : actionExpressionDatas) {
                Element serviceElement = XMLUtils.selectElement((Node)this.rootNode, (String)("/data/actions[@id=" + id + "]//service[@id=" + data.getServiceId() + "]"));
                if (serviceElement == null) continue;
                Element newServiceElement = serviceElement.getOwnerDocument().createElement("service");
                newServiceElement.setAttribute("id", String.valueOf(data.getServiceId() + "#" + data.getId()));
                newServiceElement.setAttribute("title", data.getTitle());
                newServiceElement.setAttribute("name", data.getServiceName());
                newServiceElement.setAttribute("operation", data.getServiceOperation());
                newServiceElement.setAttribute("expession", data.getServiceExpression());
                serviceElement.getParentNode().insertBefore(newServiceElement, serviceElement);
            }
        }
    }

    private boolean resentlyWasLoaded() {
        if (lastLoadedTime == null) {
            return false;
        }
        long diff = new Date().getTime() - lastLoadedTime.getTime();
        long seconds = TimeUnit.MILLISECONDS.toSeconds(diff);
        return seconds <= 60L;
    }

    static {
        lastLoadedTime = null;
    }
}

