/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.converters;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.kernel.base.converters.AbstractBGConverter;
import ru.bitel.bgbilling.kernel.contract.label.server.bean.ContractLabelManager;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Dispatch;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.condition.DispatchContractGroupCondition;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.condition.DispatchContractLabelCondition;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.condition.base.DispatchCondition;
import ru.bitel.bgbilling.plugins.dispatch.server.dao.DispatchDao;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;

public class ConverterGroupsToLabelsOnDispatches
extends AbstractBGConverter {
    private Connection connection;
    private DispatchDao dispatchDao;

    @Override
    public void runConverter(Connection connection) {
        BGPluginServer dispatchPlugin = this.findDispatchPlugin();
        if (dispatchPlugin == null) {
            return;
        }
        this.getLogger().info("\u0417\u0430\u043f\u0443\u0441\u043a \u043a\u043e\u043d\u0432\u0435\u0440\u0442\u0451\u0440\u0430 \u0434\u043b\u044f \u043f\u043b\u0430\u0433\u0438\u043d\u0430 Dispatch");
        this.connection = connection;
        this.dispatchDao = new DispatchDao(connection);
        try {
            List dispatchList = this.dispatchDao.getList();
            this.getLogger().info("\u0412\u0441\u0435\u0433\u043e \u0440\u0430\u0441\u0441\u044b\u043b\u043e\u043a \u0434\u043b\u044f \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438=" + dispatchList.size());
            if (Utils.isEmptyCollection((Collection)dispatchList)) {
                return;
            }
            this.convertConditionsOnDispatchList(dispatchList);
            this.getLogger().info("\u041a\u043e\u043d\u0432\u0435\u0440\u0442\u0451\u0440 \u0434\u043b\u044f \u043f\u043b\u0430\u0433\u0438\u043d\u0430 Dispatch \u0437\u0430\u043a\u043e\u043d\u0447\u0438\u043b \u0440\u0430\u0431\u043e\u0442\u0443");
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    private BGPluginServer findDispatchPlugin() {
        BGPluginManagerServer pluginManager = BGPluginManagerServer.getManager();
        for (Map.Entry<String, BGPluginServer> plugin : pluginManager.getPluginsMap().entrySet()) {
            if (!"ru.bitel.bgbilling.plugins.dispatch".equals(plugin.getValue().getId())) continue;
            return plugin.getValue();
        }
        return null;
    }

    private void convertConditionsOnDispatchList(List<Dispatch> dispatchList) throws Exception {
        ContractLabelManager contractLabelManager = new ContractLabelManager(this.connection);
        List allLabelIds = contractLabelManager.getContractLabelItemList(false).stream().mapToInt(Id::getId).boxed().collect(Collectors.toList());
        for (Dispatch dispatch : dispatchList) {
            List conditions = dispatch.getConditions();
            if (Utils.isEmptyCollection((Collection)conditions)) continue;
            ArrayList<Object> newConditions = new ArrayList<Object>();
            for (DispatchCondition condition : conditions) {
                if (condition instanceof DispatchContractGroupCondition) {
                    this.getLogger().info("\u0411\u044b\u043b\u043e \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0441\u0442\u0430\u0440\u043e\u0435 \u0443\u0441\u043b\u043e\u0432\u0438\u0435 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438 \u043f\u043e \u0433\u0440\u0443\u043f\u043f\u0430\u043c \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0434\u043b\u044f \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0438: " + dispatch.getTitle());
                    long groups = ((DispatchContractGroupCondition)condition).getGroups();
                    List groupsIds = Utils.toIntegerList((String)Utils.maskToEnum((long)groups)).stream().mapToInt(x -> x + 2).boxed().collect(Collectors.toList());
                    ArrayList<Integer> selectedLabelIds = new ArrayList<Integer>();
                    for (Integer groupId : groupsIds) {
                        if (!allLabelIds.contains(groupId)) continue;
                        selectedLabelIds.add(groupId);
                    }
                    DispatchContractLabelCondition contractLabelCondition = new DispatchContractLabelCondition();
                    contractLabelCondition.setLabels(new HashSet(selectedLabelIds));
                    newConditions.add(contractLabelCondition);
                    continue;
                }
                newConditions.add(condition);
            }
            dispatch.setConditions(newConditions);
            this.dispatchDao.update((Object)dispatch);
        }
    }
}

