/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import bitel.billing.module.common.BGDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class ErrorDialog
extends BGDialog {
    private JButton more = new JButton("\u041f\u043e\u0434\u0440\u043e\u0431\u043d\u043e\u0441\u0442\u0438");
    private JButton copy = new JButton("\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0432 \u0431\u0443\u0444\u0435\u0440");
    private JButton cancel = new JButton("\u0417\u0430\u043a\u0440\u044b\u0442\u044c");
    private JTextArea textArea;
    private JScrollPane scrollPane;

    public ErrorDialog(String stackTrace, String message) {
        this(stackTrace, message, true, false);
    }

    public ErrorDialog(String stackTrace, String message, boolean isNeedCopyButton, boolean isWarning) {
        int k;
        message = message.startsWith("ru.bitel.bgbilling.common.BGMessageException:") ? message.substring("ru.bitel.bgbilling.common.BGMessageException:".length()).trim() : ((k = message.indexOf("\n")) > 1 ? message.substring(0, k) : message);
        this.getContentPane().setLayout(new GridBagLayout());
        this.setModal(true);
        this.setResizable(false);
        this.textArea = new JTextArea(stackTrace);
        this.textArea.setEditable(false);
        this.scrollPane = new JScrollPane(this.textArea);
        this.scrollPane.setVisible(false);
        this.scrollPane.setPreferredSize(new Dimension(800, 500));
        Icon icon = UIManager.getIcon(isWarning ? "OptionPane.warningIcon" : "OptionPane.errorIcon");
        JLabel label = new JLabel(icon);
        this.add((Component)label, new GridBagConstraints(0, 0, 1, 4, 0.0, 0.0, 11, 0, new Insets(5, 5, 0, 10), 0, 0));
        this.add((Component)new JLabel((String)(message.length() > 100 ? message.substring(0, 100) + "..." : message)), new GridBagConstraints(1, 0, 3, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 10, 10), 0, 0));
        this.add((Component)this.scrollPane, new GridBagConstraints(1, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 10), 0, 0));
        this.add((Component)this.getButtonPanel(isNeedCopyButton), new GridBagConstraints(1, 2, 3, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 10, 10), 0, 0));
        this.pack();
        this.moveWindowToCenterScreen();
        Dimension pS = this.getPreferredSize();
        if (pS.width > 1900) {
            this.setSize(1900, pS.height);
        }
        this.more.addActionListener(e -> {
            if (!this.scrollPane.isVisible()) {
                this.scrollPane.setVisible(true);
                this.more.setVisible(false);
                this.setResizable(true);
                this.pack();
                this.setLocationRelativeTo(null);
            }
        });
        this.cancel.addActionListener(e -> this.dispose());
        this.copy.addActionListener(e -> Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(stackTrace), null));
    }

    private JPanel getButtonPanel(boolean isNeedCopyButton) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.more, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        if (isNeedCopyButton) {
            panel.add((Component)this.copy, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        }
        panel.add((Component)this.cancel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }
}

